/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.items.custom;

import com.gedrite.sounds.ModSoundEvents;
import com.gedrite.util.ModTags;
import java.util.function.Consumer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MetalDetectorItem
extends Item {
    public MetalDetectorItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide()) {
            level.playSound(null, new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ()), ModSoundEvents.METAL_DETECTOR_USE.get(), SoundSource.BLOCKS);
            boolean foundBlock = false;
            int sphereRadius = 8;
            int radiusSq = sphereRadius * sphereRadius;
            for (int x = -sphereRadius; x <= sphereRadius; ++x) {
                block1: for (int y = -sphereRadius; y <= sphereRadius; ++y) {
                    for (int z = -sphereRadius; z <= sphereRadius; ++z) {
                        BlockState state;
                        BlockPos blockPos = new BlockPos(player.getOnPos().getX() + x, player.getOnPos().getY() + y, player.getOnPos().getZ() + z);
                        int distanceSq = x * x + y * y + z * z;
                        if (distanceSq > radiusSq || !this.isValuableBlock(state = level.getBlockState(blockPos))) continue;
                        this.outputValuableCoordinates(blockPos, player, state.getBlock());
                        foundBlock = true;
                        continue block1;
                    }
                }
            }
            if (!foundBlock) {
                player.displayClientMessage((Component)Component.translatable((String)"gedrite.metal_detector.dontFoundBlock"), true);
            }
        }
        player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
        return InteractionResult.SUCCESS;
    }

    private void outputValuableCoordinates(BlockPos blockPos, Player player, Block block) {
        player.displayClientMessage((Component)Component.translatable((String)"gedrite.metal_detector.foundBlock"), true);
        player.displayClientMessage((Component)Component.literal((String)(I18n.get((String)block.getDescriptionId(), (Object[])new Object[0]) + " (" + blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ() + ")")), true);
    }

    private boolean isValuableBlock(BlockState state) {
        return state.is(ModTags.Blocks.METAL_BLOCKS_FOR_MD);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay tooltipDisplay, @NotNull Consumer<Component> tooltipComponent, @NotNull TooltipFlag flag) {
        tooltipComponent.accept((Component)Component.translatable((String)"tooltip.gedrite.metal_detector.tooltip"));
        super.appendHoverText(stack, context, tooltipDisplay, tooltipComponent, flag);
    }
}

