/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.world.level.material;

import com.gedrite.blocks.ModBlocks;
import com.gedrite.core.particles.ModParticles;
import com.gedrite.fluids.ModFluidTypes;
import com.gedrite.fluids.ModFluids;
import com.gedrite.items.ModItems;
import com.gedrite.util.ModTags;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class GedritedWaterFluid
extends FlowingFluid {
    @NotNull
    public Fluid getFlowing() {
        return (Fluid)ModFluids.FLOWING_GEDRITED_WATER.get();
    }

    @NotNull
    public Fluid getSource() {
        return (Fluid)ModFluids.SOURCE_GEDRITED_WATER.get();
    }

    protected boolean canConvertToSource(ServerLevel p_369955_) {
        return false;
    }

    @NotNull
    public Item getBucket() {
        return (Item)ModItems.GEDRITED_WATER_BUCKET.get();
    }

    @NotNull
    public FluidType getFluidType() {
        return (FluidType)ModFluidTypes.GEDRITED_WATER_FLUID_TYPE.get();
    }

    public void animateTick(@NotNull Level level, @NotNull BlockPos pos, FluidState state, @NotNull RandomSource random) {
        if (random.nextInt(50) == 0) {
            level.addParticle((ParticleOptions)ModParticles.DECAY_PARTICLE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.0, Math.sin(level.getGameTime()), 1.0, Math.sin(level.getGameTime()));
        }
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return (ParticleOptions)ModParticles.DRIPPING_GEDRITED_WATER.get();
    }

    protected void spreadTo(@NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockState pBlockState, @NotNull Direction pDirection, @NotNull FluidState pFluidState) {
        FluidState fluidstate;
        if (pDirection == Direction.DOWN && (fluidstate = pLevel.getFluidState(pPos)).is(FluidTags.WATER)) {
            if (pBlockState.getBlock() instanceof LiquidBlock) {
                pLevel.setBlock(pPos, Blocks.COARSE_DIRT.defaultBlockState(), 3);
            }
            this.playSplashSound(pLevel, pPos);
            return;
        }
        super.spreadTo(pLevel, pPos, pBlockState, pDirection, pFluidState);
    }

    private void playSplashSound(LevelAccessor level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void beforeDestroyingBlock(@NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, BlockState pState) {
        BlockEntity blockentity = pState.hasBlockEntity() ? pLevel.getBlockEntity(pPos) : null;
        Block.dropResources((BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos, (BlockEntity)blockentity);
    }

    public int getSlopeFindDistance(@NotNull LevelReader pLevel) {
        return 3;
    }

    @NotNull
    public BlockState createLegacyBlock(@NotNull FluidState pState) {
        return (BlockState)((LiquidBlock)ModBlocks.GEDRITED_WATER_BLOCK.get()).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(GedritedWaterFluid.getLegacyLevel((FluidState)pState)));
    }

    public boolean isSource(@NotNull FluidState pState) {
        return false;
    }

    public boolean isSame(@NotNull Fluid pFluid) {
        return pFluid == ModFluids.SOURCE_GEDRITED_WATER.get() || pFluid == ModFluids.FLOWING_GEDRITED_WATER.get();
    }

    public int getDropOff(@NotNull LevelReader pLevel) {
        return 2;
    }

    public int getAmount(@NotNull FluidState pState) {
        return 0;
    }

    public int getTickDelay(@NotNull LevelReader pLevel) {
        return 20;
    }

    public boolean canBeReplacedWith(@NotNull FluidState pFluidState, @NotNull BlockGetter pBlockReader, @NotNull BlockPos pPos, @NotNull Fluid pFluid, @NotNull Direction pDirection) {
        return pDirection == Direction.DOWN && (!pFluid.is(FluidTags.WATER) || !pFluid.is(ModTags.Fluids.GEDRITED_WATER));
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    public static class Source
    extends GedritedWaterFluid {
        @Override
        public int getAmount(@NotNull FluidState pState) {
            return 8;
        }

        @Override
        public boolean isSource(@NotNull FluidState pState) {
            return true;
        }
    }

    public static class Flowing
    extends GedritedWaterFluid {
        protected void createFluidStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull StateDefinition.Builder<Fluid, FluidState> pBuilder) {
            super.createFluidStateDefinition(pBuilder);
            pBuilder.add(new Property[]{LEVEL});
        }

        @Override
        public int getAmount(FluidState pState) {
            return (Integer)pState.getValue((Property)LEVEL);
        }
    }
}

