/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.worldgen;

import com.gedrite.worldgen.ModConfiguredFeatures;
import com.gedrite.worldgen.ModOrePlacement;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> GEDRITE_ORE_SMALL_PLACED_KEY = ModPlacedFeatures.registerKey("ore_gedrite");
    public static final ResourceKey<PlacedFeature> GEDRITE_ORE_BURIED_PLACED_KEY = ModPlacedFeatures.registerKey("ore_gedrite_buried");
    public static final ResourceKey<PlacedFeature> GEDRITE_ORE_LARGE_PLACED_KEY = ModPlacedFeatures.registerKey("ore_gedrite_large");
    public static final ResourceKey<PlacedFeature> GEDRITE_ORE_MEDIUM_PLACED_KEY = ModPlacedFeatures.registerKey("ore_gedrite_medium");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, GEDRITE_ORE_SMALL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.GEDRITE_ORE_SMALL_KEY), ModOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, GEDRITE_ORE_BURIED_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.GEDRITE_ORE_SMALL_KEY), ModOrePlacement.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, GEDRITE_ORE_LARGE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.GEDRITE_ORE_SMALL_KEY), ModOrePlacement.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, GEDRITE_ORE_MEDIUM_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.GEDRITE_ORE_SMALL_KEY), ModOrePlacement.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-4))));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

