/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.datagen;

import com.gedrite.blocks.ModBlocks;
import com.gedrite.items.ModItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final List<ItemLike> GEDRITE_SMELTABLES = List.of((ItemLike)ModItems.RAW_GEDRITE.get(), (ItemLike)ModBlocks.GEDRITE_ORE.get(), (ItemLike)ModBlocks.DEEPSLATE_GEDRITE_ORE.get());

    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ModRecipeProvider.oreSmelting(recipeOutput, GEDRITE_SMELTABLES, RecipeCategory.MISC, (ItemLike)ModItems.GEDRITE_INGOT.get(), 0.7f, 200, "gedrite");
        ModRecipeProvider.oreBlasting(recipeOutput, GEDRITE_SMELTABLES, RecipeCategory.MISC, (ItemLike)ModItems.GEDRITE_INGOT.get(), 0.7f, 100, "gedrite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GEDRITE_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.GEDRITE_INGOT.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.GEDRITE_INGOT.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.GEDRITE_INGOT.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GEDRITE_INGOT.get()), (int)9).requires((ItemLike)ModBlocks.GEDRITE_BLOCK.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.GEDRITE_BLOCK.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.GEDRITE_BLOCK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.RAW_GEDRITE_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.RAW_GEDRITE.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.RAW_GEDRITE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.RAW_GEDRITE.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RAW_GEDRITE.get()), (int)9).requires((ItemLike)ModBlocks.RAW_GEDRITE_BLOCK.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.RAW_GEDRITE_BLOCK.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.RAW_GEDRITE_BLOCK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GEDRITED_COAL.get())).pattern("g g").pattern("###").pattern("g g").define(Character.valueOf('g'), (ItemLike)ModItems.GEDRITE_INGOT.get()).define(Character.valueOf('#'), (ItemLike)Items.COAL).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.GEDRITE_INGOT.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.GEDRITE_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.METAL_DETECTOR.get())).pattern("l#l").pattern("igi").pattern(" i ").define(Character.valueOf('#'), (ItemLike)ModBlocks.GEDRITE_BLOCK.get()).define(Character.valueOf('l'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.GEDRITE_BLOCK.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.GEDRITE_BLOCK.get()))).save(recipeOutput);
    }

    protected static void oreSmelting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    private static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput pRecipeOutput, RecipeSerializer<T> pSerializer, AbstractCookingRecipe.Factory<T> pRecipeFactory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pSuffix) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pSerializer, pRecipeFactory).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(pRecipeOutput, ModRecipeProvider.getItemName((ItemLike)pResult) + pSuffix + "_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

