/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.worldgen;

import com.gedrite.blocks.ModBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEDRITE_ORE_SMALL_KEY = ModConfiguredFeatures.registerKey("ore_gedrite_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEDRITE_ORE_BURIED_KEY = ModConfiguredFeatures.registerKey("ore_gedrite_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEDRITE_ORE_LARGE_KEY = ModConfiguredFeatures.registerKey("ore_gedrite_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEDRITE_ORE_MEDIUM_KEY = ModConfiguredFeatures.registerKey("ore_gedrite_medium");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> overworldGedriteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)ModBlocks.GEDRITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_GEDRITE_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, GEDRITE_ORE_SMALL_KEY, Feature.ORE, new OreConfiguration(overworldGedriteOres, 4));
        ModConfiguredFeatures.register(context, GEDRITE_ORE_BURIED_KEY, Feature.ORE, new OreConfiguration(overworldGedriteOres, 8));
        ModConfiguredFeatures.register(context, GEDRITE_ORE_LARGE_KEY, Feature.ORE, new OreConfiguration(overworldGedriteOres, 12));
        ModConfiguredFeatures.register(context, GEDRITE_ORE_MEDIUM_KEY, Feature.ORE, new OreConfiguration(overworldGedriteOres, 8));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

