/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.surveyalot;

import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.util.RegionPos;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xaero.pac.client.api.OpenPACClientAPI;
import xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI;
import xaero.pac.common.claims.player.api.IPlayerClaimInfoAPI;
import xaero.pac.common.claims.player.api.IPlayerClaimPosListAPI;
import xaero.pac.common.claims.tracker.api.IClaimsManagerListenerAPI;
import xaero.pac.common.event.api.OPACServerAddonRegister;
import xaero.pac.common.server.api.OpenPACServerAPI;

public class OPACCompat {
    public static void init() {
        OPACServerAddonRegister.EVENT.register((s, perms, parties, claims) -> claims.register((IClaimsManagerListenerAPI)new SurveyalotListener(i -> s.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)i)))));
    }

    public static void updateClaimLandmarksForDimension(class_1937 world) {
        List list;
        WorldLandmarks landmarks;
        WorldLandmarks worldLandmarks = landmarks = world == null ? null : WorldSummary.of((class_1937)world).landmarks();
        if (landmarks == null) {
            return;
        }
        Map changed = landmarks.removeAllForBatch(new HashMap(), l -> l.id().toString().startsWith("opac:claim"));
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            list = OpenPACServerAPI.get((MinecraftServer)sw.method_8503()).getServerClaimsManager().getPlayerInfoStream().toList();
        } else {
            list = OpenPACClientAPI.get().getClaimsManager().getPlayerInfoStream().toList();
        }
        for (IPlayerClaimInfoAPI player : list) {
            for (IPlayerClaimPosListAPI claimPositions : Optional.ofNullable(player.getDimension(world.method_27983().method_29177())).map(d -> d.getStream().toList()).orElse(List.of())) {
                IPlayerChunkClaimAPI claim = claimPositions.getClaimState();
                String claimName = claim.getSubConfigIndex() != -1 ? Objects.requireNonNullElse(player.getClaimsName(claim.getSubConfigIndex()), "") : Objects.requireNonNullElse(player.getClaimsName(), "");
                landmarks.putForBatch(changed, Landmark.create((UUID)WorldLandmarks.GLOBAL, (class_2960)class_2960.method_43902((String)"opac", (String)"claim/%s%s%s".formatted(claim.getPlayerId(), claim.getSubConfigIndex() == -1 ? "" : "/" + claim.getSubConfigIndex(), claim.isForceloadable() ? "/forced" : "")), b -> b.add(LandmarkComponentTypes.NAME, (Object)class_2561.method_43470((String)((String)(claimName.isBlank() ? "" : claimName + " - ") + player.getPlayerUsername() + "'s Claim" + (claim.isForceloadable() ? " (forceloaded)" : "")))).add(LandmarkComponentTypes.COLOR, (Object)Optional.ofNullable(claim.getSubConfigIndex() == -1 ? Integer.valueOf(player.getClaimsColor()) : player.getClaimsColor(claim.getSubConfigIndex())).map(i -> 0xFFFFFF & i).orElse(null)).add(LandmarkComponentTypes.CHUNKS, (Object)RegionPos.chunksToRegions(claimPositions.getStream().toList()))));
            }
        }
        landmarks.handleChanged(world, changed, world.method_8608(), null);
    }

    public record SurveyalotListener(Function<class_2960, class_1937> worldGetter) implements IClaimsManagerListenerAPI
    {
        public void onWholeRegionChange(@NotNull class_2960 dimension, int regionX, int regionZ) {
            this.onDimensionChange(dimension);
        }

        public void onChunkChange(@NotNull class_2960 dimension, int chunkX, int chunkZ, IPlayerChunkClaimAPI api) {
            this.onDimensionChange(dimension);
        }

        public void onDimensionChange(class_2960 dimension) {
            class_1937 world = this.worldGetter.apply(dimension);
            if (world != null) {
                OPACCompat.updateClaimLandmarksForDimension(world);
            }
        }
    }
}

