/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import games.cubi.raycastedEntityOcclusion.UpdateChecker;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class CommandsManager {
    private final RaycastedEntityOcclusion plugin;
    private final ConfigManager cfg;

    public CommandsManager(RaycastedEntityOcclusion plugin, ConfigManager cfg) {
        this.plugin = plugin;
        this.cfg = cfg;
    }

    public LiteralCommandNode<CommandSourceStack> registerCommand(String commandName) {
        LiteralCommandNode buildCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandName).requires(sender -> sender.getSender().hasPermission("raycastedentityocclusions.command"))).executes(context -> {
            this.helpCommand((CommandContext<CommandSourceStack>)context);
            return 1;
        })).then(Commands.literal((String)"help").executes(context -> this.helpCommand((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"reload").executes(context -> {
            this.cfg.load();
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("[EntityOcclusions] Config reloaded.");
            return 1;
        }))).then(Commands.literal((String)"config-values").executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            sender.sendMessage("[EntityOcclusions] Config values: ");
            ConfigurationSection root = this.cfg.cfg.getConfigurationSection("");
            for (String path : root.getKeys(true)) {
                Object val = this.cfg.cfg.get(path);
                sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)("<green>" + path + "<gray> = <white>" + String.valueOf(val))));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            sender.sendRichMessage("<red>Usage: /raycastedentityocclusions set <key> <value>");
            return 0;
        })).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String value;
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            int result = this.cfg.setConfigValue(key, value = StringArgumentType.getString((CommandContext)context, (String)"value"));
            if (result == -1) {
                sender.sendRichMessage("<red>Invalid inputs");
            } else if (result == 0) {
                sender.sendRichMessage("<red>Invalid value for <white>" + key + "<red>, must be between 0 and 256");
            } else {
                sender.sendRichMessage("<white>Set <green>" + key + "<white> to <green>" + value);
            }
            return 0;
        }))))).then(Commands.literal((String)"test").executes(context -> {
            this.testCommand((CommandContext<CommandSourceStack>)context);
            return 1;
        }))).then(Commands.literal((String)"check-for-updates").executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            UpdateChecker.checkForUpdates(this.plugin, sender);
            return 1;
        }))).build();
        return buildCommand;
    }

    public int helpCommand(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        sender.sendRichMessage("<white>RaycastedEntityOcclusions <yellow>v" + this.plugin.getDescription().getVersion());
        sender.sendRichMessage("<white>Commands:");
        sender.sendRichMessage("<green>/raycastedentityocclusions reload <gray>- Reloads the config");
        sender.sendRichMessage("<green>/raycastedentityocclusions config-values <gray>- Shows all config values");
        sender.sendRichMessage("<green>/raycastedentityocclusions set <key> <value> <gray>- Sets a config value");
        return 1;
    }

    private void testCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
    }
}

