/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    public int snapshotRefreshInterval;
    public int engineMode;
    public int maxOccludingCount;
    public boolean debugMode;
    public int alwaysShowRadius;
    public int raycastRadius;
    public int searchRadius;
    public boolean cullPlayers;
    public boolean onlyCullSneakingPlayers;
    public int recheckInterval;
    public boolean checkTileEntities;
    public int tileEntityRecheckInterval;
    public FileConfiguration cfg;
    public boolean packetEventsPresent = false;
    public static final int SNAPSHOT_REFRESH_INTERVAL_DEFAULT = 60;
    public static final int ENGINE_MODE_DEFAULT = 1;
    public static final int MAX_OCCLUDING_COUNT_DEFAULT = 3;
    public static final boolean DEBUG_MODE_DEFAULT = false;
    public static final int ALWAYS_SHOW_RADIUS_DEFAULT = 16;
    public static final int RAYCAST_RADIUS_DEFAULT = 48;
    public static final int SEARCH_RADIUS_DEFAULT = 48;
    public static final boolean CULL_PLAYERS_DEFAULT = false;
    public static final boolean ONLY_CULL_SNEAKING_PLAYERS_DEFAULT = false;
    public static final int RECHECK_INTERVAL_DEFAULT = 50;
    public static final boolean CHECK_TILE_ENTITIES_DEFAULT = true;
    public static final int TILE_ENTITY_RECHECK_INTERVAL_DEFAULT = 0;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void load() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.cfg = this.plugin.getConfig();
        this.snapshotRefreshInterval = this.cfg.getInt("snapshot-refresh-interval", 60);
        this.engineMode = this.cfg.getInt("engine-mode", 1);
        this.maxOccludingCount = this.cfg.getInt("max-occluding-count", 3);
        this.debugMode = this.cfg.getBoolean("debug-mode", false);
        this.alwaysShowRadius = this.cfg.getInt("always-show-radius", 16);
        this.raycastRadius = this.cfg.getInt("raycast-radius", 48);
        this.searchRadius = this.cfg.getInt("search-radius", 48);
        this.cullPlayers = this.cfg.getBoolean("cull-players", false);
        this.onlyCullSneakingPlayers = this.cfg.getBoolean("only-cull-sneaking-players", false);
        this.recheckInterval = this.cfg.getInt("recheck-interval", 50);
        this.checkTileEntities = this.cfg.getBoolean("check-tile-entities", true);
        this.tileEntityRecheckInterval = this.cfg.getInt("tile-entity-recheck-interval", 0);
        this.cfg.addDefault("snapshot-refresh-interval", (Object)60);
        this.cfg.addDefault("engine-mode", (Object)1);
        this.cfg.addDefault("max-occluding-count", (Object)3);
        this.cfg.addDefault("debug-mode", (Object)false);
        this.cfg.addDefault("always-show-radius", (Object)16);
        this.cfg.addDefault("raycast-radius", (Object)48);
        this.cfg.addDefault("search-radius", (Object)48);
        this.cfg.addDefault("cull-players", (Object)false);
        this.cfg.addDefault("only-cull-sneaking-players", (Object)false);
        this.cfg.addDefault("recheck-interval", (Object)50);
        this.cfg.addDefault("check-tile-entities", (Object)true);
        this.cfg.addDefault("tile-entity-recheck-interval", (Object)0);
        this.cfg.options().copyDefaults(true);
        this.plugin.saveConfig();
    }

    public int setConfigValue(String path, String rawValue) {
        Comparable<Boolean> parsed;
        if (!this.cfg.contains(path)) {
            return -1;
        }
        Object current = this.cfg.get(path);
        if (current instanceof Boolean) {
            String lower = rawValue.toLowerCase();
            if (!lower.equals("true") && !lower.equals("false")) {
                return -1;
            }
            parsed = Boolean.parseBoolean(lower);
        } else if (current instanceof Number) {
            int intVal;
            try {
                intVal = Integer.parseInt(rawValue);
            }
            catch (NumberFormatException e) {
                return -1;
            }
            if (intVal < 0 || intVal > 256) {
                return 0;
            }
            parsed = intVal;
        } else {
            return -1;
        }
        this.cfg.set(path, (Object)parsed);
        this.plugin.saveConfig();
        this.load();
        return 1;
    }

    public void setPacketEventsPresent(boolean present) {
        this.packetEventsPresent = present;
    }
}

