/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.Packets.PacketProcessor;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import games.cubi.raycastedEntityOcclusion.Snapshot.ChunkSnapshotManager;
import games.cubi.raycastedEntityOcclusion.UpdateChecker;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class EventListener
implements Listener {
    private final ChunkSnapshotManager manager;
    private final ConfigManager config;
    private PacketProcessor packetProcessor;
    private final RaycastedEntityOcclusion plugin;
    public static final int BREAK = 1;
    public static final int PLACE = 2;

    public EventListener(RaycastedEntityOcclusion plugin, ChunkSnapshotManager mgr, ConfigManager cfg) {
        this.manager = mgr;
        this.config = cfg;
        this.plugin = plugin;
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            this.packetProcessor = this.config.packetEventsPresent ? plugin.getPacketProcessor() : null;
        }, 2L);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        this.manager.onChunkLoad(e.getChunk());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent e) {
        this.manager.onChunkUnload(e.getChunk());
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        this.manager.onBlockChange(e.getBlock().getLocation(), e.getBlock().getType(), 2);
    }

    @EventHandler
    public void onBreak(BlockBreakEvent e) {
        this.manager.onBlockChange(e.getBlock().getLocation(), Material.AIR, 1);
    }

    @EventHandler
    public void onBurn(BlockBurnEvent e) {
        this.manager.onBlockChange(e.getBlock().getLocation(), Material.AIR, 1);
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerQuitEvent e) {
        if (this.config.packetEventsPresent && this.packetProcessor != null) {
            UUID player = e.getPlayer().getUniqueId();
            this.packetProcessor.sendPlayerInfoRemovePacket(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().hasPermission("raycastedentityocclusions.updatecheck")) {
            Player sender = event.getPlayer();
            UpdateChecker.checkForUpdates(this.plugin, (CommandSender)sender);
        }
    }
}

