/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Range;

public class Logger {
    private static final String PREFIX = "<hover:show_text:'Raycasted Entity Occlusions'><click:suggest_command:'/reo'><grey>[<gold>REO<grey>]</click></hover><reset> ";
    private static final String PREFIX_WARNING = "<hover:show_text:'Raycasted Entity Occlusions'><click:suggest_command:'/reo'><grey>[<gold>REO<grey>]</click></hover> <yellow><hover:show_text:'<yellow>Something went wrong'>[Warning]</hover> ";
    private static final String PREFIX_ERROR = "<hover:show_text:'Raycasted Entity Occlusions'><click:suggest_command:'/reo'><grey>[<gold>REO<grey>]</click></hover> <red><hover:show_text:'<red>Something went wrong'>[Error]</hover> ";
    private static JavaPlugin plugin = null;

    public static void info(String message) {
        Logger.forwardLog(message, Level.INFO);
    }

    public static void warning(String message) {
        Logger.forwardLog(message, Level.WARN);
    }

    public static void error(String message) {
        Logger.forwardLog(message, Level.ERROR);
    }

    public static void debug(String message, @Range(from=1L, to=10L) int level) {
        int debugLevel = 2;
        if (debugLevel <= level) {
            Logger.forwardLog(message, Level.INFO);
        }
    }

    private static void forwardLog(String message, Level severity) {
        if (plugin == null) {
            plugin = JavaPlugin.getProvidingPlugin(Logger.class);
        }
        Component messageComponent = MiniMessage.miniMessage().deserialize((Object)message);
        switch (severity.ordinal()) {
            case 0: {
                plugin.getComponentLogger().info(messageComponent);
                break;
            }
            case 1: {
                plugin.getComponentLogger().warn(messageComponent);
                break;
            }
            case 2: {
                plugin.getComponentLogger().error(messageComponent);
                break;
            }
            default: {
                plugin.getComponentLogger().error("{} | Additionally, severity {} is not supported by the logger.", (Object)messageComponent, (Object)severity);
            }
        }
    }

    private static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

