/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion.Raycast;

import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.Logger;
import games.cubi.raycastedEntityOcclusion.Raycast.MovementTracker;
import games.cubi.raycastedEntityOcclusion.Raycast.RaycastUtil;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import games.cubi.raycastedEntityOcclusion.Snapshot.ChunkSnapshotManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Engine {
    public static ConcurrentHashMap<Location, Set<Player>> canSeeTileEntity = new ConcurrentHashMap();
    public static Set<Chunk> syncRecheck = ConcurrentHashMap.newKeySet();
    private static final BlockData STONE = Material.STONE.createBlockData();
    private static final BlockData DEEPSLATE = Material.DEEPSLATE.createBlockData();
    private static final ConcurrentLinkedQueue<TileResult> results = new ConcurrentLinkedQueue();

    public static void runEngine(ConfigManager cfg, ChunkSnapshotManager snapMgr, MovementTracker tracker, RaycastedEntityOcclusion plugin) {
        if (!syncRecheck.isEmpty()) {
            Logger.warning(syncRecheck.size() + " chunks failed to snapshot asynchronously, rechecking them now.");
            for (Chunk c : syncRecheck) {
                if (!c.isLoaded()) continue;
                plugin.getChunkSnapshotManager().snapshotChunk(c);
                syncRecheck.remove(c);
                Logger.info("Successfully rechecked chunk " + c.getX() + ", " + c.getZ() + " in world " + c.getWorld().getName());
            }
        }
        ArrayList<RayJob> jobs = new ArrayList<RayJob>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.hasPermission("raycastedentityocclusions.bypass")) continue;
            Location eye = p.getEyeLocation().clone();
            Location predEye = null;
            if (cfg.engineMode == 2) {
                predEye = tracker.getPredictedLocation(p);
            }
            for (Entity e : p.getNearbyEntities((double)cfg.searchRadius, (double)cfg.searchRadius, (double)cfg.searchRadius)) {
                Location target;
                double dist;
                if (e == p) continue;
                if (e instanceof Player) {
                    Player pl = (Player)e;
                    if (!cfg.cullPlayers || cfg.onlyCullSneakingPlayers && !pl.isSneaking()) {
                        p.showEntity((Plugin)plugin, e);
                        continue;
                    }
                }
                if ((dist = eye.distance(target = e.getLocation().add(0.0, e.getHeight() / 2.0, 0.0).clone())) <= (double)cfg.alwaysShowRadius) {
                    p.showEntity((Plugin)plugin, e);
                    continue;
                }
                if (dist > (double)cfg.raycastRadius) {
                    p.hideEntity((Plugin)plugin, e);
                    continue;
                }
                if (p.canSee(e) && plugin.tick % cfg.recheckInterval != 0) continue;
                jobs.add(new RayJob(p, e, eye, predEye, target));
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            ArrayList<RayResult> results = new ArrayList<RayResult>(jobs.size());
            for (RayJob job : jobs) {
                if (!job.player.getWorld().equals((Object)job.target.getWorld())) continue;
                boolean vis = RaycastUtil.raycast(job.start, job.end, cfg.maxOccludingCount, cfg.debugMode, snapMgr);
                if (!vis && job.predictedStart != null) {
                    if (cfg.debugMode) {
                        job.predictedStart.getWorld().spawnParticle(Particle.DUST, job.predictedStart, 1, (Object)new Particle.DustOptions(Color.BLUE, 1.0f));
                    }
                    vis = RaycastUtil.raycast(job.predictedStart, job.end, cfg.maxOccludingCount, cfg.debugMode, snapMgr);
                }
                results.add(new RayResult(job.player, job.target, vis));
            }
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                for (RayResult r : results) {
                    boolean currentState;
                    Player p = r.player;
                    Entity ent = r.target;
                    if (p == null || ent == null || (currentState = p.canSee(ent)) == r.visible) continue;
                    if (r.visible) {
                        p.showEntity((Plugin)plugin, ent);
                        continue;
                    }
                    p.hideEntity((Plugin)plugin, ent);
                }
            });
        });
    }

    public static void runTileEngine(ConfigManager cfg, ChunkSnapshotManager snapMgr, MovementTracker tracker, RaycastedEntityOcclusion plugin) {
        if (cfg.checkTileEntities) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.hasPermission("raycastedentityocclusions.bypass")) continue;
                World world = p.getWorld();
                int chunkX = p.getLocation().getBlockX() >> 4;
                int chunkZ = p.getLocation().getBlockZ() >> 4;
                Location playerLoc = p.getLocation();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                    int chunksRadius = (cfg.searchRadius + 15) / 16;
                    HashSet<Location> tileEntities = new HashSet<Location>();
                    for (int x = -chunksRadius / 2 + chunkX; x <= chunksRadius + chunkX; ++x) {
                        for (int z = -chunksRadius / 2 + chunkZ; z <= chunksRadius + chunkZ; ++z) {
                            tileEntities.addAll(snapMgr.getTileEntitiesInChunk(world, x, z));
                        }
                    }
                    for (Location loc : tileEntities) {
                        boolean result2;
                        Location predEye;
                        Set<Player> seen = canSeeTileEntity.get(loc);
                        if (seen != null && seen.contains(p) && (cfg.tileEntityRecheckInterval == 0 || plugin.tick % (cfg.tileEntityRecheckInterval * 20) != 0) || snapMgr.getMaterialAt(loc).equals((Object)Material.BEACON) || !loc.getWorld().equals((Object)playerLoc.getWorld())) continue;
                        double distSquared = loc.distanceSquared(playerLoc);
                        if (distSquared > (double)(cfg.searchRadius * cfg.searchRadius)) {
                            results.add(new TileResult(p, loc, false));
                            continue;
                        }
                        if (distSquared < (double)(cfg.alwaysShowRadius * cfg.alwaysShowRadius)) {
                            results.add(new TileResult(p, loc, true));
                            continue;
                        }
                        boolean visible = RaycastUtil.raycast(p.getEyeLocation(), loc, cfg.maxOccludingCount, cfg.debugMode, snapMgr);
                        if (cfg.engineMode == 2 && !visible && (predEye = tracker.getPredictedLocation(p)) != null && (result2 = RaycastUtil.raycast(predEye, loc, cfg.maxOccludingCount, cfg.debugMode, snapMgr))) {
                            visible = true;
                        }
                        if (visible) {
                            canSeeTileEntity.computeIfAbsent(loc, k -> ConcurrentHashMap.newKeySet()).add(p);
                        } else {
                            Set<Player> seenPlayers = canSeeTileEntity.get(loc);
                            if (seenPlayers != null) {
                                seenPlayers.remove(p);
                                if (seenPlayers.isEmpty()) {
                                    canSeeTileEntity.remove(loc);
                                }
                            }
                        }
                        results.add(new TileResult(p, loc, visible));
                    }
                });
            }
            for (TileResult r : results) {
                Player p = r.player;
                Location loc = r.loc;
                boolean visible = r.visible;
                Engine.syncToggleTileEntity(p, loc, visible, plugin);
                results.remove(r);
            }
        }
    }

    public static void hideTileEntity(Player p, Location location, RaycastedEntityOcclusion plugin) {
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            if (p.hasPermission("raycastedentityocclusions.bypass")) {
                return;
            }
            if (location.getBlockY() < 0) {
                p.sendBlockChange(location, DEEPSLATE);
            } else {
                p.sendBlockChange(location, STONE);
            }
        });
    }

    public static void showTileEntity(Player p, Location location, RaycastedEntityOcclusion plugin) {
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            Block block = location.getBlock();
            BlockState data = block.getState();
            if (data instanceof TileState) {
                TileState tileData = (TileState)data;
                p.sendBlockChange(location, block.getBlockData());
                p.sendBlockUpdate(location, tileData);
            } else {
                canSeeTileEntity.remove(location);
                plugin.getChunkSnapshotManager().removeTileEntity(location);
            }
        });
    }

    public static void syncToggleTileEntity(Player p, Location loc, boolean show, RaycastedEntityOcclusion plugin) {
        if (show) {
            Engine.showTileEntity(p, loc, plugin);
        } else {
            Engine.hideTileEntity(p, loc, plugin);
        }
    }

    private static class RayJob {
        final Player player;
        final Entity target;
        final Location start;
        final Location predictedStart;
        final Location end;

        RayJob(Player p, Entity e, Location s, Location pred, Location t) {
            this.player = p;
            this.target = e;
            this.start = s;
            this.predictedStart = pred;
            this.end = t;
        }
    }

    private static class TileResult {
        final Player player;
        final Location loc;
        final boolean visible;

        TileResult(Player p, Location location, boolean v) {
            this.player = p;
            this.loc = location;
            this.visible = v;
        }
    }

    private static class RayResult {
        final Player player;
        final Entity target;
        final boolean visible;

        RayResult(Player p, Entity e, boolean v) {
            this.player = p;
            this.target = e;
            this.visible = v;
        }
    }
}

