/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion.Raycast;

import games.cubi.raycastedEntityOcclusion.Snapshot.ChunkSnapshotManager;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class RaycastUtil {
    static Particle.DustOptions dustRed = null;
    static Particle.DustOptions dustGreen = null;

    private static void initDebugParticles() {
        if (dustRed == null) {
            dustRed = new Particle.DustOptions(Color.RED, 1.0f);
        }
        if (dustGreen == null) {
            dustGreen = new Particle.DustOptions(Color.GREEN, 1.0f);
        }
    }

    public static boolean raycast(Location start, Location end, int maxOccluding, boolean debug, ChunkSnapshotManager snap) {
        RaycastUtil.initDebugParticles();
        if (!start.getWorld().equals((Object)end.getWorld())) {
            return false;
        }
        double total = start.distance(end);
        double traveled = 0.0;
        Location curr = start.clone();
        Vector dir = end.toVector().subtract(start.toVector()).normalize();
        while (traveled < total) {
            curr.add(dir);
            traveled += 1.0;
            Material mat = snap.getMaterialAt(curr);
            if (mat == null) continue;
            if (mat.isOccluding()) {
                --maxOccluding;
                if (debug) {
                    start.getWorld().spawnParticle(Particle.DUST, curr, 1, (Object)dustRed);
                }
                if (maxOccluding >= 1) continue;
                return false;
            }
            if (!debug) continue;
            start.getWorld().spawnParticle(Particle.DUST, curr, 1, (Object)dustGreen);
        }
        return true;
    }
}

