/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import games.cubi.raycastedEntityOcclusion.CommandsManager;
import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.EventListener;
import games.cubi.raycastedEntityOcclusion.Logger;
import games.cubi.raycastedEntityOcclusion.Packets.PacketProcessor;
import games.cubi.raycastedEntityOcclusion.Packets.Registrar;
import games.cubi.raycastedEntityOcclusion.Raycast.Engine;
import games.cubi.raycastedEntityOcclusion.Raycast.MovementTracker;
import games.cubi.raycastedEntityOcclusion.Snapshot.ChunkSnapshotManager;
import games.cubi.raycastedEntityOcclusion.UpdateChecker;
import games.cubi.raycastedEntityOcclusion.bStats.MetricsCollector;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RaycastedEntityOcclusion
extends JavaPlugin
implements CommandExecutor {
    private ConfigManager cfg;
    private ChunkSnapshotManager snapMgr;
    private MovementTracker tracker;
    private CommandsManager commands;
    private boolean packetEventsPresent = false;
    private PacketProcessor packetProcessor = null;
    private static RaycastedEntityOcclusion instance;
    public int tick = 0;

    public void onLoad() {
        Plugin packetEvents = Bukkit.getPluginManager().getPlugin("packetevents");
        if (packetEvents != null) {
            this.packetEventsPresent = true;
            this.getLogger().info("PacketEvents detected.");
            new Registrar(this);
        } else {
            this.getLogger().info("PacketEvents not detected, disabling packet-based tablist modification. Don't worry, the plugin will still work without it.");
        }
    }

    public void onEnable() {
        instance = this;
        this.cfg = new ConfigManager(this);
        this.snapMgr = new ChunkSnapshotManager(this);
        this.tracker = new MovementTracker(this, this.cfg);
        this.commands = new CommandsManager(this, this.cfg);
        new UpdateChecker(this);
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this, this.snapMgr, this.cfg), (Plugin)this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commandRegistrar -> {
            ((Commands)commandRegistrar.registrar()).register(this.commands.registerCommand("raycastedentityocclusions"));
            ((Commands)commandRegistrar.registrar()).register(this.commands.registerCommand("reo"));
        });
        new MetricsCollector(this, this.cfg);
        new BukkitRunnable(){

            public void run() {
                ++RaycastedEntityOcclusion.this.tick;
                Engine.runEngine(RaycastedEntityOcclusion.this.cfg, RaycastedEntityOcclusion.this.snapMgr, RaycastedEntityOcclusion.this.tracker, RaycastedEntityOcclusion.this);
                Engine.runTileEngine(RaycastedEntityOcclusion.this.cfg, RaycastedEntityOcclusion.this.snapMgr, RaycastedEntityOcclusion.this.tracker, RaycastedEntityOcclusion.this);
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
        new BukkitRunnable(){

            public void run() {
                if (RaycastedEntityOcclusion.this.packetEventsPresent && Bukkit.getPluginManager().isPluginEnabled("packetevents")) {
                    RaycastedEntityOcclusion.this.cfg.setPacketEventsPresent(true);
                    RaycastedEntityOcclusion.this.packetProcessor = new PacketProcessor(RaycastedEntityOcclusion.this);
                    Logger.info("PacketEvents is enabled, enabling packet-based tablist modification.");
                }
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    public ConfigManager getConfigManager() {
        return this.cfg;
    }

    public ChunkSnapshotManager getChunkSnapshotManager() {
        return this.snapMgr;
    }

    public MovementTracker getMovementTracker() {
        return this.tracker;
    }

    public CommandsManager getCommandsManager() {
        return this.commands;
    }

    public PacketProcessor getPacketProcessor() {
        return this.packetProcessor;
    }

    public static RaycastedEntityOcclusion getInstance() {
        return instance;
    }
}

