/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion.Snapshot;

import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.Logger;
import games.cubi.raycastedEntityOcclusion.Raycast.Engine;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkSnapshotManager {
    private static final ConcurrentHashMap<String, ChunkData> dataMap = new ConcurrentHashMap();
    private final ConfigManager cfg;

    public ChunkSnapshotManager(RaycastedEntityOcclusion plugin) {
        this.cfg = plugin.getConfigManager();
        for (World w : plugin.getServer().getWorlds()) {
            for (Chunk c : w.getLoadedChunks()) {
                this.snapshotChunk(c);
            }
        }
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                int chunksRefreshed = 0;
                int chunksToRefreshMaximum = ChunkSnapshotManager.this.getNumberOfCachedChunks() / 3;
                for (Map.Entry<String, ChunkData> e : dataMap.entrySet()) {
                    if (now - e.getValue().lastRefresh < (long)ChunkSnapshotManager.this.cfg.snapshotRefreshInterval * 1000L || chunksRefreshed >= chunksToRefreshMaximum) continue;
                    ++chunksRefreshed;
                    String key = e.getKey();
                    ChunkSnapshotManager.this.snapshotChunk(key);
                }
                if (ChunkSnapshotManager.this.cfg.debugMode) {
                    Logger.info("ChunkSnapshotManager: Refreshed " + chunksRefreshed + " chunks out of " + chunksToRefreshMaximum + " maximum.");
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, (long)this.cfg.snapshotRefreshInterval * 2L, (long)this.cfg.snapshotRefreshInterval * 2L);
    }

    public void onChunkLoad(Chunk c) {
        this.snapshotChunk(c);
    }

    public void onChunkUnload(Chunk c) {
        this.removeChunkSnapshot(c);
    }

    public void snapshotChunk(Chunk c) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)RaycastedEntityOcclusion.getInstance(), () -> dataMap.put(this.key(c), this.takeSnapshot(c, System.currentTimeMillis())));
    }

    public void snapshotChunk(String key) {
        this.snapshotChunk(this.getKeyChunk(key));
    }

    public void removeChunkSnapshot(Chunk c) {
        if (this.cfg.debugMode) {
            Logger.info("ChunkSnapshotManager: Removing snapshot of chunk " + c.getWorld().getName() + ":" + c.getX() + ":" + c.getZ());
        }
        dataMap.remove(this.key(c));
    }

    public void onBlockChange(Location loc, Material m, int change) {
        ChunkData d;
        if (this.cfg.debugMode) {
            Logger.info("ChunkSnapshotManager: Block change at " + String.valueOf(loc) + " to " + String.valueOf(m));
        }
        if ((d = dataMap.get(this.key(loc.getChunk()))) != null) {
            BlockState data;
            d.delta.put(BlockLocation.fromLocation(loc), m);
            if (this.cfg.checkTileEntities && (data = loc.getBlock().getState()) instanceof TileState) {
                if (this.cfg.debugMode) {
                    Logger.info("ChunkSnapshotManager: Tile entity at " + String.valueOf(loc));
                }
                if (change == 2) {
                    d.tileEntities.add(BlockLocation.fromLocation(loc));
                }
                if (change == 1) {
                    d.tileEntities.remove(BlockLocation.fromLocation(loc));
                }
            }
        } else {
            Logger.error("Data map value empty, ignoring block update!");
        }
    }

    private ChunkData takeSnapshot(Chunk c, long now) {
        int maxHeight;
        World w = c.getWorld();
        ChunkData data = new ChunkData(c.getChunkSnapshot(), now);
        int chunkX = c.getX() * 16;
        int chunkZ = c.getZ() * 16;
        int minHeight = w.getMinHeight();
        data.maxHeight = maxHeight = w.getMaxHeight();
        data.minHeight = minHeight;
        if (this.cfg.checkTileEntities) {
            for (int x = 0; x < 16; ++x) {
                for (int y = minHeight; y < maxHeight; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState bs = data.snapshot.getBlockData(x, y, z).createBlockState();
                        if (!(bs instanceof TileState)) continue;
                        data.tileEntities.add(BlockLocation.fromValues(w, x + chunkX, y, z + chunkZ));
                    }
                }
            }
        }
        return data;
    }

    public String key(Chunk c) {
        return c.getWorld().getName() + ":" + c.getX() + ":" + c.getZ();
    }

    public String key(World world, int x, int z) {
        return world.getName() + ":" + x + ":" + z;
    }

    public int getKeyX(String key) {
        String[] parts = key.split(":");
        return Integer.parseInt(parts[1]);
    }

    public int getKeyZ(String key) {
        String[] parts = key.split(":");
        return Integer.parseInt(parts[2]);
    }

    public World getKeyWorld(String key) {
        String[] parts = key.split(":");
        return Bukkit.getWorld((String)parts[0]);
    }

    public Chunk getKeyChunk(String key) {
        return this.getKeyWorld(key).getChunkAt(this.getKeyX(key), this.getKeyZ(key));
    }

    public Material getMaterialAt(Location loc) {
        Chunk chunk = loc.getChunk();
        ChunkData d = dataMap.get(this.key(chunk));
        if (d == null) {
            Chunk c = loc.getChunk();
            Logger.error("ChunkSnapshotManager: No snapshot for " + String.valueOf(c) + " If this error persists, please report this on our discord (discord.cubi.games)");
            Engine.syncRecheck.add(chunk);
            return loc.getBlock().getType();
        }
        double yLevel = loc.getY();
        if (yLevel < (double)d.minHeight || yLevel > (double)d.maxHeight) {
            return null;
        }
        Material dm = d.delta.get(BlockLocation.fromLocation(loc));
        if (dm != null) {
            if (this.cfg.debugMode) {
                Logger.info("Using delta");
            }
            return dm;
        }
        int x = loc.getBlockX() & 0xF;
        int y = loc.getBlockY();
        int z = loc.getBlockZ() & 0xF;
        return d.snapshot.getBlockType(x, y, z);
    }

    public Set<Location> getTileEntitiesInChunk(World world, int x, int z) {
        ChunkData d = dataMap.get(this.key(world, x, z));
        if (d == null) {
            return Collections.emptySet();
        }
        return BlockLocation.toLocations(d.tileEntities);
    }

    public void removeTileEntity(Location loc) {
        Chunk c = loc.getChunk();
        ChunkData d = dataMap.get(this.key(c));
        if (d != null) {
            d.tileEntities.remove(BlockLocation.fromLocation(loc));
            if (this.cfg.debugMode) {
                Logger.info("ChunkSnapshotManager: Removed tile entity at " + String.valueOf(loc));
            }
        } else {
            Logger.error("ChunkSnapshotManager: No snapshot for " + String.valueOf(c) + " when removing tile entity at " + String.valueOf(loc));
        }
    }

    public int getNumberOfCachedChunks() {
        return dataMap.size();
    }

    private static class ChunkData {
        public final ChunkSnapshot snapshot;
        public final ConcurrentHashMap<BlockLocation, Material> delta = new ConcurrentHashMap();
        public final Set<BlockLocation> tileEntities = ConcurrentHashMap.newKeySet();
        public long lastRefresh;
        public int minHeight;
        public int maxHeight;

        public ChunkData(ChunkSnapshot snapshot, long time) {
            this.snapshot = snapshot;
            this.lastRefresh = time;
        }
    }

    private static class BlockLocation {
        private final Location location;
        private final int hashCode;

        private BlockLocation(Location location) {
            this.location = location.toCenterLocation();
            this.location.setPitch(0.0f);
            this.location.setYaw(0.0f);
            this.hashCode = this.calculateHashCode();
        }

        static BlockLocation fromLocation(Location loc) {
            return new BlockLocation(loc);
        }

        static BlockLocation fromValues(World world, double x, double y, double z) {
            return new BlockLocation(new Location(world, x, y, z));
        }

        static Location toLocation(BlockLocation blockLocation) {
            return blockLocation.location.clone();
        }

        static Set<Location> toLocations(Set<BlockLocation> blockLocations) {
            HashSet<Location> locations = new HashSet<Location>();
            for (BlockLocation bl : blockLocations) {
                locations.add(BlockLocation.toLocation(bl));
            }
            return locations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockLocation)) {
                return false;
            }
            Location other = ((BlockLocation)o).location;
            return this.location.getX() == other.getX() && this.location.getY() == other.getY() && this.location.getZ() == other.getZ() && this.location.getWorld().equals((Object)other.getWorld());
        }

        private int calculateHashCode() {
            int result = 17;
            result = 31 * result + this.location.getBlockX();
            result = 31 * result + this.location.getBlockY();
            result = 31 * result + this.location.getBlockZ();
            return 31 * result + this.location.getWorld().getUID().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

