/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import games.cubi.raycastedEntityOcclusion.Logger;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final RaycastedEntityOcclusion plugin;
    private static final int INVALID_VERSION_FORMAT = -2;
    private static final int CURRENT_IS_OLDER = -1;
    private static final int VERSIONS_ARE_EQUAL = 0;
    private static final int CURRENT_IS_NEWER = 1;

    public UpdateChecker(RaycastedEntityOcclusion plugin) {
        this.plugin = plugin;
        UpdateChecker.checkForUpdates(plugin, (CommandSender)Bukkit.getConsoleSender());
    }

    public static CompletableFuture<String> fetchFeaturedVersion(RaycastedEntityOcclusion plugin) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            String url = "https://api.modrinth.com/v2/project/bCjNZu0C/version";
            try (InputStreamReader reader = new InputStreamReader(new URL("https://api.modrinth.com/v2/project/bCjNZu0C/version").openConnection().getInputStream());){
                JsonArray array = new JsonArray();
                array.add(new BufferedReader(reader).readLine());
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < array.size(); ++i) {
                    sb.append(array.get(i).getAsString());
                }
                String apiData = sb.toString();
                JsonArray jsonArray = JsonParser.parseString((String)apiData).getAsJsonArray();
                JsonObject firstObject = jsonArray.get(0).getAsJsonObject();
                String versionNumber = firstObject.get("version_number").getAsString();
                future.complete(versionNumber);
            }
            catch (IOException e) {
                future.completeExceptionally(new IllegalStateException("Unable to fetch latest version", e));
            }
        });
        return future;
    }

    private static int checkIfLaterThan(String currentVersion, String fetchedVersion) {
        String[] currentParts = currentVersion.replace("v", "").split("[.-]");
        String[] fetchedParts = fetchedVersion.replace("v", "").split("[.-]");
        if (currentParts.length < 3 || fetchedParts.length < 3) {
            return -2;
        }
        int majorVersionDifference = Integer.parseInt(currentParts[0]) - Integer.parseInt(fetchedParts[0]);
        if (majorVersionDifference == 0) {
            int minorVersionDifference = Integer.parseInt(currentParts[1]) - Integer.parseInt(fetchedParts[1]);
            if (minorVersionDifference == 0) {
                int patchVersionDifference = Integer.parseInt(currentParts[2]) - Integer.parseInt(fetchedParts[2]);
                return patchVersionDifference;
            }
            return minorVersionDifference;
        }
        return majorVersionDifference;
    }

    public static void checkForUpdates(RaycastedEntityOcclusion plugin, CommandSender audience) {
        ((CompletableFuture)UpdateChecker.fetchFeaturedVersion(plugin).thenAccept(version -> Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            int versionCheck = UpdateChecker.checkIfLaterThan(plugin.getDescription().getVersion(), version);
            if (versionCheck == 0) {
                audience.sendRichMessage("<green>You are using the latest version of Raycasted Entity Occlusions.");
            }
            if (versionCheck == -1) {
                audience.sendRichMessage("<red>You are not using the latest version of Raycasted Entity Occlusions. Please update to <green>v" + version + ".");
                if (audience instanceof Player) {
                    audience.sendRichMessage("\n<hover:show_text:'https://modrinth.com/project/bCjNZu0C/versions'><aqua><u><click:open_url:'https://modrinth.com/project/bCjNZu0C/versions'>Click here to download it.</click></u></aqua></hover>");
                }
            }
            if (versionCheck == 1) {
                audience.sendRichMessage("<yellow>You are using a development build of Raycasted Entity Occlusions. The latest stable version is <green>v" + version + "<yellow>.");
            }
            if (versionCheck == -2) {
                audience.sendRichMessage("<red>Unable to check for updates, invalid version format.");
            }
        }))).exceptionally(ex -> {
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> Logger.warning("Failed to fetch version: " + ex.getMessage()));
            return null;
        });
    }
}

