/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion.bStats;

import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import games.cubi.raycastedEntityOcclusion.bStats.Metrics;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class MetricsCollector {
    private final RaycastedEntityOcclusion plugin;
    private final Metrics metrics;
    private final ConfigManager config;
    private List<Integer> playersOnline = new ArrayList<Integer>();
    private List<Integer> entities = new ArrayList<Integer>();

    public MetricsCollector(RaycastedEntityOcclusion plugin, ConfigManager config) {
        this.plugin = plugin;
        int pluginId = 24553;
        this.metrics = new Metrics((Plugin)plugin, pluginId);
        this.config = config;
        this.registerCustomMetrics();
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, this::collectMetrics, 0L, 6000L);
    }

    public void registerCustomMetrics() {
        this.metrics.addCustomChart(new Metrics.SimplePie("max_occluding_count", () -> String.valueOf(this.config.maxOccludingCount)));
        this.metrics.addCustomChart(new Metrics.SimplePie("cull_players", this::getCullPlayersStatus));
        this.metrics.addCustomChart(new Metrics.SimplePie("raycast_radius", () -> this.getRoundedValue(this.config.raycastRadius, 48)));
        this.metrics.addCustomChart(new Metrics.SimplePie("search_radius", () -> this.getRoundedValue(this.config.searchRadius, 48)));
        this.metrics.addCustomChart(new Metrics.SimplePie("always_show_radius", () -> this.getRoundedValue(this.config.alwaysShowRadius, 16)));
        this.metrics.addCustomChart(new Metrics.SimplePie("engine_mode", () -> String.valueOf(this.config.engineMode)));
        this.metrics.addCustomChart(new Metrics.SimplePie("snapshot_refresh_interval", () -> this.getRoundedValue(this.config.snapshotRefreshInterval, 60)));
        this.metrics.addCustomChart(new Metrics.SimplePie("entity_recheck_interval", () -> this.getRoundedValue(this.config.recheckInterval, 50)));
        this.metrics.addCustomChart(new Metrics.SimplePie("tile_entity_recheck_interval", this::tileEntityCheckStatus));
        this.metrics.addCustomChart(new Metrics.SimplePie("server_size", this::getPlayersOnline));
        this.metrics.addCustomChart(new Metrics.SimplePie("entities", this::getEntities));
    }

    public String getCullPlayersStatus() {
        if (this.config.cullPlayers) {
            if (this.config.onlyCullSneakingPlayers) {
                return "Sneaking";
            }
            return "Always";
        }
        return "Never";
    }

    public String tileEntityCheckStatus() {
        if (this.config.checkTileEntities) {
            return this.getRoundedValue(this.config.tileEntityRecheckInterval, 0);
        }
        return "Disabled";
    }

    public String getRoundedValue(int value, int defaultValue) {
        if (value == defaultValue) {
            return defaultValue + ".0";
        }
        int roundedValue = Math.round((float)value / 5.0f) * 5;
        return String.valueOf(roundedValue);
    }

    public void collectMetrics() {
        this.playersOnline.add(Bukkit.getServer().getOnlinePlayers().size());
        int totalEntities = 0;
        for (World world : Bukkit.getWorlds()) {
            totalEntities += world.getEntities().size();
        }
        this.entities.add(totalEntities);
    }

    public String getPlayersOnline() {
        if (this.playersOnline == null) {
            return "Null";
        }
        int averaged = (int)this.playersOnline.stream().mapToInt(Integer::intValue).average().orElse(-1.0);
        this.playersOnline.clear();
        if (averaged < 0) {
            return "Null";
        }
        if (averaged < 4) {
            return String.valueOf(averaged);
        }
        if (averaged < 7) {
            return "4-6";
        }
        if (averaged < 11) {
            return "7-10";
        }
        if (averaged < 16) {
            return "11-15";
        }
        if (averaged < 26) {
            return "15-25";
        }
        if (averaged < 40) {
            return "26-40";
        }
        if (averaged < 71) {
            return "41-70";
        }
        if (averaged < 101) {
            return "71-100";
        }
        if (averaged < 201) {
            return "101-200";
        }
        if (averaged < 301) {
            return "201-300";
        }
        if (averaged < 501) {
            return "301-500";
        }
        return "500+";
    }

    public String getEntities() {
        if (this.entities == null) {
            return "Null";
        }
        int averaged = (int)this.entities.stream().mapToInt(Integer::intValue).average().orElse(-1.0);
        this.entities.clear();
        if (averaged < 0) {
            return "Null";
        }
        if (averaged < 21) {
            return "0-20";
        }
        if (averaged < 51) {
            return "21-50";
        }
        if (averaged < 101) {
            return "51-100";
        }
        if (averaged < 301) {
            return "101-300";
        }
        if (averaged < 501) {
            return "301-500";
        }
        if (averaged < 1001) {
            return "501-1000";
        }
        if (averaged < 2001) {
            return "1001-2000";
        }
        if (averaged < 5000) {
            return "2001-5000";
        }
        return "5000+";
    }
}

