/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkSnapshotManager {
    private final Map<String, Data> dataMap = new ConcurrentHashMap<String, Data>();

    public ChunkSnapshotManager(final RaycastedEntityOcclusion plugin, final int refreshIntervalSecs) {
        final ConfigManager cfg = plugin.getConfigManager();
        for (World w : plugin.getServer().getWorlds()) {
            for (Chunk c : w.getLoadedChunks()) {
                this.dataMap.put(this.key(c), this.takeSnapshot(c, System.currentTimeMillis()));
            }
        }
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                int chunksRefreshed = 0;
                for (Map.Entry<String, Data> e : ChunkSnapshotManager.this.dataMap.entrySet()) {
                    if (now - e.getValue().lastRefresh < (long)refreshIntervalSecs * 1000L) continue;
                    if (cfg.debugMode) {
                        ++chunksRefreshed;
                    }
                    String key = e.getKey();
                    String[] parts = key.split(":");
                    World w = plugin.getServer().getWorld(parts[0]);
                    if (w == null) {
                        plugin.getLogger().warning("ChunkSnapshotManager: World " + parts[0] + " not found. Please report this on our discord (discord.cubi.games)'");
                        continue;
                    }
                    Chunk c = w.getChunkAt(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                    e.setValue(ChunkSnapshotManager.this.takeSnapshot(c, now));
                }
                if (cfg.debugMode) {
                    plugin.getLogger().info("ChunkSnapshotManager: Refreshed " + chunksRefreshed + " chunks.");
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, (long)refreshIntervalSecs * 5L, (long)refreshIntervalSecs * 5L);
    }

    public void onChunkLoad(Chunk c) {
        this.dataMap.put(this.key(c), this.takeSnapshot(c, System.currentTimeMillis()));
    }

    public void onChunkUnload(Chunk c) {
        this.dataMap.remove(this.key(c));
    }

    public void onBlockChange(Location loc, Material m) {
        Data d = this.dataMap.get(this.key(loc.getChunk()));
        if (d != null) {
            d.delta.put(loc, m);
        }
    }

    private Data takeSnapshot(Chunk c, long now) {
        return new Data(c.getChunkSnapshot(), now);
    }

    private String key(Chunk c) {
        return c.getWorld().getName() + ":" + c.getX() + ":" + c.getZ();
    }

    public Material getMaterialAt(Location loc) {
        Data d = this.dataMap.get(this.key(loc.getChunk()));
        if (d == null) {
            Chunk c = loc.getChunk();
            this.dataMap.put(this.key(c), this.takeSnapshot(c, System.currentTimeMillis()));
            System.err.println("ChunkSnapshotManager: No snapshot for " + String.valueOf(loc.getChunk()) + " Please report this on our discord (discord.cubi.games)'");
            return loc.getBlock().getType();
        }
        Material dm = d.delta.get(loc);
        if (dm != null) {
            return dm;
        }
        int x = loc.getBlockX() & 0xF;
        int y = loc.getBlockY();
        int z = loc.getBlockZ() & 0xF;
        return d.snapshot.getBlockType(x, y, z);
    }

    public static class Data {
        public final ChunkSnapshot snapshot;
        public final Map<Location, Material> delta = new ConcurrentHashMap<Location, Material>();
        public long lastRefresh;

        public Data(ChunkSnapshot snapshot, long time) {
            this.snapshot = snapshot;
            this.lastRefresh = time;
        }
    }
}

