/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import games.cubi.raycastedEntityOcclusion.ChunkSnapshotManager;
import games.cubi.raycastedEntityOcclusion.ConfigManager;
import games.cubi.raycastedEntityOcclusion.MovementTracker;
import games.cubi.raycastedEntityOcclusion.RaycastUtil;
import games.cubi.raycastedEntityOcclusion.RaycastedEntityOcclusion;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Engine {
    public static void runEngine(ConfigManager cfg, ChunkSnapshotManager snapMgr, MovementTracker tracker, RaycastedEntityOcclusion plugin) {
        ArrayList<RayJob> jobs = new ArrayList<RayJob>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            Location eye = p.getEyeLocation().clone();
            Location predEye = null;
            if (cfg.engineMode == 2) {
                predEye = tracker.getPredictedLocation(p);
            }
            for (Entity e : p.getNearbyEntities((double)cfg.searchRadius, (double)cfg.searchRadius, (double)cfg.searchRadius)) {
                Location target;
                double dist;
                if (e == p) continue;
                if (e instanceof Player) {
                    Player pl = (Player)e;
                    if (!cfg.cullPlayers || cfg.onlyCullSneakingPlayers && !pl.isSneaking()) {
                        p.showEntity((Plugin)plugin, e);
                        continue;
                    }
                }
                if ((dist = eye.distance(target = e.getLocation().add(0.0, e.getHeight() / 2.0, 0.0).clone())) <= (double)cfg.alwaysShowRadius) {
                    p.showEntity((Plugin)plugin, e);
                    continue;
                }
                if (dist > (double)cfg.raycastRadius) {
                    p.hideEntity((Plugin)plugin, e);
                    continue;
                }
                if (p.canSee(e) && plugin.tick % cfg.recheckInterval != 0) continue;
                jobs.add(new RayJob(p.getUniqueId(), e.getUniqueId(), eye, predEye, target));
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            ArrayList<RayResult> results = new ArrayList<RayResult>(jobs.size());
            for (RayJob job : jobs) {
                boolean vis = RaycastUtil.raycast(job.start, job.end, cfg.maxOccludingCount, cfg.debugMode, snapMgr);
                if (!vis && job.predictedStart != null) {
                    if (cfg.debugMode) {
                        job.predictedStart.getWorld().spawnParticle(Particle.DUST, job.predictedStart, 1, (Object)new Particle.DustOptions(Color.BLUE, 1.0f));
                    }
                    vis = RaycastUtil.raycast(job.predictedStart, job.end, cfg.maxOccludingCount, cfg.debugMode, snapMgr);
                }
                results.add(new RayResult(job.playerId, job.entityId, vis));
            }
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                for (RayResult r : results) {
                    Player p = Bukkit.getPlayer((UUID)r.playerId);
                    Entity ent = Bukkit.getEntity((UUID)r.entityId);
                    if (p == null || ent == null) continue;
                    if (r.visible) {
                        p.showEntity((Plugin)plugin, ent);
                        continue;
                    }
                    p.hideEntity((Plugin)plugin, ent);
                }
            });
        });
    }

    private static class RayJob {
        final UUID playerId;
        final UUID entityId;
        final Location start;
        final Location predictedStart;
        final Location end;

        RayJob(UUID p, UUID e, Location s, Location pred, Location t) {
            this.playerId = p;
            this.entityId = e;
            this.start = s;
            this.predictedStart = pred;
            this.end = t;
        }
    }

    private static class RayResult {
        final UUID playerId;
        final UUID entityId;
        final boolean visible;

        RayResult(UUID p, UUID e, boolean v) {
            this.playerId = p;
            this.entityId = e;
            this.visible = v;
        }
    }
}

