/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MovementTracker {
    private final Map<Player, Deque<Location>> history = new ConcurrentHashMap<Player, Deque<Location>>();

    public MovementTracker(Plugin plugin) {
        new BukkitRunnable(){

            public void run() {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    MovementTracker.this.history.computeIfAbsent(p, k -> new ArrayDeque(5));
                    Deque<Location> dq = MovementTracker.this.history.get(p);
                    if (dq.size() >= 5) {
                        dq.removeFirst();
                    }
                    dq.addLast(p.getEyeLocation().clone());
                }
            }
        }.runTaskTimer(plugin, 1L, 1L);
    }

    public Location getPredictedLocation(Player p) {
        double dz;
        double dy;
        Deque<Location> dq = this.history.get(p);
        if (dq == null || dq.size() < 5) {
            return null;
        }
        Location old = dq.peekFirst();
        Location now = dq.peekLast();
        double dx = now.getX() - old.getX();
        double speed = Math.sqrt(dx * dx + (dy = now.getY() - old.getY()) * dy + (dz = now.getZ() - old.getZ()) * dz) / 5.0;
        if (speed < 0.1) {
            return null;
        }
        return now.clone().add(dx * 2.0, dy, dz * 2.0);
    }
}

