/*
 * Decompiled with CFR 0.152.
 */
package games.cubi.raycastedEntityOcclusion;

import games.cubi.raycastedEntityOcclusion.ChunkSnapshotManager;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class RaycastUtil {
    public static boolean raycast(Location start, Location end, int maxOccluding, boolean debug, ChunkSnapshotManager snap) {
        Particle.DustOptions dustRed = null;
        Particle.DustOptions dustGreen = null;
        if (debug) {
            dustRed = new Particle.DustOptions(Color.RED, 1.0f);
            dustGreen = new Particle.DustOptions(Color.GREEN, 1.0f);
        }
        double total = start.distance(end);
        double traveled = 0.0;
        Location curr = start.clone();
        Vector dir = end.toVector().subtract(start.toVector()).normalize();
        while (traveled < total) {
            curr.add(dir);
            traveled += 1.0;
            Material mat = snap.getMaterialAt(curr);
            if (mat.isOccluding()) {
                --maxOccluding;
                if (debug) {
                    start.getWorld().spawnParticle(Particle.DUST, curr, 1, (Object)dustRed);
                }
                if (maxOccluding >= 1) continue;
                return false;
            }
            if (!debug) continue;
            start.getWorld().spawnParticle(Particle.DUST, curr, 1, (Object)dustGreen);
        }
        return true;
    }
}

