/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.overweightfarming.init.OFBlocks;
import net.orcinus.overweightfarming.init.OFItems;
import net.orcinus.overweightfarming.init.OFParticleTypes;

public class PeeledMelonBlock
extends Block {
    private final SeedState seedState;

    public PeeledMelonBlock(SeedState seedState, BlockBehaviour.Properties properties) {
        super(properties);
        this.seedState = seedState;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < random.nextInt(1) + 1; ++i) {
            this.trySpawnDripParticles(world, pos, state);
        }
    }

    private void trySpawnDripParticles(Level world, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.getFluidState().isEmpty() && !(world.random.nextFloat() < 0.3f) && (d0 = (voxelshape = state.getCollisionShape((BlockGetter)world, pos)).max(Direction.Axis.Y)) >= 1.0 && !state.is(BlockTags.IMPERMEABLE)) {
            double d1 = voxelshape.min(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.spawnParticle(world, pos, voxelshape, (double)pos.getY() + d1 - 0.05);
            } else {
                BlockPos blockpos = pos.below();
                BlockState blockstate = world.getBlockState(blockpos);
                VoxelShape voxelshape1 = blockstate.getCollisionShape((BlockGetter)world, blockpos);
                double d2 = voxelshape1.max(Direction.Axis.Y);
                if ((d2 < 1.0 || !blockstate.isCollisionShapeFullBlock((BlockGetter)world, blockpos)) && blockstate.getFluidState().isEmpty()) {
                    this.spawnParticle(world, pos, voxelshape, (double)pos.getY() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(Level world, BlockPos pos, VoxelShape p_49615_, double y) {
        this.spawnFluidParticle(world, (double)pos.getX() + p_49615_.min(Direction.Axis.X), (double)pos.getX() + p_49615_.max(Direction.Axis.X), (double)pos.getZ() + p_49615_.min(Direction.Axis.Z), (double)pos.getZ() + p_49615_.max(Direction.Axis.Z), y);
    }

    private void spawnFluidParticle(Level world, double minX, double maxX, double minZ, double maxZ, double y) {
        world.addParticle((ParticleOptions)OFParticleTypes.DRIPPING_MELON.get(), Mth.lerp((double)world.random.nextDouble(), (double)minX, (double)maxX), y, Mth.lerp((double)world.random.nextDouble(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.seedState != SeedState.SEEDLESS) {
            Block finalBlock = this.seedState == SeedState.SEEDED ? (Block)OFBlocks.HALF_SEEDED_PEELED_MELON.get() : (Block)OFBlocks.SEEDLESS_PEELED_MELON.get();
            PeeledMelonBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.MELON_SEEDS));
            world.setBlockAndUpdate(pos, finalBlock.defaultBlockState());
            world.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.4f);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (stack.getItem() == Items.GLASS_BOTTLE) {
            stack.shrink(1);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)OFItems.MELON_JUICE.get()));
            } else if (!player.getInventory().add(new ItemStack((ItemLike)OFItems.MELON_JUICE.get()))) {
                player.drop(new ItemStack((ItemLike)OFItems.MELON_JUICE.get()), false);
            }
            world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!world.isClientSide()) {
                if (world.getRandom().nextInt(7) == 0) {
                    world.destroyBlock(pos, false);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public static enum SeedState {
        SEEDED,
        HALF_SEEDED,
        SEEDLESS;

    }
}

