/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.init;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.orcinus.overweightfarming.OverweightFarming;
import net.orcinus.overweightfarming.init.OFPlacedFeatures;
import net.orcinus.overweightfarming.world.gen.decorators.AppleTreeDecorator;

public class OFConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> APPLE_OAK = OFConfiguredFeatures.createKey("apple_oak");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FANCY_APPLE_OAK = OFConfiguredFeatures.createKey("fancy_apple_oak");
    public static final ResourceKey<ConfiguredFeature<?, ?>> APPLE_OAK_BEES = OFConfiguredFeatures.createKey("apple_oak_bees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FANCY_APPLE_OAK_BEES = OFConfiguredFeatures.createKey("fancy_apple_oak_bees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> APPLE_OAK_TREES = OFConfiguredFeatures.createKey("apple_oak_trees");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        AppleTreeDecorator appleTreeDecorator = new AppleTreeDecorator();
        AppleTreeDecorator tallAppleTreeDecorator = new AppleTreeDecorator(6);
        BeehiveDecorator beehiveDecorator = new BeehiveDecorator(0.05f);
        FeatureUtils.register(context, APPLE_OAK, (Feature)Feature.TREE, (FeatureConfiguration)OFConfiguredFeatures.oak().decorators(List.of(appleTreeDecorator)).build());
        FeatureUtils.register(context, FANCY_APPLE_OAK, (Feature)Feature.TREE, (FeatureConfiguration)OFConfiguredFeatures.createFancyOak().decorators(List.of(tallAppleTreeDecorator)).build());
        FeatureUtils.register(context, APPLE_OAK_BEES, (Feature)Feature.TREE, (FeatureConfiguration)OFConfiguredFeatures.oak().decorators(List.of(beehiveDecorator, appleTreeDecorator)).build());
        FeatureUtils.register(context, FANCY_APPLE_OAK_BEES, (Feature)Feature.TREE, (FeatureConfiguration)OFConfiguredFeatures.createFancyOak().decorators(List.of(beehiveDecorator, tallAppleTreeDecorator)).build());
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        FeatureUtils.register(context, APPLE_OAK_TREES, (Feature)Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(OFPlacedFeatures.APPLE_OAK_CHECKED), 0.2f), new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(OFPlacedFeatures.APPLE_OAK_BEES_CHECKED), 0.1f), new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(OFPlacedFeatures.FANCY_APPLE_OAK_BEES_CHECKED), 0.4f)), (Holder)placedFeatures.getOrThrow(OFPlacedFeatures.FANCY_APPLE_OAK_CHECKED)));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyOak() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LEAVES), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines();
    }

    private static TreeConfiguration.TreeConfigurationBuilder oak() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LEAVES), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)OverweightFarming.id(name));
    }
}

