/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.items;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.orcinus.overweightfarming.OverweightFarming;
import net.orcinus.overweightfarming.client.models.StrawHatModel;
import net.orcinus.overweightfarming.init.OFArmorMaterials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrawHatItem
extends ArmorItem {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"overweight_farming", (String)"textures/entity/straw_hat/straw_hat.png");
    private static final ResourceLocation TRANS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"overweight_farming", (String)"textures/entity/straw_hat/trans_rights.png");
    private static final ResourceLocation STRAW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"overweight_farming", (String)"textures/entity/straw_hat/straw_hat_straw.png");
    private static final ResourceLocation TEXTURE_420 = ResourceLocation.fromNamespaceAndPath((String)"overweight_farming", (String)"textures/entity/straw_hat/420.png");
    public static final LinkedList<String> LISTS = (LinkedList)Util.make((Object)Lists.newLinkedList(), list -> {
        list.add("accessible_knowledge");
        list.add("amogus");
        list.add("atroxic");
        list.add("birb");
        list.add("black_hat");
        list.add("convenient_cauldron");
        list.add("delightful");
        list.add("doset");
        list.add("electrum_hat");
        list.add("frog_tongue");
        list.add("froggy_straw_hat");
        list.add("lead_hat");
        list.add("leadly_hat");
        list.add("pebble_hat");
        list.add("pirates");
        list.add("potat");
        list.add("silver_hat");
        list.add("there_is_a_frog_on_your_head_yknow");
    });

    public StrawHatItem(ArmorItem.Type slot, Item.Properties properties) {
        super(OFArmorMaterials.STRAW, slot, properties);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        for (String id : LISTS) {
            String namingContent = id.replace('_', ' ');
            if (!StrawHatItem.getContents(stack).equals(namingContent)) continue;
            return StrawHatItem.getContents(stack).equals(namingContent) ? OverweightFarming.id("textures/entity/straw_hat/" + id + ".png") : TEXTURE;
        }
        return StrawHatItem.is420(stack) ? TEXTURE_420 : (StrawHatItem.isStraw(stack) ? STRAW_TEXTURE : (StrawHatItem.isTrans(stack) ? TRANS_TEXTURE : TEXTURE));
    }

    public static boolean is420(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("420");
    }

    public static boolean isStraw(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("Straw");
    }

    public static boolean isTrans(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("Trans Rights");
    }

    @NotNull
    private static String getContents(ItemStack stack) {
        return stack.getHoverName().getString();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return new StrawHatModel(StrawHatModel.createBodyLayer().bakeRoot());
            }
        });
    }
}

