/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.orcinus.overweightfarming.blocks.CropFullBlock;
import net.orcinus.overweightfarming.blocks.OverweightCarrotBlock;
import net.orcinus.overweightfarming.init.OFBlockTags;
import net.orcinus.overweightfarming.init.OFBlocks;
import net.orcinus.overweightfarming.util.OverweightType;
import org.jetbrains.annotations.Nullable;

public record OverweightGrowthManager(RandomSource random) {
    public Map<Block, Pair<OverweightType, Block>> getOverweightMap() {
        return (Map)Util.make((Object)Maps.newHashMap(), map -> {
            map.put(Blocks.CARROTS, Pair.of((Object)((Object)OverweightType.SPROUT), (Object)((Block)OFBlocks.OVERWEIGHT_CARROT.get())));
            map.put(Blocks.POTATOES, Pair.of((Object)((Object)OverweightType.DEFAULT), (Object)(this.random.nextInt(20) == 0 ? (Block)OFBlocks.OVERWEIGHT_POISONOUS_POTATO.get() : (Block)OFBlocks.OVERWEIGHT_POTATO.get())));
            map.put(Blocks.BEETROOTS, Pair.of((Object)((Object)OverweightType.DEFAULT), (Object)((Block)OFBlocks.OVERWEIGHT_BEETROOT.get())));
            map.put(Blocks.COCOA, Pair.of((Object)((Object)OverweightType.SIMPLE), (Object)((Block)OFBlocks.OVERWEIGHT_COCOA.get())));
            map.put(Blocks.NETHER_WART, Pair.of((Object)((Object)OverweightType.INVERTED), (Object)((Block)OFBlocks.OVERWEIGHT_NETHER_WART.get())));
            map.put(this.getCompatBlock("farmersdelight", "cabbages"), Pair.of((Object)((Object)OverweightType.SIMPLE), (Object)((Block)OFBlocks.OVERWEIGHT_CABBAGE.get())));
            map.put(this.getCompatBlock("farmersdelight", "onions"), Pair.of((Object)((Object)OverweightType.DEFAULT), (Object)((Block)OFBlocks.OVERWEIGHT_ONION.get())));
            map.put(this.getCompatBlock("hedgehog", "kiwi_vines"), Pair.of((Object)((Object)OverweightType.SIMPLE), (Object)((Block)OFBlocks.OVERWEIGHT_KIWI.get())));
            map.put(this.getCompatBlock("snowyspirit", "ginger"), Pair.of((Object)((Object)OverweightType.DEFAULT), (Object)((Block)OFBlocks.OVERWEIGHT_GINGER.get())));
        });
    }

    public void growOverweightCrops(ServerLevel serverLevel, BlockPos blockPos, BlockState state, RandomSource random) {
        for (Block block : this.getOverweightMap().keySet()) {
            BlockState blockState;
            if (!state.is(block)) continue;
            if (!this.isNearOvergrowthObstacles(serverLevel, blockPos)) {
                return;
            }
            Pair<OverweightType, Block> pair = this.getOverweightMap().get(block);
            OverweightType overweightType = (OverweightType)((Object)pair.getFirst());
            Block overweightBlock = (Block)pair.getSecond();
            if (!(overweightBlock instanceof CropFullBlock)) continue;
            CropFullBlock cropFullBlock = (CropFullBlock)overweightBlock;
            if (cropFullBlock instanceof OverweightCarrotBlock) {
                OverweightCarrotBlock carrotBlock = (OverweightCarrotBlock)cropFullBlock;
                blockState = (BlockState)carrotBlock.defaultBlockState().setValue((Property)OverweightCarrotBlock.FACING, (Comparable)Direction.UP);
            } else {
                blockState = cropFullBlock.defaultBlockState();
            }
            BlockState overweightState = blockState;
            Block stemBlock = cropFullBlock.getStemBlock();
            BlockState stemState = null;
            if (stemBlock != null) {
                stemState = stemBlock.defaultBlockState();
            }
            switch (overweightType) {
                case DEFAULT: {
                    this.simpleOverweightGrowth(serverLevel, blockPos, overweightState, stemState);
                    break;
                }
                case SIMPLE: {
                    this.setBlock(serverLevel, blockPos, overweightState);
                    break;
                }
                case SPROUT: {
                    this.sproutGrowth(serverLevel, blockPos, random, overweightState, stemState);
                    break;
                }
                case INVERTED: {
                    this.invertedGrowth(serverLevel, blockPos, overweightState, stemState);
                }
            }
        }
    }

    private void invertedGrowth(ServerLevel world, BlockPos blockPos, BlockState overweightState, BlockState stemState) {
        if (!world.isStateAtPosition(blockPos.above(), DripstoneUtils::isEmptyOrWater)) {
            return;
        }
        this.setBlock(world, blockPos.above(), overweightState);
        this.setBlock(world, blockPos, stemState);
    }

    @Nullable
    private Block getCompatBlock(String modid, String name) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    private void simpleOverweightGrowth(ServerLevel world, BlockPos blockPos, BlockState overweightCrop, BlockState stemBlock) {
        this.setBlock(world, blockPos, overweightCrop);
        if (stemBlock != null) {
            if (stemBlock.getBlock() instanceof DoublePlantBlock) {
                boolean flag;
                boolean bl = flag = world.isEmptyBlock(blockPos.above()) && world.isEmptyBlock(blockPos.above(2));
                if (!flag) {
                    return;
                }
                DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)stemBlock.getBlock().defaultBlockState(), (BlockPos)blockPos.above(), (int)2);
            } else {
                this.setBlock(world, blockPos.above(), stemBlock);
            }
        }
    }

    private void sproutGrowth(ServerLevel world, BlockPos blockPos, RandomSource random, BlockState blockState, BlockState stemState) {
        int height = random.nextBoolean() && random.nextInt(5) == 0 ? (random.nextBoolean() && random.nextInt(10) == 0 ? 4 : 3) : 2;
        BlockPos startPos = blockPos.above();
        BlockPos.MutableBlockPos mutableBlockPos = startPos.mutable();
        for (int i = 0; i < height; ++i) {
            BlockState placeState = blockState;
            if (i == 0 && stemState != null) {
                placeState = stemState;
            }
            this.setBlock(world, (BlockPos)mutableBlockPos, placeState);
            mutableBlockPos.move(Direction.DOWN);
        }
    }

    private void setBlock(ServerLevel world, BlockPos blockPos, BlockState overweightState) {
        for (Block cropBlock : this.getOverweightMap().keySet()) {
            BlockState state = world.getBlockState(blockPos);
            if (!state.isAir() && state.getBlock() != cropBlock && !state.is(Blocks.FARMLAND) && !state.is(Blocks.DIRT)) continue;
            world.setBlock(blockPos, overweightState, 2);
        }
    }

    private boolean isNearOvergrowthObstacles(ServerLevel world, BlockPos blockPos) {
        boolean flag = true;
        int radius = 10;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos pos = new BlockPos(blockPos.getX() + x, blockPos.getY(), blockPos.getZ() + z);
                BlockState state = world.getBlockState(pos);
                if (!state.is(OFBlockTags.OVERWEIGHT_OBSTACLES) || !state.is(OFBlockTags.OVERWEIGHT_OBSTACLES)) continue;
                flag = false;
            }
        }
        return flag;
    }
}

