/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.world.gen.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.orcinus.overweightfarming.init.OFBlockTags;
import net.orcinus.overweightfarming.init.OFBlocks;
import net.orcinus.overweightfarming.init.OFTreeDecoratorTypes;

public class AppleTreeDecorator
extends TreeDecorator {
    public static final MapCodec<AppleTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("minHeightRequirement").forGetter(decorator -> decorator.minHeightRequirement)).apply((Applicative)instance, AppleTreeDecorator::new));
    private final int minHeightRequirement;

    public AppleTreeDecorator() {
        this(0);
    }

    public AppleTreeDecorator(int minHeightRequirement) {
        this.minHeightRequirement = minHeightRequirement;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)OFTreeDecoratorTypes.APPLE.get();
    }

    public void place(TreeDecorator.Context context) {
        List list3;
        int height = context.logs().size();
        if (this.minHeightRequirement > 0 && height < this.minHeightRequirement) {
            return;
        }
        ObjectArrayList list = context.leaves();
        if (!list.isEmpty() && !(list3 = list.stream().filter(pos -> context.isAir(pos.below()) && context.isAir(pos.below(2)) && context.isAir(pos.below(3)) && context.level().isStateAtPosition(pos, state -> state.is(OFBlockTags.OVERWEIGHT_APPLE_LEAVES))).collect(Collectors.toList())).isEmpty()) {
            Collections.shuffle(list3);
            Optional optional = list3.stream().findFirst();
            optional.ifPresent(blockPos -> context.setBlock(blockPos.below(), ((Block)OFBlocks.OVERWEIGHT_APPLE.get()).defaultBlockState()));
        }
    }
}

