/*
 * Decompiled with CFR 0.152.
 */
package me.ivan1f.tweakerplus.gui;

import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Arrays;
import java.util.function.Function;
import me.ivan1f.tweakerplus.TweakerPlusMod;
import me.ivan1f.tweakerplus.util.StringUtil;

public class TweakerPlusOptionLabel
extends WidgetLabel {
    public static final double TRANSLATION_SCALE = 0.65;
    private final String[] originalLines;
    private final boolean showOriginalLines;

    public TweakerPlusOptionLabel(int x, int y, int width, int height, int textColor, String[] displayLines, String[] originalLines, Function<String, String> lineModifier) {
        super(x, y, width, height, textColor, displayLines);
        this.originalLines = originalLines;
        boolean showOriginalLines = false;
        for (int i = 0; i < this.originalLines.length; ++i) {
            String linesToDisplay = (String)this.labels.get(i);
            if (!this.originalLines[i].equals(StringUtil.removeFormattingCode(linesToDisplay))) {
                showOriginalLines = true;
            }
            this.labels.set(i, lineModifier.apply(linesToDisplay));
        }
        this.showOriginalLines = showOriginalLines;
        if (this.showOriginalLines != TweakerPlusOptionLabel.willShowOriginalLines(displayLines, originalLines)) {
            TweakerPlusMod.LOGGER.warn("Inconsistent showOriginalLines result: {} {}", (Object)this.showOriginalLines, (Object)TweakerPlusOptionLabel.willShowOriginalLines(displayLines, originalLines));
        }
    }

    public static boolean willShowOriginalLines(String[] displayLines, String[] originalLines) {
        return !Arrays.equals(originalLines, Arrays.stream(displayLines).map(x$0 -> StringUtils.translate((String)x$0, (Object[])new Object[0])).map(StringUtil::removeFormattingCode).toArray(String[]::new));
    }

    public String[] getOriginalLines() {
        return this.originalLines;
    }

    public boolean shouldShowOriginalLines() {
        return this.showOriginalLines;
    }
}

