/*
 * Decompiled with CFR 0.152.
 */
package me.ivan1f.tweakerplus.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import me.ivan1f.tweakerplus.config.Config;
import me.ivan1f.tweakerplus.config.TweakerPlusConfigs;
import me.ivan1f.tweakerplus.config.TweakerPlusOption;
import me.ivan1f.tweakerplus.util.FabricUtil;
import me.ivan1f.tweakerplus.util.FileUtil;

public class TweakerPlusConfigStorage
implements IConfigHandler {
    private static JsonObject ROOT_JSON_OBJ = new JsonObject();

    public static void loadFromFile() {
        JsonElement element;
        File configFile = FileUtil.getConfigFile();
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            TweakerPlusConfigStorage.loadFromJson(root);
            ROOT_JSON_OBJ = root;
        }
    }

    private static <T extends IConfigBase> List<T> getConfigOptions(Config.Type optionType) {
        return TweakerPlusConfigs.getOptions(optionType).stream().filter(o -> !o.isDevOnly() || FabricUtil.isDevelopmentEnvironment()).map(TweakerPlusOption::getConfig).collect(Collectors.toList());
    }

    public static void loadFromJson(JsonObject jsonObject) {
        ConfigUtils.readConfigBase((JsonObject)jsonObject, (String)"Generic", TweakerPlusConfigStorage.getConfigOptions(Config.Type.GENERIC));
        ConfigUtils.readConfigBase((JsonObject)jsonObject, (String)"GenericHotkeys", TweakerPlusConfigStorage.getConfigOptions(Config.Type.HOTKEY));
        ConfigUtils.readConfigBase((JsonObject)jsonObject, (String)"Lists", TweakerPlusConfigStorage.getConfigOptions(Config.Type.LIST));
        ConfigUtils.readHotkeyToggleOptions((JsonObject)jsonObject, (String)"TweakHotkeys", (String)"TweakToggles", TweakerPlusConfigStorage.getConfigOptions(Config.Type.TWEAK));
        ConfigUtils.readHotkeyToggleOptions((JsonObject)jsonObject, (String)"DisableHotkeys", (String)"DisableToggles", TweakerPlusConfigStorage.getConfigOptions(Config.Type.DISABLE));
    }

    public static void saveToFile() {
        File configFile = FileUtil.getConfigFile();
        JsonObject root = ROOT_JSON_OBJ;
        ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", TweakerPlusConfigStorage.getConfigOptions(Config.Type.GENERIC));
        ConfigUtils.writeConfigBase((JsonObject)root, (String)"GenericHotkeys", TweakerPlusConfigStorage.getConfigOptions(Config.Type.HOTKEY));
        ConfigUtils.writeConfigBase((JsonObject)root, (String)"Lists", TweakerPlusConfigStorage.getConfigOptions(Config.Type.LIST));
        ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"TweakHotkeys", (String)"TweakToggles", TweakerPlusConfigStorage.getConfigOptions(Config.Type.TWEAK));
        ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"DisableHotkeys", (String)"DisableToggles", TweakerPlusConfigStorage.getConfigOptions(Config.Type.DISABLE));
        JsonUtils.writeJsonToFile((JsonObject)root, (File)configFile);
    }

    public void load() {
        TweakerPlusConfigStorage.loadFromFile();
    }

    public void save() {
        TweakerPlusConfigStorage.saveToFile();
    }
}

