/*
 * Decompiled with CFR 0.152.
 */
package me.ivan1f.tweakerplus.util;

import com.mojang.blaze3d.systems.RenderSystem;

public class RenderUtil {
    public static Scaler createScaler(int anchorX, int anchorY, double factor) {
        return new Scaler(anchorX, anchorY, factor);
    }

    public static class Scaler {
        private final int anchorX;
        private final int anchorY;
        private final double factor;

        private Scaler(int anchorX, int anchorY, double factor) {
            this.anchorX = anchorX;
            this.anchorY = anchorY;
            if (factor <= 0.0) {
                throw new IllegalArgumentException("factor should be greater than 0, but " + factor + " found");
            }
            this.factor = factor;
        }

        public void apply() {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)(-this.anchorX) * this.factor), (double)((double)(-this.anchorY) * this.factor), (double)0.0);
            RenderSystem.scaled((double)this.factor, (double)this.factor, (double)1.0);
            RenderSystem.translated((double)((double)this.anchorX / this.factor), (double)((double)this.anchorY / this.factor), (double)0.0);
        }

        public void restore() {
            RenderSystem.popMatrix();
        }
    }
}

