/*
 * Decompiled with CFR 0.152.
 */
package me.ivan1f.tweakerplus.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.ivan1f.tweakerplus.TweakerPlusMod;
import me.ivan1f.tweakerplus.config.Config;
import me.ivan1f.tweakerplus.config.ConfigFactory;
import me.ivan1f.tweakerplus.config.TweakerPlusOption;
import me.ivan1f.tweakerplus.config.options.TweakerPlusConfigBoolean;
import me.ivan1f.tweakerplus.config.options.TweakerPlusConfigBooleanHotkeyed;
import me.ivan1f.tweakerplus.config.options.TweakerPlusConfigDouble;
import me.ivan1f.tweakerplus.config.options.TweakerPlusConfigHotkey;
import me.ivan1f.tweakerplus.config.options.TweakerPlusConfigInteger;
import me.ivan1f.tweakerplus.config.options.TweakerPlusIConfigBase;
import me.ivan1f.tweakerplus.gui.TweakerPlusConfigGui;
import net.minecraft.class_310;

public class TweakerPlusConfigs {
    @Config(value=Config.Type.GENERIC)
    public static final TweakerPlusConfigBooleanHotkeyed LIMIT_WORLD_MODIFICATION = ConfigFactory.newConfigBooleanHotkeyed("limitWorldModification", false, "");
    @Config(value=Config.Type.GENERIC)
    public static final TweakerPlusConfigBooleanHotkeyed IMMEDIATELY_RESPAWN = ConfigFactory.newConfigBooleanHotkeyed("immediatelyRespawn", false, "");
    @Config(value=Config.Type.GENERIC)
    public static final TweakerPlusConfigDouble PLAYER_LIST_SCALE = ConfigFactory.newConfigDouble("playerListScale", 1.0, 0.001, 2.0);
    @Config(value=Config.Type.DISABLE)
    public static final TweakerPlusConfigBooleanHotkeyed DISABLE_PUMPKIN_OVERLAY = ConfigFactory.newConfigBooleanHotkeyed("disablePumpkinOverlay", false, "");
    @Config(value=Config.Type.DISABLE)
    public static final TweakerPlusConfigBooleanHotkeyed DISABLE_PORTAL_OVERLAY = ConfigFactory.newConfigBooleanHotkeyed("disablePortalOverlay", false, "");
    @Config(value=Config.Type.GENERIC)
    public static final TweakerPlusConfigBoolean RESOURCE_PACK_INCOMPATIBLE_IGNORED = ConfigFactory.newConfigBoolean("resourcePackIncompatibleIgnored", false);
    @Config(value=Config.Type.GENERIC, category=Config.Category.MOD_TWEAKS, restriction={@Restriction(require={@Condition(value="xaerominimap")})})
    public static final TweakerPlusConfigBoolean XMAP_NO_DEATH_WAYPOINT_FOR_CREATIVE = ConfigFactory.newConfigBoolean("xmapNoDeathWaypointForCreative", false);
    @Config(value=Config.Type.GENERIC, category=Config.Category.MOD_TWEAKS)
    public static final TweakerPlusConfigBoolean LEFT_ALIGN_TITLE_GLOBALLY = ConfigFactory.newConfigBoolean("leftAlignTitleGlobally", false);
    @Config(value=Config.Type.GENERIC, category=Config.Category.MOD_TWEAKS, restriction={@Restriction(require={@Condition(value="litematica")})})
    public static final TweakerPlusConfigBoolean BUNDLE_ORIGIN_IN_SCHEMATIC = ConfigFactory.newConfigBoolean("bundleOriginInSchematic", false);
    @Config(value=Config.Type.GENERIC, category=Config.Category.SETTING)
    public static final TweakerPlusConfigBoolean HIDE_DISABLE_OPTIONS = ConfigFactory.newConfigBoolean("hideDisabledOptions", false);
    @Config(value=Config.Type.HOTKEY, category=Config.Category.SETTING)
    public static final TweakerPlusConfigHotkey OPEN_TWEAKERPLUS_CONFIG_GUI = ConfigFactory.newConfigHotKey("openTweakerPlusConfigGui", "P,C");
    @Config(value=Config.Type.TWEAK, category=Config.Category.SETTING)
    public static final TweakerPlusConfigBooleanHotkeyed TWEAKERPLUS_DEBUG_MODE = ConfigFactory.newConfigBooleanHotkeyed("tweakerPlusDebugMode");
    @Config(value=Config.Type.GENERIC, category=Config.Category.SETTING, debug=true)
    public static final TweakerPlusConfigInteger TWEAKERPLUS_DEBUG_INT = ConfigFactory.newConfigInteger("tweakerPlusDebugInt", 0, -1000, 1000);
    @Config(value=Config.Type.GENERIC, category=Config.Category.SETTING, debug=true)
    public static final TweakerPlusConfigInteger TWEAKERPLUS_DEBUG_DOUBLE = ConfigFactory.newConfigInteger("tweakerPlusDebugDouble", 0, -1, 1);
    private static final List<TweakerPlusOption> OPTIONS = Lists.newArrayList();
    private static final Map<Config.Category, List<TweakerPlusOption>> CATEGORY_TO_OPTION = Maps.newLinkedHashMap();
    private static final Map<Config.Type, List<TweakerPlusOption>> TYPE_TO_OPTION = Maps.newLinkedHashMap();
    private static final Map<IConfigBase, TweakerPlusOption> CONFIG_TO_OPTION = Maps.newLinkedHashMap();

    public static void initCallbacks() {
        IValueChangeCallback redrawConfigGui = newValue -> TweakerPlusConfigGui.getCurrentInstance().ifPresent(TweakerPlusConfigGui::reDraw);
        OPEN_TWEAKERPLUS_CONFIG_GUI.getKeybind().setCallback(TweakerPlusConfigGui::onOpenGuiHotkey);
        HIDE_DISABLE_OPTIONS.setValueChangeCallback(redrawConfigGui);
        IMMEDIATELY_RESPAWN.setValueChangeCallback(newValue -> {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_22420(!newValue.getBooleanValue());
            }
        });
        TWEAKERPLUS_DEBUG_MODE.setValueChangeCallback(redrawConfigGui);
    }

    public static List<TweakerPlusOption> getOptions(Config.Category categoryType) {
        return CATEGORY_TO_OPTION.getOrDefault((Object)categoryType, Collections.emptyList());
    }

    public static List<TweakerPlusOption> getOptions(Config.Type optionType) {
        return TYPE_TO_OPTION.getOrDefault((Object)optionType, Collections.emptyList());
    }

    public static Stream<TweakerPlusIConfigBase> getAllConfigOptionStream() {
        return OPTIONS.stream().map(TweakerPlusOption::getConfig);
    }

    public static Optional<TweakerPlusOption> getOptionFromConfig(IConfigBase iConfigBase) {
        return Optional.ofNullable(CONFIG_TO_OPTION.get(iConfigBase));
    }

    public static boolean hasConfig(IConfigBase iConfigBase) {
        return TweakerPlusConfigs.getOptionFromConfig(iConfigBase).isPresent();
    }

    static {
        for (Field field : TweakerPlusConfigs.class.getDeclaredFields()) {
            Config annotation = field.getAnnotation(Config.class);
            if (annotation == null) continue;
            try {
                Object config = field.get(null);
                if (!(config instanceof TweakerPlusIConfigBase)) {
                    TweakerPlusMod.LOGGER.warn("[TweakerPlus] {} is not a subclass of TweakerPlusIConfigBase", config);
                    continue;
                }
                TweakerPlusOption tweakerPlusOption = new TweakerPlusOption(annotation, (TweakerPlusIConfigBase)config);
                OPTIONS.add(tweakerPlusOption);
                CATEGORY_TO_OPTION.computeIfAbsent(tweakerPlusOption.getCategory(), k -> Lists.newArrayList()).add(tweakerPlusOption);
                TYPE_TO_OPTION.computeIfAbsent(tweakerPlusOption.getType(), k -> Lists.newArrayList()).add(tweakerPlusOption);
                CONFIG_TO_OPTION.put(tweakerPlusOption.getConfig(), tweakerPlusOption);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

