/*
 * Decompiled with CFR 0.152.
 */
package me.ivan1f.tweakerplus.gui;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.ivan1f.tweakerplus.TweakerPlusMod;
import me.ivan1f.tweakerplus.config.Config;
import me.ivan1f.tweakerplus.config.TweakerPlusConfigs;
import me.ivan1f.tweakerplus.config.TweakerPlusOption;
import me.ivan1f.tweakerplus.gui.SelectorDropDownList;
import me.ivan1f.tweakerplus.util.FabricUtil;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class TweakerPlusConfigGui
extends GuiConfigsBase {
    @Nullable
    private static TweakerPlusConfigGui currentInstance = null;
    private static Config.Category category = Config.Category.MC_TWEAKS;
    @Nullable
    private Config.Type filteredType = null;
    @Nullable
    private SelectorDropDownList<Config.Type> typeFilterDropDownList = null;

    public TweakerPlusConfigGui() {
        super(10, 50, "tweakerplus", null, "tweakerplus.gui.title", new Object[]{TweakerPlusMod.VERSION});
        currentInstance = this;
    }

    public void removed() {
        super.removed();
        currentInstance = null;
    }

    public static Optional<TweakerPlusConfigGui> getCurrentInstance() {
        return Optional.ofNullable(currentInstance);
    }

    public static boolean onOpenGuiHotkey(KeyAction keyAction, IKeybind iKeybind) {
        GuiBase.openGui((class_437)new TweakerPlusConfigGui());
        return true;
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (Config.Category category : Config.Category.values()) {
            x += this.createNavigationButton(x, y, category);
        }
        Set possibleTypes = TweakerPlusConfigs.getOptions(category).stream().map(TweakerPlusOption::getType).collect(Collectors.toSet());
        List items = Arrays.stream(Config.Type.values()).filter(possibleTypes::contains).collect(Collectors.toList());
        items.add(0, null);
        SelectorDropDownList dd = new SelectorDropDownList(this.width - 91, this.getListY() + 3, 80, 16, 200, items.size(), items);
        dd.setEntryChangeListener(type -> {
            if (type != this.filteredType) {
                this.filteredType = type;
                this.reDraw();
            }
        });
        this.addWidget((WidgetBase)dd);
        this.typeFilterDropDownList = dd;
        dd.setSelectedEntry(this.filteredType);
        String labelTextKey = "tweakerplus.gui.config_type.label_text";
        int labelWidth = this.getStringWidth(StringUtils.translate((String)labelTextKey, (Object[])new Object[0]));
        WidgetLabel label = new WidgetLabel(dd.getX() - labelWidth - 5, dd.getY() + 1, labelWidth, dd.getHeight(), -2039584, new String[]{labelTextKey});
        this.addWidget((WidgetBase)label);
    }

    private int createNavigationButton(int x, int y, Config.Category category) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, category.getDisplayName(), new String[0]);
        button.setEnabled(TweakerPlusConfigGui.category != category);
        this.addButton((ButtonBase)button, (b, mouseButton) -> {
            TweakerPlusConfigGui.category = category;
            this.reDraw();
        });
        return button.getWidth() + 2;
    }

    public void reDraw() {
        this.reCreateListWidget();
        Objects.requireNonNull((WidgetListConfigOptions)this.getListWidget()).resetScrollbarPosition();
        this.initGui();
    }

    public void renderDropDownList(int mouseX, int mouseY) {
        if (this.typeFilterDropDownList != null) {
            this.typeFilterDropDownList.render(mouseX, mouseY, this.typeFilterDropDownList.isMouseOver(mouseX, mouseY));
        }
    }

    public Pair<Integer, Integer> adjustWidths(int guiWidth, int maxTextWidth) {
        int panelWidth = 190;
        int labelWidth = class_3532.method_15340((int)((guiWidth -= 75) - panelWidth), (int)(maxTextWidth - 5), (int)(maxTextWidth + 100));
        panelWidth = class_3532.method_15340((int)(guiWidth - labelWidth), (int)100, (int)panelWidth);
        labelWidth = class_3532.method_15340((int)(guiWidth - panelWidth + 25), (int)(labelWidth - Math.max((int)((double)maxTextWidth * 0.4), 30)), (int)labelWidth);
        labelWidth = Math.max(labelWidth, 0);
        panelWidth = Math.max(panelWidth, 0);
        return Pair.of((Object)labelWidth, (Object)panelWidth);
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        ArrayList configs = Lists.newArrayList();
        for (TweakerPlusOption tweakerPlusOption : TweakerPlusConfigs.getOptions(category)) {
            if (this.filteredType != null && tweakerPlusOption.getType() != this.filteredType || TweakerPlusConfigs.HIDE_DISABLE_OPTIONS.getBooleanValue() && !tweakerPlusOption.isEnabled() || !tweakerPlusOption.worksForCurrentMCVersion() && !TweakerPlusConfigs.TWEAKERPLUS_DEBUG_MODE.getBooleanValue() || tweakerPlusOption.isDebug() && !TweakerPlusConfigs.TWEAKERPLUS_DEBUG_MODE.getBooleanValue() || tweakerPlusOption.isDevOnly() && (!TweakerPlusConfigs.TWEAKERPLUS_DEBUG_MODE.getBooleanValue() || !FabricUtil.isDevelopmentEnvironment())) continue;
            configs.add(tweakerPlusOption.getConfig());
        }
        configs.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        return GuiConfigsBase.ConfigOptionWrapper.createFor((Collection)configs);
    }
}

