/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client;

import com.etka.nomadsshell.client.armor.ShellArmorLayer;
import com.etka.nomadsshell.client.screen.AdminConfigScreen;
import com.etka.nomadsshell.client.screen.ShellScreen;
import com.etka.nomadsshell.client.screen.VirtualShellScreen;
import com.etka.nomadsshell.init.ModKeyBindings;
import com.etka.nomadsshell.init.ModMenuTypes;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.network.OpenShellPacket;
import com.etka.nomadsshell.network.QuickStoreToShellPacket;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="nomadsshell", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.shell_MENU.get(), ShellScreen::new);
        event.register(ModMenuTypes.VIRTUAL_shell_MENU.get(), VirtualShellScreen::new);
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ModKeyBindings.OPEN_shell);
        event.register(ModKeyBindings.INCREASE_HEIGHT);
        event.register(ModKeyBindings.DECREASE_HEIGHT);
        event.register(ModKeyBindings.INCREASE_WIDTH);
        event.register(ModKeyBindings.DECREASE_WIDTH);
        event.register(ModKeyBindings.ADMIN_CONFIG);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        Set playerSkins = event.getSkins();
        for (PlayerSkin.Model skin : playerSkins) {
            EntityRenderer renderer = event.getSkin(skin);
            if (!(renderer instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.addLayer(new ShellArmorLayer(playerRenderer));
        }
        ClientEventHandler.addLayerToRenderer(event.getRenderer(EntityType.ARMOR_STAND));
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addLayerToRenderer(EntityRenderer<? extends T> renderer) {
        LivingEntityRenderer livingRenderer;
        if (renderer instanceof LivingEntityRenderer && (livingRenderer = (LivingEntityRenderer)renderer).getModel() instanceof HumanoidModel) {
            livingRenderer.addLayer(new ShellArmorLayer(livingRenderer));
        }
    }

    @EventBusSubscriber(modid="nomadsshell", value={Dist.CLIENT})
    public static class ForgeEventHandler {
        private static boolean suppressNextRightRelease = false;

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.screen == null) {
                ItemStack shell;
                if (ModKeyBindings.OPEN_shell.consumeClick() && !(shell = ShellItem.findWornshell((Player)mc.player)).isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new OpenShellPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (ModKeyBindings.ADMIN_CONFIG.consumeClick() && mc.player.hasPermissions(2)) {
                    mc.setScreen((Screen)new AdminConfigScreen());
                }
            }
        }

        @SubscribeEvent
        public static void onMouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
            if (event.getButton() != 1) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack carried = mc.player.containerMenu.getCarried();
            if (carried.isEmpty() || !(carried.getItem() instanceof ShellItem)) {
                return;
            }
            Screen screen = event.getScreen();
            if (!(screen instanceof AbstractContainerScreen)) {
                return;
            }
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            Slot hoveredSlot = containerScreen.getSlotUnderMouse();
            if (hoveredSlot == null || !hoveredSlot.hasItem()) {
                return;
            }
            if (hoveredSlot.getItem().getItem() instanceof ShellItem) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new QuickStoreToShellPacket(hoveredSlot.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
            mc.player.containerMenu.setCarried(carried);
            suppressNextRightRelease = true;
        }

        @SubscribeEvent
        public static void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
            if (event.getButton() != 1) {
                return;
            }
            if (!suppressNextRightRelease) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                suppressNextRightRelease = false;
                return;
            }
            ItemStack carried = mc.player.containerMenu.getCarried();
            if (!carried.isEmpty() && carried.getItem() instanceof ShellItem) {
                event.setCanceled(true);
            }
            suppressNextRightRelease = false;
        }
    }
}

