/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.init.ModFluids;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.DrainTankPacket;
import com.etka.nomadsshell.network.FluidTankInteractionPacket;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.PacketDistributor;

public class FluidTankWidget
extends LockableWidget {
    private static final int TANK_BAR_WIDTH = 14;
    private static final int INTERACTION_BOX_SIZE = 16;
    private static final int MILK_COLOR = -1;
    private static final int POWDER_SNOW_COLOR = -1641473;
    private static final int HONEY_COLOR = -2842601;
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int PANEL_GAP = 8;
    private static final int BASE_PANEL_HEIGHT = 45;
    private static final int MIN_PANEL_HEIGHT = 45;
    private static final int MAX_PANEL_HEIGHT = 45;
    private static final int DEFAULT_WIDTH = 180;
    private static final int DEFAULT_HEIGHT = 120;
    private static final int DRAIN_BUTTON_SIZE = 12;
    private int pendingDrainTankIndex = -1;
    private int drainWarningTimer = 0;
    private static final int DRAIN_WARNING_TIMEOUT_TICKS = 60;
    private boolean isExpanded = false;
    private boolean logoMode = false;
    private int currentTankIndex = 1;
    private int previousTankCount = 1;
    private static final int COLLAPSED_WIDTH = 160;
    private static final int COLLAPSED_HEIGHT = 50;
    private static final int COLLAPSED_PANEL_HEIGHT = 35;
    private static final int EXPANDED_WIDTH = 180;
    private static final int EXPANDED_HEIGHT = 120;
    private static final int NAV_BUTTON_SIZE = 8;
    private static final int NAV_BUTTON_SPACING = 2;
    private static final int NAV_OUTER_GAP = 6;

    private static int loadPositionX(int defaultX) {
        int cx = (Integer)OverlayConfig.FLUID_TANK_X.get();
        return cx != 0 ? cx : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int cy = (Integer)OverlayConfig.FLUID_TANK_Y.get();
        return cy != 0 ? cy : defaultY;
    }

    public FluidTankWidget(int x, int y, Font font, IShellMenu menu) {
        super(FluidTankWidget.loadPositionX(x), FluidTankWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.fluid_tank"), font, WidgetUnlockSystem.WidgetType.FLUID_TANK, menu);
        this.canExpand = true;
        this.isExpanded = (Boolean)OverlayConfig.FLUID_TANK_EXPANDED.get();
        if (this.isExpanded) {
            this.width = 180;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player != null) {
                int requiredHeight;
                WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, ShellItem.findWornshell((Player)player));
                int tankCount = switch (tier) {
                    case WidgetUnlockSystem.WidgetTier.TIER_I -> 1;
                    case WidgetUnlockSystem.WidgetTier.TIER_II, WidgetUnlockSystem.WidgetTier.TIER_III -> 2;
                    case WidgetUnlockSystem.WidgetTier.TIER_IV, WidgetUnlockSystem.WidgetTier.TIER_V -> 3;
                    case WidgetUnlockSystem.WidgetTier.TIER_VI, WidgetUnlockSystem.WidgetTier.TIER_VII -> 4;
                    case WidgetUnlockSystem.WidgetTier.TIER_VIII, WidgetUnlockSystem.WidgetTier.TIER_IX, WidgetUnlockSystem.WidgetTier.TIER_X -> 5;
                    default -> 1;
                };
                int panelHeight = this.calculateOptimalPanelHeight(tankCount);
                this.height = requiredHeight = 14 + tankCount * panelHeight + Math.max(0, tankCount - 1) * 8 + 2;
            } else {
                this.height = 120;
            }
        } else {
            this.width = 160;
            this.height = 50;
        }
        this.isPinned = (Boolean)OverlayConfig.FLUID_TANK_PINNED.get();
    }

    private int calculateOptimalPanelHeight(int tankCount) {
        if (tankCount == 1) {
            return 45;
        }
        if (tankCount == 2) {
            return 45;
        }
        if (tankCount <= 4) {
            return Math.min(49, 45);
        }
        return 45;
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        try {
            OverlayConfig.FLUID_TANK_PINNED.set((Object)this.isPinned);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void toggleExpansion() {
        boolean bl = this.isExpanded = !this.isExpanded;
        if (this.isExpanded) {
            this.width = 180;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player != null) {
                int requiredHeight;
                WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, ShellItem.findWornshell((Player)player));
                int tankCount = switch (tier) {
                    case WidgetUnlockSystem.WidgetTier.TIER_I -> 1;
                    case WidgetUnlockSystem.WidgetTier.TIER_II, WidgetUnlockSystem.WidgetTier.TIER_III -> 2;
                    case WidgetUnlockSystem.WidgetTier.TIER_IV, WidgetUnlockSystem.WidgetTier.TIER_V -> 3;
                    case WidgetUnlockSystem.WidgetTier.TIER_VI, WidgetUnlockSystem.WidgetTier.TIER_VII -> 4;
                    case WidgetUnlockSystem.WidgetTier.TIER_VIII, WidgetUnlockSystem.WidgetTier.TIER_IX, WidgetUnlockSystem.WidgetTier.TIER_X -> 5;
                    default -> 1;
                };
                int panelHeight = this.calculateOptimalPanelHeight(tankCount);
                this.height = requiredHeight = 14 + tankCount * panelHeight + Math.max(0, tankCount - 1) * 8 + 2;
            } else {
                this.height = 120;
            }
        } else {
            this.width = 160;
            this.height = 50;
        }
        try {
            OverlayConfig.FLUID_TANK_EXPANDED.set((Object)this.isExpanded);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.FLUID_TANK_X.set((Object)this.getX());
            OverlayConfig.FLUID_TANK_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected String getContextMenuLabel() {
        boolean imageEnabled = (Boolean)OverlayConfig.FLUID_TANK_USE_IMAGE_MODE.get();
        return imageEnabled ? Component.translatable((String)"nomadsshell.ui.reset_position_disable").getString() : Component.translatable((String)"nomadsshell.ui.reset_position_enable").getString();
    }

    @Override
    protected void handleContextMenuAction(int index) {
        if (index == 0) {
            this.resetPosition();
        } else if (index == 1) {
            boolean imageEnabled = (Boolean)OverlayConfig.FLUID_TANK_USE_IMAGE_MODE.get();
            OverlayConfig.FLUID_TANK_USE_IMAGE_MODE.set((Object)(!imageEnabled ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        boolean hoveredWidget;
        boolean titleBarHovered;
        int panelHeight;
        int requiredHeight;
        int tankCount;
        if (!this.isUnlocked()) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, ShellItem.findWornshell((Player)player));
        switch (tier) {
            case TIER_I: {
                int n = 1;
                break;
            }
            case TIER_II: 
            case TIER_III: {
                int n = 2;
                break;
            }
            case TIER_IV: 
            case TIER_V: {
                int n = 3;
                break;
            }
            case TIER_VI: 
            case TIER_VII: {
                int n = 4;
                break;
            }
            case TIER_VIII: 
            case TIER_IX: 
            case TIER_X: {
                int n = 5;
                break;
            }
            default: {
                int n = tankCount = 1;
            }
        }
        if (this.isExpanded && (this.height != (requiredHeight = 14 + tankCount * (panelHeight = this.calculateOptimalPanelHeight(tankCount)) + Math.max(0, tankCount - 1) * 8 + 2) || tankCount != this.previousTankCount)) {
            this.height = requiredHeight;
            if (this.currentTankIndex > tankCount) {
                this.currentTankIndex = tankCount;
            }
        }
        this.previousTankCount = tankCount;
        boolean imageEnabled = (Boolean)OverlayConfig.FLUID_TANK_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FLUID_TANK);
        int currentWidth = this.width;
        int currentHeight = this.height;
        g.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        g.fill(x, y + 12 - 1, x + currentWidth, y + 12, Theme.titleBarBorder());
        boolean bl = titleBarHovered = mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging()) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            g.fill(x, y, x + currentWidth, y + 12, hoverOverlay);
        }
        this.drawControlButtons(g, x, y, currentWidth, mouseX, mouseY);
        boolean bl2 = hoveredWidget = mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + currentHeight;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, y + 12, currentWidth, currentHeight - 12);
            return;
        }
        if (this.isExpanded) {
            this.drawExpandedInterface(g, x, y + 12, tankCount, mouseX, mouseY);
        } else {
            this.drawCollapsedInterface(g, x, y + 12, tankCount, mouseX, mouseY);
        }
        if (this.pendingDrainTankIndex >= 0) {
            String msg = "Really drain tank? Click drain button again to confirm, or click title to cancel";
            PoseStack pose = g.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 400.0f);
            pose.scale(0.8f, 0.8f, 1.0f);
            int msgW = (int)((float)this.font.width(msg) * 0.8f);
            int msgX = x + (currentWidth - msgW) / 2;
            int msgY = y + currentHeight - 15;
            g.fill(msgX - 2, msgY - 2, msgX + msgW + 2, msgY + 10, Theme.overlayDim());
            g.renderOutline(msgX - 2, msgY - 2, msgW + 4, 12, -39322);
            g.drawString(this.font, msg, msgX, msgY, -1, false);
            pose.popPose();
        }
    }

    private void drawCollapsedInterface(GuiGraphics g, int x, int y, int tankCount, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        g.fill(x, y, x + 160, y + 50 - 12, Theme.panelBg());
        if (this.currentTankIndex > tankCount) {
            this.currentTankIndex = tankCount;
        }
        if (this.currentTankIndex < 1) {
            this.currentTankIndex = 1;
        }
        int panelHeight = 35;
        int tankPanelWidth = 138;
        this.drawCollapsedPanel(g, this.currentTankIndex, x + 2, y + 2, tankPanelWidth, panelHeight, mouseX, mouseY);
        if (tankCount > 1) {
            this.drawVerticalNavigationArrows(g, x + tankPanelWidth + 4, y, tankCount, mouseX, mouseY);
        }
    }

    private void drawExpandedInterface(GuiGraphics g, int x, int y, int tankCount, int mouseX, int mouseY) {
        int panelHeight = this.calculateOptimalPanelHeight(tankCount);
        int requiredHeight = 2 + tankCount * panelHeight + Math.max(0, tankCount - 1) * 8 + 2;
        int contentHeight = Math.max(108, requiredHeight);
        int actualContentHeight = this.height - 12;
        g.fill(x, y, x + 180, y + actualContentHeight, Theme.panelBg());
        for (int i = 1; i <= tankCount; ++i) {
            int panelY = y + 2 + (i - 1) * (panelHeight + 8);
            this.drawPanel(g, i, x + 4, panelY, 172, panelHeight, mouseX, mouseY);
        }
    }

    private void drawVerticalNavigationArrows(GuiGraphics g, int navX, int y, int tankCount, int mouseX, int mouseY) {
        int upArrowY = y + 4;
        boolean upHovered = mouseX >= navX && mouseX <= navX + 8 && mouseY >= upArrowY && mouseY <= upArrowY + 8;
        int upColor = upHovered ? Theme.slotHoverFill() : Theme.slotFill();
        g.fill(navX, upArrowY, navX + 8, upArrowY + 8, upColor);
        g.renderOutline(navX, upArrowY, 8, 8, Theme.slotBorder());
        int upIconX = navX + 4;
        int upIconY = upArrowY + 2;
        g.fill(upIconX - 2, upIconY + 3, upIconX + 3, upIconY + 3, Theme.textOnPanel());
        g.fill(upIconX - 1, upIconY + 2, upIconX + 2, upIconY + 2, Theme.textOnPanel());
        g.fill(upIconX, upIconY + 1, upIconX + 1, upIconY + 1, Theme.textOnPanel());
        int downArrowY = y + 35 - 8 - 4;
        boolean downHovered = mouseX >= navX && mouseX <= navX + 8 && mouseY >= downArrowY && mouseY <= downArrowY + 8;
        int downColor = downHovered ? Theme.slotHoverFill() : Theme.slotFill();
        g.fill(navX, downArrowY, navX + 8, downArrowY + 8, downColor);
        g.renderOutline(navX, downArrowY, 8, 8, Theme.slotBorder());
        int downIconX = navX + 4;
        int downIconY = downArrowY + 2;
        g.fill(downIconX - 2, downIconY + 1, downIconX + 3, downIconY + 1, Theme.textOnPanel());
        g.fill(downIconX - 1, downIconY + 2, downIconX + 2, downIconY + 2, Theme.textOnPanel());
        g.fill(downIconX, downIconY + 3, downIconX + 1, downIconY + 3, Theme.textOnPanel());
        if (tankCount > 1) {
            String tankNumber = String.valueOf(this.currentTankIndex);
            int numberX = navX + (8 - this.font.width(tankNumber)) / 2;
            int numberY = (upArrowY + 8 + downArrowY) / 2 - 3;
            g.drawString(this.font, tankNumber, numberX, numberY, Theme.textOnPanel());
        }
        if (upHovered && this.currentTankIndex > 1) {
            g.fill(mouseX + 6, mouseY - 10, mouseX + 6 + this.font.width("Previous tank"), mouseY + 2, Theme.overlayDim());
            g.drawString(this.font, "Previous tank", mouseX + 6, mouseY - 8, -1, false);
        }
        if (downHovered && this.currentTankIndex < tankCount) {
            g.fill(mouseX + 6, mouseY - 10, mouseX + 6 + this.font.width("Next tank"), mouseY + 2, Theme.overlayDim());
            g.drawString(this.font, "Next tank", mouseX + 6, mouseY - 8, -1, false);
        }
    }

    private void drawCollapsedPanel(GuiGraphics g, int tankIndex, int x, int y, int w, int h, int mouseX, int mouseY) {
        Object title;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        g.fill(x, y, x + w, y + h, Theme.panelBg());
        g.renderOutline(x, y, w, h, Theme.panelBorder());
        int cap = WidgetDataHelper.getTankCapacity((Player)player, tankIndex);
        FluidStackData fs = WidgetDataHelper.getTankFluid((Player)player, tankIndex);
        int amt = fs.amount();
        int barX = x + 2;
        int barY = y + 2;
        int barW = 14;
        int barH = h - 4;
        g.fill(barX, barY, barX + barW, barY + barH, Theme.slotFill());
        g.renderOutline(barX, barY, barW, barH, Theme.slotBorder());
        if (!fs.isEmpty() && cap > 0 && amt > 0) {
            double fillRatio = (double)amt / (double)cap;
            int minFillHeight = Math.max(2, barH / 8);
            int maxFillHeight = barH - 2;
            int fill = Math.max(minFillHeight, (int)Math.round(fillRatio * (double)maxFillHeight));
            fill = Math.min(fill, maxFillHeight);
            int by = barY + barH - 1 - fill;
            int fluidColor = this.getFluidColor(fs);
            g.fill(barX + 1, by, barX + barW - 1, barY + barH - 1, fluidColor);
        }
        if (fs.isEmpty()) {
            title = Component.translatable((String)"nomadsshell.ui.empty").getString();
        } else {
            FluidStack display = new FluidStack(fs.fluid(), Math.min(amt, 1000));
            if (display.getFluid() == ModFluids.POTION.get()) {
                PotionContents contents = WidgetDataHelper.getTankPotionContents((Player)player, tankIndex);
                ItemStack nameStack = new ItemStack((ItemLike)Items.POTION);
                if (contents != null && contents != PotionContents.EMPTY) {
                    nameStack.set(DataComponents.POTION_CONTENTS, (Object)contents);
                }
                title = amt + " mB of " + nameStack.getHoverName().getString();
            } else {
                title = amt + " mB of " + display.getHoverName().getString();
            }
        }
        int availableWidth = w - barW - 8;
        this.drawWrappedText(g, (String)title, barX + barW + 6, y + 4, Theme.textOnPanel(), availableWidth);
        if (!fs.isEmpty()) {
            int drainButtonX = x + w - 12 - 2;
            int drainButtonY = y + 2;
            boolean overDrainButton = FluidTankWidget.isPointIn(drainButtonX, drainButtonY, 12, 12, mouseX, mouseY);
            int drainButtonFill = overDrainButton ? Theme.slotHoverFill() : Theme.slotFill();
            g.fill(drainButtonX, drainButtonY, drainButtonX + 12, drainButtonY + 12, drainButtonFill);
            g.renderOutline(drainButtonX, drainButtonY, 12, 12, Theme.slotBorder());
            int centerX = drainButtonX + 6;
            int centerY = drainButtonY + 6;
            int iconColor = Theme.textOnPanel();
            g.fill(centerX - 3, centerY - 1, centerX + 4, centerY + 1, iconColor);
            g.fill(centerX - 1, centerY - 3, centerX + 1, centerY + 4, iconColor);
            g.fill(centerX - 2, centerY - 2, centerX + 3, centerY - 1, iconColor);
            g.fill(centerX - 2, centerY + 2, centerX + 3, centerY + 3, iconColor);
            g.fill(centerX - 3, centerY + 1, centerX - 2, centerY + 2, iconColor);
            g.fill(centerX + 2, centerY - 2, centerX + 3, centerY - 1, iconColor);
        }
        if (tankIndex > 1) {
            boolean tankUnlocked;
            WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, ShellItem.findWornshell((Player)player));
            switch (tier) {
                case TIER_I: {
                    boolean bl;
                    if (tankIndex == 1) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_II: 
                case TIER_III: {
                    boolean bl;
                    if (tankIndex <= 2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_IV: 
                case TIER_V: {
                    boolean bl;
                    if (tankIndex <= 3) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_VI: 
                case TIER_VII: {
                    boolean bl;
                    if (tankIndex <= 4) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_VIII: 
                case TIER_IX: 
                case TIER_X: {
                    boolean bl;
                    if (tankIndex <= 5) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = tankUnlocked = tankIndex == 1;
                }
            }
            if (!tankUnlocked) {
                g.fill(x, y, x + w, y + h, Theme.overlayDim());
                String unlockMessage = switch (tier) {
                    case WidgetUnlockSystem.WidgetTier.TIER_I -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier2").getString();
                    case WidgetUnlockSystem.WidgetTier.TIER_II, WidgetUnlockSystem.WidgetTier.TIER_III -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier4").getString();
                    case WidgetUnlockSystem.WidgetTier.TIER_IV, WidgetUnlockSystem.WidgetTier.TIER_V -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier6").getString();
                    case WidgetUnlockSystem.WidgetTier.TIER_VI, WidgetUnlockSystem.WidgetTier.TIER_VII -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier8").getString();
                    default -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_upgrades").getString();
                };
                g.drawString(this.font, unlockMessage, x + 10, y + h / 2 - 4, Theme.textOnPanel());
            }
        }
        if (FluidTankWidget.isPointIn(barX, barY, barW, barH, mouseX, mouseY)) {
            ItemStack cursorItem = mc.player != null ? mc.player.containerMenu.getCarried() : ItemStack.EMPTY;
            String text = this.getTooltipText(cursorItem, fs);
            g.fill(mouseX + 6, mouseY - 10, mouseX + 6 + this.font.width(text), mouseY + 2, Theme.overlayDim());
            g.drawString(this.font, text, mouseX + 6, mouseY - 8, -1, false);
        }
    }

    private void renderLogoIcon(GuiGraphics g, int x, int y, int width, int height) {
        try {
            ResourceLocation cauldronIcon = Theme.icon("cauldron");
            int iconX = x + (width - 32) / 2;
            int iconY = y + (height - 32) / 2;
            g.blit(cauldronIcon, iconX, iconY, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        catch (Throwable t) {
            int centerX = x + width / 2;
            int centerY = y + height / 2;
            int cauldronColor = -7650029;
            g.fill(centerX - 12, centerY - 8, centerX + 12, centerY + 8, cauldronColor);
            g.fill(centerX - 14, centerY - 10, centerX + 14, centerY - 8, cauldronColor);
            g.fill(centerX - 14, centerY + 8, centerX + 14, centerY + 10, cauldronColor);
            g.fill(centerX - 10, centerY + 10, centerX - 8, centerY + 14, cauldronColor);
            g.fill(centerX + 8, centerY + 10, centerX + 10, centerY + 14, cauldronColor);
        }
    }

    private void drawControlButtons(GuiGraphics g, int x, int y, int width, int mouseX, int mouseY) {
        int pinX = x + width - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        g.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            g.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, -1);
            g.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, -1);
        } else {
            g.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, -5592406);
            g.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, -5592406);
            g.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, -5592406);
            g.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, -5592406);
        }
        int expandX = x + width - 8 - 2 - 8 - 2;
        int expandY = y + 2;
        boolean expandHovered = mouseX >= expandX && mouseX <= expandX + 8 && mouseY >= expandY && mouseY <= expandY + 8;
        g.fill(expandX, expandY, expandX + 8, expandY + 8, Theme.buttonBg(expandHovered));
        g.pose().pushPose();
        g.pose().translate((float)expandX, (float)expandY, 0.0f);
        g.pose().scale(0.5f, 0.5f, 1.0f);
        try {
            ResourceLocation icon = Theme.icon(this.isExpanded ? "collapse" : "expand");
            g.blit(icon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Throwable t) {
            if (this.isExpanded) {
                g.fill(expandX + 2, expandY + 2, expandX + 6, expandY + 2, -1);
                g.fill(expandX + 3, expandY + 1, expandX + 5, expandY + 1, -1);
                g.fill(expandX + 4, expandY, expandX + 4, expandY, -1);
            }
            g.fill(expandX + 2, expandY + 5, expandX + 6, expandY + 5, -1);
            g.fill(expandX + 3, expandY + 6, expandX + 5, expandY + 6, -1);
            g.fill(expandX + 4, expandY + 7, expandX + 4, expandY + 7, -1);
        }
        g.pose().popPose();
    }

    private void drawPanel(GuiGraphics g, int tankIndex, int x, int y, int w, int h, int mouseX, int mouseY) {
        Object title;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        g.fill(x, y, x + w, y + h, Theme.panelBg());
        g.renderOutline(x, y, w, h, Theme.panelBorder());
        if (player == null) {
            return;
        }
        int barX = x + 2;
        int barY = y + 2;
        int barW = 14;
        int barH = h - 4;
        g.fill(barX, barY, barX + barW, barY + barH, Theme.slotFill());
        g.renderOutline(barX, barY, barW, barH, Theme.slotBorder());
        boolean tank2Locked = tankIndex == 2 && !WidgetDataHelper.isTank2Unlocked((Player)player);
        int cap = WidgetDataHelper.getTankCapacity((Player)player, tankIndex);
        FluidStackData fs = WidgetDataHelper.getTankFluid((Player)player, tankIndex);
        int amt = fs.amount();
        if (!fs.isEmpty() && cap > 0 && amt > 0) {
            double fillRatio = (double)amt / (double)cap;
            int minFillHeight = Math.max(2, barH / 8);
            int maxFillHeight = barH - 2;
            int fill = Math.max(minFillHeight, (int)Math.round(fillRatio * (double)maxFillHeight));
            fill = Math.min(fill, maxFillHeight);
            int by = barY + barH - 1 - fill;
            int fluidColor = this.getFluidColor(fs);
            g.fill(barX + 1, by, barX + barW - 1, barY + barH - 1, fluidColor);
        }
        if (fs.isEmpty()) {
            title = Component.translatable((String)"nomadsshell.ui.empty").getString();
        } else {
            FluidStack display = new FluidStack(fs.fluid(), Math.min(amt, 1000));
            if (display.getFluid() == ModFluids.POTION.get()) {
                PotionContents contents = WidgetDataHelper.getTankPotionContents((Player)player, tankIndex);
                ItemStack nameStack = new ItemStack((ItemLike)Items.POTION);
                if (contents != null && contents != PotionContents.EMPTY) {
                    nameStack.set(DataComponents.POTION_CONTENTS, (Object)contents);
                }
                String potionName = nameStack.getHoverName().getString();
                title = amt + " mB of " + potionName;
            } else {
                title = amt + " mB of " + display.getHoverName().getString();
            }
        }
        int availableWidth = w - barW - 10;
        this.drawWrappedText(g, (String)title, barX + barW + 8, y + 4, Theme.textOnPanel(), availableWidth);
        int boxX = barX + barW + 8;
        int boxY = y + 16;
        ItemStack cursorItem = mc.player != null ? mc.player.containerMenu.getCarried() : ItemStack.EMPTY;
        String actionText = this.getActionText(cursorItem, fs);
        int actionColor = this.getActionColor(cursorItem, fs, tankIndex);
        g.drawString(this.font, actionText, boxX + 16 + 6, boxY + 12 + 4 - 2, actionColor);
        boolean overBox = FluidTankWidget.isPointIn(boxX, boxY + 12, 16, 16, mouseX, mouseY);
        int boxFill = overBox ? Theme.slotHoverFill() : Theme.slotFill();
        g.fill(boxX, boxY + 12, boxX + 16, boxY + 12 + 16, boxFill);
        g.renderOutline(boxX, boxY + 12, 16, 16, Theme.slotBorder());
        if (!fs.isEmpty()) {
            int drainButtonX = x + w - 12 - 2;
            int drainButtonY = y + 2;
            boolean overDrainButton = FluidTankWidget.isPointIn(drainButtonX, drainButtonY, 12, 12, mouseX, mouseY);
            int drainButtonFill = overDrainButton ? Theme.slotHoverFill() : Theme.slotFill();
            g.fill(drainButtonX, drainButtonY, drainButtonX + 12, drainButtonY + 12, drainButtonFill);
            g.renderOutline(drainButtonX, drainButtonY, 12, 12, Theme.slotBorder());
            int centerX = drainButtonX + 6;
            int centerY = drainButtonY + 6;
            int iconColor = Theme.textOnPanel();
            g.fill(centerX - 3, centerY - 1, centerX + 4, centerY + 1, iconColor);
            g.fill(centerX - 1, centerY - 3, centerX + 1, centerY + 4, iconColor);
            g.fill(centerX - 2, centerY - 2, centerX + 3, centerY - 1, iconColor);
            g.fill(centerX - 2, centerY + 2, centerX + 3, centerY + 3, iconColor);
            g.fill(centerX - 3, centerY + 1, centerX - 2, centerY + 2, iconColor);
            g.fill(centerX + 2, centerY - 2, centerX + 3, centerY - 1, iconColor);
            if (overDrainButton) {
                String drainTooltip = Component.translatable((String)"nomadsshell.fluid.tooltip.drain_liquid").getString();
                this.drawWrappedTooltip(g, drainTooltip, mouseX, mouseY);
            }
        }
        if (tankIndex > 1) {
            boolean tankUnlocked;
            WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, ShellItem.findWornshell((Player)player));
            switch (tier) {
                case TIER_I: {
                    boolean bl;
                    if (tankIndex == 1) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_II: 
                case TIER_III: {
                    boolean bl;
                    if (tankIndex <= 2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_IV: 
                case TIER_V: {
                    boolean bl;
                    if (tankIndex <= 3) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_VI: 
                case TIER_VII: {
                    boolean bl;
                    if (tankIndex <= 4) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case TIER_VIII: 
                case TIER_IX: 
                case TIER_X: {
                    boolean bl;
                    if (tankIndex <= 5) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = tankUnlocked = tankIndex == 1;
                }
            }
            if (!tankUnlocked) {
                g.fill(x, y, x + w, y + h, Theme.overlayDim());
                String unlockMessage = switch (tier) {
                    case WidgetUnlockSystem.WidgetTier.TIER_I -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier2").getString();
                    case WidgetUnlockSystem.WidgetTier.TIER_II, WidgetUnlockSystem.WidgetTier.TIER_III -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier4").getString();
                    case WidgetUnlockSystem.WidgetTier.TIER_IV, WidgetUnlockSystem.WidgetTier.TIER_V -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier6").getString();
                    case WidgetUnlockSystem.WidgetTier.TIER_VI, WidgetUnlockSystem.WidgetTier.TIER_VII -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_tier8").getString();
                    default -> Component.translatable((String)"nomadsshell.fluid_tank.unlock_upgrades").getString();
                };
                g.drawString(this.font, unlockMessage, x + 10, y + h / 2 - 4, Theme.textOnPanel());
            }
        }
        if (FluidTankWidget.isPointIn(barX, barY, barW, barH, mouseX, mouseY)) {
            Object text = fs.isEmpty() ? Component.translatable((String)"nomadsshell.ui.empty").getString() : amt + "/" + cap + " mB";
            int tx = mouseX + 6;
            int ty = mouseY - 10;
            g.fill(tx - 2, ty - 2, tx + this.font.width((String)text) + 2, ty + 10, Theme.overlayDim());
            g.drawString(this.font, (String)text, tx, ty, -1, false);
        }
        if (overBox) {
            String tooltip = this.getTooltipText(cursorItem, fs);
            this.drawWrappedTooltip(g, tooltip, mouseX, mouseY);
        }
    }

    private String getActionText(ItemStack cursorItem, FluidStackData tankFluid) {
        if (cursorItem.isEmpty()) {
            String fluidPath;
            if (!tankFluid.isEmpty() && ((fluidPath = tankFluid.fluid().builtInRegistryHolder().key().location().getPath()).contains("honey") || fluidPath.contains("potion"))) {
                return Component.translatable((String)"nomadsshell.fluid.action.need_bottle").getString();
            }
            return Component.translatable((String)"nomadsshell.fluid.action.need_bucket").getString();
        }
        if (this.isLiquidLikeBucket(cursorItem)) {
            return Component.translatable((String)"nomadsshell.fluid.action.put_liquid").getString();
        }
        if (!tankFluid.isEmpty()) {
            String fluidPath = tankFluid.fluid().builtInRegistryHolder().key().location().getPath();
            if (fluidPath.contains("honey")) {
                return Component.translatable((String)"nomadsshell.fluid.action.take_honey").getString();
            }
            if (fluidPath.contains("potion")) {
                return Component.translatable((String)"nomadsshell.fluid.action.take_potion").getString();
            }
        }
        return Component.translatable((String)"nomadsshell.fluid.action.take_liquid").getString();
    }

    private int getActionColor(ItemStack cursorItem, FluidStackData tankFluid, int tankIndex) {
        if (cursorItem.isEmpty()) {
            return Theme.textOnPanel();
        }
        if (this.isLiquidLikeBucket(cursorItem)) {
            boolean isPotion;
            Optional opt = FluidUtil.getFluidContained((ItemStack)cursorItem);
            if (opt.isPresent()) {
                FluidStack fs = opt.orElse(null);
                if (fs != null && (tankFluid.isEmpty() || fs.getFluid() == tankFluid.fluid())) {
                    return -11751600;
                }
                return -769226;
            }
            boolean isMilk = cursorItem.getItem() == Items.MILK_BUCKET;
            boolean isPowderSnow = cursorItem.getItem() == Items.POWDER_SNOW_BUCKET;
            boolean isHoney = cursorItem.getItem() == Items.HONEY_BOTTLE;
            boolean bl = isPotion = cursorItem.getItem() == Items.POTION;
            if (isMilk || isPowderSnow || isHoney || isPotion) {
                boolean tankIsPotion = tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("potion");
                boolean tankIsWater = FluidTankWidget.isWaterRelatedFluid(tankFluid);
                if (isPotion) {
                    boolean isWaterPotion;
                    PotionContents carriedContents = (PotionContents)cursorItem.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                    boolean bl2 = isWaterPotion = carriedContents.equals((Object)PotionContents.EMPTY) || carriedContents.potion().isPresent() && carriedContents.potion().get() == Potions.WATER;
                    if (isWaterPotion) {
                        return tankFluid.isEmpty() || tankIsWater ? -11751600 : -769226;
                    }
                    if (tankFluid.isEmpty()) {
                        return -11751600;
                    }
                    if (!tankIsPotion) {
                        return -769226;
                    }
                    PotionContents storedContents = WidgetDataHelper.getTankPotionContents((Player)Minecraft.getInstance().player, tankIndex);
                    return storedContents.equals((Object)carriedContents) ? -11751600 : -769226;
                }
                boolean tankEmptyOrCompatible = tankFluid.isEmpty() || isMilk && tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("milk") || isPowderSnow && tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("powder_snow") || isHoney && tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("honey");
                return tankEmptyOrCompatible ? -11751600 : -769226;
            }
            if (cursorItem.getItem() == Items.WATER_BUCKET) {
                boolean tankIsWater = FluidTankWidget.isWaterRelatedFluid(tankFluid);
                return tankFluid.isEmpty() || tankIsWater ? -11751600 : -769226;
            }
            return tankFluid.isEmpty() ? -11751600 : -769226;
        }
        if (!tankFluid.isEmpty()) {
            if (cursorItem.getItem() == Items.OMINOUS_BOTTLE) {
                return Theme.textOnPanel();
            }
            return -14575885;
        }
        return Theme.textOnPanel();
    }

    private String getTooltipText(ItemStack cursorItem, FluidStackData tankFluid) {
        if (cursorItem.isEmpty()) {
            return Component.translatable((String)"nomadsshell.fluid.tooltip.need_container").getString();
        }
        if (cursorItem.getItem() == Items.OMINOUS_BOTTLE) {
            if (tankFluid.isEmpty()) {
                return Component.translatable((String)"nomadsshell.fluid.tooltip.cannot_fill_ominous").getString();
            }
            return Component.translatable((String)"nomadsshell.fluid.tooltip.cannot_fill_ominous_from_tank").getString();
        }
        if (this.isLiquidLikeBucket(cursorItem)) {
            boolean isWaterBucket;
            FluidStack fluidStack;
            Optional opt = FluidUtil.getFluidContained((ItemStack)cursorItem);
            if (opt.isPresent() && (fluidStack = (FluidStack)opt.orElse(null)) != null) {
                if (tankFluid.isEmpty()) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_into_tank", (Object[])new Object[]{fluidStack.getHoverName().getString()}).getString();
                }
                if (fluidStack.getFluid() == tankFluid.fluid()) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_into_tank", (Object[])new Object[]{fluidStack.getHoverName().getString()}).getString();
                }
                return Component.translatable((String)"nomadsshell.fluid.tooltip.cannot_mix_fluids", (Object[])new Object[]{new FluidStack(tankFluid.fluid(), 1).getHoverName().getString()}).getString();
            }
            boolean isMilk = cursorItem.getItem() == Items.MILK_BUCKET;
            boolean isPowderSnow = cursorItem.getItem() == Items.POWDER_SNOW_BUCKET;
            boolean isHoney = cursorItem.getItem() == Items.HONEY_BOTTLE;
            boolean isPotion = cursorItem.getItem() == Items.POTION;
            boolean bl = isWaterBucket = cursorItem.getItem() == Items.WATER_BUCKET;
            if (tankFluid.isEmpty()) {
                if (isMilk) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_milk").getString();
                }
                if (isPowderSnow) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_powder_snow").getString();
                }
                if (isHoney) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_honey").getString();
                }
                if (isPotion) {
                    PotionContents contents = (PotionContents)cursorItem.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                    if (contents.equals((Object)PotionContents.EMPTY) || contents.potion().isPresent() && contents.potion().get() == Potions.WATER) {
                        return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_water").getString();
                    }
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_potion").getString();
                }
                if (isWaterBucket) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_water").getString();
                }
                return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_from_bucket").getString();
            }
            boolean tankIsMilk = tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("milk");
            boolean tankIsPowderSnow = tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("powder_snow");
            boolean tankIsHoney = tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("honey");
            boolean tankIsPotion = tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("potion");
            boolean tankIsWater = FluidTankWidget.isWaterRelatedFluid(tankFluid);
            if (isMilk && tankIsMilk) {
                return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_milk").getString();
            }
            if (isPowderSnow && tankIsPowderSnow) {
                return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_powder_snow").getString();
            }
            if (isHoney && tankIsHoney) {
                return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_honey").getString();
            }
            if (isPotion) {
                boolean isWaterPotion;
                PotionContents contents = (PotionContents)cursorItem.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                boolean bl2 = isWaterPotion = contents.equals((Object)PotionContents.EMPTY) || contents.potion().isPresent() && contents.potion().get() == Potions.WATER;
                if (isWaterPotion && tankIsWater) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_water").getString();
                }
                if (!isWaterPotion && tankIsPotion) {
                    return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_potion").getString();
                }
            }
            if (isWaterBucket && tankIsWater) {
                return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_water").getString();
            }
            if ((isWaterBucket || isPotion && FluidTankWidget.isWaterPotion(cursorItem)) && tankIsWater) {
                return Component.translatable((String)"nomadsshell.fluid.tooltip.pour_water").getString();
            }
            return Component.translatable((String)"nomadsshell.fluid.tooltip.cannot_mix_empty_first").getString();
        }
        if (tankFluid.isEmpty()) {
            return Component.translatable((String)"nomadsshell.fluid.tooltip.tank_empty").getString();
        }
        if (cursorItem.getItem() == Items.GLASS_BOTTLE) {
            FluidStack fluidStack = new FluidStack(tankFluid.fluid(), 1);
            String fluidPath = tankFluid.fluid().builtInRegistryHolder().key().location().getPath();
            if (fluidPath.contains("honey") || fluidPath.contains("potion") || fluidPath.contains("water")) {
                return Component.translatable((String)"nomadsshell.fluid.tooltip.fill_bottle", (Object[])new Object[]{fluidStack.getHoverName().getString()}).getString();
            }
            return Component.translatable((String)"nomadsshell.fluid.tooltip.cannot_fill_bottle", (Object[])new Object[]{fluidStack.getHoverName().getString()}).getString();
        }
        FluidStack fluidStack = new FluidStack(tankFluid.fluid(), 1);
        String fluidPath = tankFluid.fluid().builtInRegistryHolder().key().location().getPath();
        String containerName = fluidPath.contains("honey") || fluidPath.contains("potion") || fluidPath.contains("water") ? "bottle" : "bucket";
        return Component.translatable((String)"nomadsshell.fluid.tooltip.fill_container", (Object[])new Object[]{containerName, fluidStack.getHoverName().getString()}).getString();
    }

    private void drawWrappedTooltip(GuiGraphics g, String text, int mouseX, int mouseY) {
        int maxWidth = 200;
        int padding = 4;
        List lines = this.font.getSplitter().splitLines(text, 200, Style.EMPTY);
        if (lines.isEmpty()) {
            return;
        }
        int maxLineWidth = 0;
        for (FormattedText line : lines) {
            maxLineWidth = Math.max(maxLineWidth, this.font.width(line));
        }
        int tooltipWidth = maxLineWidth + 8;
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int tooltipHeight = n * 9 + 8;
        int tx = mouseX + 6;
        int ty = mouseY - tooltipHeight - 2;
        if (tx + tooltipWidth > g.guiWidth()) {
            tx = mouseX - tooltipWidth - 6;
        }
        if (ty < 0) {
            ty = mouseY + 6;
        }
        g.fill(tx, ty, tx + tooltipWidth, ty + tooltipHeight, Theme.overlayDim());
        int lineY = ty + 4;
        for (FormattedText line : lines) {
            g.drawString(this.font, line.getString(), tx + 4, lineY, -1, false);
            Objects.requireNonNull(this.font);
            lineY += 9;
        }
    }

    private void drawWrappedText(GuiGraphics g, String text, int x, int y, int color, int maxWidth) {
        List lines = this.font.getSplitter().splitLines(text, maxWidth, Style.EMPTY);
        if (lines.isEmpty()) {
            return;
        }
        int lineY = y;
        for (FormattedText line : lines) {
            g.drawString(this.font, line.getString(), x, lineY, color, false);
            Objects.requireNonNull(this.font);
            lineY += 9;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int panelY;
        int tankPanelWidth;
        int tankCount;
        boolean inside;
        if (!this.isUnlocked()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int x = this.getX();
        int y = this.getY();
        int currentWidth = this.width;
        int currentHeight = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FLUID_TANK);
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        x = this.getX();
        y = this.getY();
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, ShellItem.findWornshell((Player)player));
        switch (tier) {
            case TIER_I: {
                int n = 1;
                break;
            }
            case TIER_II: 
            case TIER_III: {
                int n = 2;
                break;
            }
            case TIER_IV: 
            case TIER_V: {
                int n = 3;
                break;
            }
            case TIER_VI: 
            case TIER_VII: {
                int n = 4;
                break;
            }
            case TIER_VIII: 
            case TIER_IX: 
            case TIER_X: {
                int n = 5;
                break;
            }
            default: {
                int n = tankCount = 1;
            }
        }
        if (this.pendingDrainTankIndex >= 0) {
            int drainButtonY;
            int panelW;
            int panelX;
            int drainButtonX;
            FluidStackData fs;
            int panelHeight;
            int tankIndex = this.pendingDrainTankIndex;
            int w = this.width;
            int n = tankPanelWidth = this.isExpanded ? 180 : 132;
            if (FluidTankWidget.isPointIn(x, y, w, 12, (int)mouseX, (int)mouseY)) {
                this.pendingDrainTankIndex = -1;
                return true;
            }
            int contentY = y + 12 + 1;
            int n2 = panelHeight = this.isExpanded ? this.calculateOptimalPanelHeight(tankCount) : 35;
            panelY = this.isExpanded ? contentY + (tankIndex - 1) * (panelHeight + 8) : (tankIndex == this.currentTankIndex ? y + 12 + 2 : -1);
            if (panelY >= 0 && !(fs = WidgetDataHelper.getTankFluid((Player)player, tankIndex)).isEmpty() && FluidTankWidget.isPointIn(drainButtonX = (panelX = x + 4) + (panelW = this.isExpanded ? this.width - 8 : tankPanelWidth) - 12 - 2, drainButtonY = panelY + 2, 12, 12, (int)mouseX, (int)mouseY)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new DrainTankPacket(tankIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.executeDrainClientSide(tankIndex, (Player)player);
                this.pendingDrainTankIndex = -1;
                return true;
            }
            if (FluidTankWidget.isPointIn(x, y + 12, w, this.height - 12, (int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        int expandX = x + this.width - 8 - 2 - 8 - 2;
        int expandY = y + 2;
        if (mouseX >= (double)expandX && mouseX <= (double)(expandX + 8) && mouseY >= (double)expandY && mouseY <= (double)(expandY + 8)) {
            this.toggleExpansion();
            return true;
        }
        if (!this.isExpanded && tankCount > 1) {
            tankPanelWidth = 138;
            int navX = x + tankPanelWidth + 4;
            int contentY = y + 12;
            int upArrowY = contentY + 4;
            if (FluidTankWidget.isPointIn(navX, upArrowY, 8, 8, (int)mouseX, (int)mouseY) && this.currentTankIndex > 1) {
                --this.currentTankIndex;
                return true;
            }
            int downArrowY = contentY + 35 - 8 - 4;
            if (FluidTankWidget.isPointIn(navX, downArrowY, 8, 8, (int)mouseX, (int)mouseY) && this.currentTankIndex < tankCount) {
                ++this.currentTankIndex;
                return true;
            }
        }
        int contentX = x + 4;
        int barX = contentX + 2;
        int barW = 14;
        if (this.isExpanded) {
            int panelHeight = this.calculateOptimalPanelHeight(tankCount);
            int contentY = y + 12 + 1;
            int boxX = barX + barW + 8;
            for (int i = 1; i <= tankCount; ++i) {
                int drainButtonY;
                int drainButtonX;
                int panelY2 = contentY + (i - 1) * (panelHeight + 8);
                if (FluidTankWidget.isPointIn(boxX, panelY2 + 16 + 12, 16, 16, (int)mouseX, (int)mouseY)) {
                    this.handleTankInteraction(i, (Player)player);
                    return true;
                }
                FluidStackData fs = WidgetDataHelper.getTankFluid((Player)player, i);
                if (fs.isEmpty() || !FluidTankWidget.isPointIn(drainButtonX = contentX + (this.width - 8) - 12 - 2, drainButtonY = panelY2 + 2, 12, 12, (int)mouseX, (int)mouseY)) continue;
                this.openConfirmDrain(i);
                return true;
            }
        } else {
            int drainButtonY;
            int drainButtonX;
            panelY = y + 12 + 2;
            int tankPanelWidth2 = 138;
            int collapsedBarX = contentX + 2;
            int collapsedBarY = panelY + 2;
            int collapsedBarW = 14;
            int collapsedBarH = 31;
            if (FluidTankWidget.isPointIn(collapsedBarX, collapsedBarY, collapsedBarW, collapsedBarH, (int)mouseX, (int)mouseY)) {
                this.handleTankInteraction(this.currentTankIndex, (Player)player);
                return true;
            }
            FluidStackData fs = WidgetDataHelper.getTankFluid((Player)player, this.currentTankIndex);
            if (!fs.isEmpty() && FluidTankWidget.isPointIn(drainButtonX = contentX + tankPanelWidth2 - 12 - 2, drainButtonY = panelY + 2, 12, 12, (int)mouseX, (int)mouseY)) {
                this.openConfirmDrain(this.currentTankIndex);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleTankInteraction(int tankIndex, Player player) {
        ItemStack cursorItem = player.containerMenu.getCarried();
        FluidStackData fs = WidgetDataHelper.getTankFluid(player, tankIndex);
        if (cursorItem.isEmpty()) {
            return;
        }
        if (this.isEmptyContainer(cursorItem)) {
            if (fs.isEmpty()) return;
            if (cursorItem.getItem() == Items.OMINOUS_BOTTLE) {
                return;
            }
            if (cursorItem.getItem() == Items.GLASS_BOTTLE && this.isLavaFluid(fs.fluid())) {
                return;
            }
            int requiredAmount = this.getContainerCapacity(cursorItem);
            if (fs.amount() < requiredAmount) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new FluidTankInteractionPacket(tankIndex, FluidTankInteractionPacket.Action.DRAIN_TO_CONTAINER), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.executeFluidInteractionClientSide(tankIndex, FluidTankInteractionPacket.Action.DRAIN_TO_CONTAINER, player);
            return;
        } else {
            if (!this.isLiquidLikeBucket(cursorItem)) return;
            PacketDistributor.sendToServer((CustomPacketPayload)new FluidTankInteractionPacket(tankIndex, FluidTankInteractionPacket.Action.FILL_FROM_CONTAINER), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.executeFluidInteractionClientSide(tankIndex, FluidTankInteractionPacket.Action.FILL_FROM_CONTAINER, player);
        }
    }

    private void executeDrainClientSide(int tankIndex, Player player) {
        ItemStack shellStack = ShellItem.findWornshell(player);
        if (shellStack.isEmpty()) {
            return;
        }
        this.setTankFluidClientSide(shellStack, tankIndex, FluidStackData.EMPTY);
    }

    private void executeFluidInteractionClientSide(int tankIndex, FluidTankInteractionPacket.Action action, Player player) {
        ItemStack shellStack = ShellItem.findWornshell(player);
        if (shellStack.isEmpty()) {
            return;
        }
        ItemStack cursorItem = player.containerMenu.getCarried();
        if (cursorItem.isEmpty()) {
            return;
        }
        FluidStackData currentFluid = WidgetDataHelper.getTankFluid(player, tankIndex);
        int currentCapacity = WidgetDataHelper.getTankCapacity(player, tankIndex);
        if (action == FluidTankInteractionPacket.Action.FILL_FROM_CONTAINER) {
            if (currentFluid.isEmpty() || currentFluid.fluid() == this.getFluidFromContainer(cursorItem)) {
                int fillAmount = this.getContainerFluidAmount(cursorItem);
                int newAmount = Math.min(currentCapacity, currentFluid.amount() + fillAmount);
                FluidStackData newFluid = new FluidStackData(this.getFluidFromContainer(cursorItem), newAmount);
                this.setTankFluidClientSide(shellStack, tankIndex, newFluid);
                if (cursorItem.getItem() == Items.POTION) {
                    if (cursorItem.getCount() > 1) {
                        cursorItem.shrink(1);
                        player.containerMenu.setCarried(cursorItem);
                    } else {
                        player.containerMenu.setCarried(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                    }
                    player.containerMenu.broadcastChanges();
                } else if (cursorItem.getItem() == Items.HONEY_BOTTLE) {
                    if (cursorItem.getCount() > 1) {
                        cursorItem.shrink(1);
                        player.containerMenu.setCarried(cursorItem);
                    } else {
                        player.containerMenu.setCarried(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                    }
                    player.containerMenu.broadcastChanges();
                } else if (cursorItem.getItem() instanceof BucketItem) {
                    if (cursorItem.getCount() > 1) {
                        cursorItem.shrink(1);
                        player.containerMenu.setCarried(cursorItem);
                    } else {
                        player.containerMenu.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                    }
                    player.containerMenu.broadcastChanges();
                }
            }
        } else if (action == FluidTankInteractionPacket.Action.DRAIN_TO_CONTAINER && !currentFluid.isEmpty()) {
            String path;
            Object filled;
            if (cursorItem.getItem() == Items.GLASS_BOTTLE && this.isLavaFluid(currentFluid.fluid())) {
                return;
            }
            int drainAmount = this.getContainerCapacity(cursorItem);
            if (currentFluid.amount() < drainAmount) {
                return;
            }
            int newAmount = Math.max(0, currentFluid.amount() - drainAmount);
            if (newAmount > 0) {
                FluidStackData newFluid = new FluidStackData(currentFluid.fluid(), newAmount);
                this.setTankFluidClientSide(shellStack, tankIndex, newFluid);
            } else {
                this.setTankFluidClientSide(shellStack, tankIndex, FluidStackData.EMPTY);
            }
            if (cursorItem.getItem() == Items.GLASS_BOTTLE) {
                String path2 = currentFluid.fluid().builtInRegistryHolder().key().location().getPath();
                filled = path2.contains("water") ? new ItemStack((ItemLike)Items.POTION) : null;
                if (filled != null) {
                    if (cursorItem.getCount() > 1) {
                        cursorItem.shrink(1);
                        player.containerMenu.setCarried(cursorItem);
                        player.getInventory().add(filled);
                    } else {
                        player.containerMenu.setCarried(filled);
                    }
                    player.containerMenu.broadcastChanges();
                }
            } else if (cursorItem.getItem() == Items.BUCKET && (filled = (path = currentFluid.fluid().builtInRegistryHolder().key().location().getPath()).contains("water") ? new ItemStack((ItemLike)Items.WATER_BUCKET) : (path.contains("powder_snow") ? new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET) : null)) != null) {
                if (cursorItem.getCount() > 1) {
                    cursorItem.shrink(1);
                    player.containerMenu.setCarried(cursorItem);
                    player.getInventory().add(filled);
                } else {
                    player.containerMenu.setCarried(filled);
                }
                player.containerMenu.broadcastChanges();
            }
        }
    }

    private void setTankFluidClientSide(ItemStack shellStack, int tankIndex, FluidStackData fluid) {
        switch (tankIndex) {
            case 1: {
                shellStack.set(ModDataComponents.TANK1_FLUID.get(), (Object)fluid);
                break;
            }
            case 2: {
                shellStack.set(ModDataComponents.TANK2_FLUID.get(), (Object)fluid);
                break;
            }
            case 3: {
                shellStack.set(ModDataComponents.TANK3_FLUID.get(), (Object)fluid);
                break;
            }
            case 4: {
                shellStack.set(ModDataComponents.TANK4_FLUID.get(), (Object)fluid);
                break;
            }
            case 5: {
                shellStack.set(ModDataComponents.TANK5_FLUID.get(), (Object)fluid);
            }
        }
    }

    private boolean isLavaFluid(Fluid fluid) {
        String fluidPath = fluid.builtInRegistryHolder().key().location().getPath();
        return fluidPath.contains("lava") || fluidPath.contains("flowing_lava");
    }

    private Fluid getFluidFromContainer(ItemStack container) {
        IFluidHandlerItem handler;
        FluidStack fluidStack;
        if (container.getItem() == Items.GLASS_BOTTLE) {
            return Fluids.WATER;
        }
        Optional handlerOpt = FluidUtil.getFluidHandler((ItemStack)container);
        if (handlerOpt.isPresent() && !(fluidStack = (handler = (IFluidHandlerItem)handlerOpt.get()).getFluidInTank(0)).isEmpty()) {
            return fluidStack.getFluid();
        }
        if (container.getItem() == Items.POTION) {
            if (FluidTankWidget.isWaterPotion(container)) {
                return Fluids.WATER;
            }
            return ModFluids.POTION.get();
        }
        if (container.getItem() == Items.HONEY_BOTTLE) {
            return ModFluids.HONEY.get();
        }
        return Fluids.WATER;
    }

    private int getContainerFluidAmount(ItemStack container) {
        if (container.getItem() instanceof BucketItem) {
            return 1000;
        }
        if (container.getItem() == Items.POTION || container.getItem() == Items.HONEY_BOTTLE) {
            return 250;
        }
        return 1000;
    }

    private int getContainerCapacity(ItemStack container) {
        if (container.getItem() instanceof BucketItem) {
            return 1000;
        }
        if (container.getItem() == Items.GLASS_BOTTLE) {
            return 250;
        }
        return 1000;
    }

    private ItemStack getEmptyContainerForFluid(FluidStackData fluidData) {
        if (fluidData == null || fluidData.isEmpty()) {
            return null;
        }
        String fluidPath = fluidData.fluid().builtInRegistryHolder().key().location().getPath();
        if (fluidPath.contains("honey") || fluidPath.contains("potion")) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (fluidPath.contains("water")) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        return new ItemStack((ItemLike)Items.BUCKET);
    }

    private boolean isEmptyContainer(ItemStack item) {
        return item.getItem() == Items.BUCKET || item.getItem() == Items.GLASS_BOTTLE || item.getItem() == Items.OMINOUS_BOTTLE;
    }

    private boolean isLiquidLikeBucket(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        if (FluidUtil.getFluidContained((ItemStack)itemStack).isPresent()) {
            return true;
        }
        Item item = itemStack.getItem();
        if (item == Items.BUCKET || item == Items.GLASS_BOTTLE) {
            return false;
        }
        if (item == Items.MILK_BUCKET || item == Items.POWDER_SNOW_BUCKET || item == Items.HONEY_BOTTLE) {
            return true;
        }
        if (item == Items.POTION) {
            return true;
        }
        if (item == Items.OMINOUS_BOTTLE) {
            return false;
        }
        return item instanceof BucketItem;
    }

    private int getFluidColor(FluidStackData fluidData) {
        if (fluidData == null || fluidData.isEmpty()) {
            return -10066330;
        }
        String fluidPath = fluidData.fluid().builtInRegistryHolder().key().location().getPath();
        if (fluidPath.contains("milk")) {
            return -1;
        }
        if (fluidPath.contains("powder_snow")) {
            return -1641473;
        }
        if (fluidPath.contains("honey")) {
            return -2842601;
        }
        if (fluidPath.contains("potion")) {
            return -7643914;
        }
        if (fluidPath.contains("water")) {
            return -10575134;
        }
        if (fluidPath.contains("lava")) {
            return -1672674;
        }
        return -10066330;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private static boolean isPointIn(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private static boolean isLava(FluidStackData data) {
        return !data.isEmpty() && data.fluid().builtInRegistryHolder().key().location().getPath().contains("lava");
    }

    private static boolean isWaterRelatedFluid(FluidStackData fluidData) {
        if (fluidData == null || fluidData.isEmpty()) {
            return false;
        }
        Fluid fluid = fluidData.fluid();
        String fluidPath = fluid.builtInRegistryHolder().key().location().getPath();
        return fluidPath.contains("water") || fluidPath.contains("flowing_water");
    }

    private static boolean isWaterPotion(ItemStack itemStack) {
        if (itemStack.getItem() != Items.POTION) {
            return false;
        }
        PotionContents contents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return contents.equals((Object)PotionContents.EMPTY) || contents.potion().isPresent() && contents.potion().get() == Potions.WATER;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        return mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
    }

    public void tick() {
        if (!this.isUnlocked()) {
            return;
        }
        this.syncFromshellData();
        if (this.pendingDrainTankIndex >= 0) {
            ++this.drainWarningTimer;
            if (this.drainWarningTimer >= 60) {
                this.pendingDrainTankIndex = -1;
                this.drainWarningTimer = 0;
            }
        }
    }

    private void syncFromshellData() {
    }

    private void openConfirmDrain(int tankIndex) {
        this.pendingDrainTankIndex = tankIndex;
        this.drainWarningTimer = 0;
    }

    private void drawDrainConfirmation(GuiGraphics g, int mouseX, int mouseY) {
        String msg = "Really drain tank? Click drain button again to confirm, or click title to cancel";
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 400.0f);
        pose.scale(0.8f, 0.8f, 1.0f);
        int msgW = (int)((float)this.font.width(msg) * 0.8f);
        int msgX = this.getX() + (this.getWidth() - msgW) / 2;
        int msgY = this.getY() + this.getHeight() - 15;
        g.fill(msgX - 2, msgY - 2, msgX + msgW + 2, msgY + 10, Theme.overlayDim());
        g.renderOutline(msgX - 2, msgY - 2, msgW + 4, 12, -39322);
        g.drawString(this.font, msg, msgX, msgY, -1, false);
        pose.popPose();
    }

    private void drawPinButton(GuiGraphics g, int x, int y) {
        int color = this.isPinned ? -16711936 : -1;
        g.fill(x, y, x + 16, y + 16, color);
        g.renderOutline(x, y, 16, 16, -16777216);
    }
}

