/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.OverlayWidget;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.PurchaseWidgetPacket;
import com.etka.nomadsshell.util.InventoryUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class LockableWidget
extends OverlayWidget {
    protected final WidgetUnlockSystem.WidgetType widgetType;
    protected final IShellMenu menu;
    protected boolean showPurchaseInterface = false;
    protected boolean showUnlockDialog = false;

    public LockableWidget(int x, int y, Component message, Font font, WidgetUnlockSystem.WidgetType widgetType, IShellMenu menu) {
        super(x, y, message, font);
        this.widgetType = widgetType;
        this.menu = menu;
    }

    protected ItemStack getshellStack() {
        if (this.menu != null && this.menu.getshellContainer() != null) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                return ShellItem.findWornshell((Player)mc.player);
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack shellStack = this.getshellStack();
        if (WidgetUnlockSystem.isUnlocked(this.widgetType, shellStack)) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            this.renderLockedState(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.showUnlockDialog) {
            this.renderUnlockDialog(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderLockedState(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.getX();
        int y = this.getY();
        int currentWidth = 36;
        int currentHeight = this.showPurchaseInterface ? this.calculateDynamicHeight() : 36;
        this.drawLockedBackground(guiGraphics, currentWidth, 36);
        int lockX = x + 10;
        int lockY = y + 10;
        this.drawLockIcon(guiGraphics, lockX, lockY);
        if (this.showPurchaseInterface) {
            this.renderPurchaseInterface(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1100.0f);
        this.renderLockedControlButtons(guiGraphics, mouseX, mouseY, currentWidth, 36);
        guiGraphics.pose().popPose();
    }

    protected void drawLockedBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
        int x = this.getX();
        int y = this.getY();
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, -15066598);
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + currentHeight + 1, -7650236);
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, -15066598);
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN) {
            guiGraphics.fill(x - 3, y + 2, x - 1, y + 8, -7650236);
            guiGraphics.fill(x - 2, y + 3, x - 1, y + 7, -15066598);
            int rightEarX = x + currentWidth + 1;
            guiGraphics.fill(rightEarX, y + 2, rightEarX + 2, y + 8, -7650236);
            guiGraphics.fill(rightEarX, y + 3, rightEarX + 1, y + 7, -15066598);
        }
    }

    protected void drawLockIcon(GuiGraphics guiGraphics, int x, int y) {
        int lockColor = -5618620;
        guiGraphics.fill(x + 4, y + 8, x + 12, y + 14, lockColor);
        guiGraphics.fill(x + 6, y + 4, x + 7, y + 8, lockColor);
        guiGraphics.fill(x + 9, y + 4, x + 10, y + 8, lockColor);
        guiGraphics.fill(x + 6, y + 4, x + 10, y + 5, lockColor);
        guiGraphics.fill(x + 7, y + 10, x + 9, y + 12, -15066598);
    }

    protected int calculateDynamicHeight() {
        String desc;
        int contentHeight = 8;
        contentHeight += 10;
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN) {
            contentHeight += 10;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.FURNACE) {
            contentHeight += 10;
        }
        if ((desc = this.widgetType.getDescription()) != null && !desc.trim().isEmpty()) {
            String[] words = desc.split(" ");
            String currentLine = "";
            int maxLineWidth = 140;
            int descLines = 0;
            for (String word : words) {
                String testLine;
                String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
                if (this.font.width(testLine) > maxLineWidth && !currentLine.isEmpty()) {
                    ++descLines;
                    currentLine = word;
                    continue;
                }
                currentLine = testLine;
            }
            if (!currentLine.isEmpty()) {
                ++descLines;
            }
            contentHeight += descLines * 10;
            contentHeight += 2;
        }
        contentHeight += 10;
        contentHeight += 2;
        contentHeight += this.widgetType.getRequirements().size() * 10;
        contentHeight += 4;
        return 36 + (contentHeight += 12);
    }

    protected int calculateDynamicWidth() {
        String desc;
        int maxWidth = 36;
        String name = this.widgetType.getDisplayName();
        maxWidth = Math.max(maxWidth, this.font.width(name) + 8);
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN) {
            String trashWarning = "Things that put here gone forever!";
            maxWidth = Math.max(maxWidth, this.font.width(trashWarning) + 8);
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.FURNACE) {
            String furnaceInfo = "Put smeltable items on top, fuel on bottom!";
            maxWidth = Math.max(maxWidth, this.font.width(furnaceInfo) + 8);
        }
        if ((desc = this.widgetType.getDescription()) != null && !desc.trim().isEmpty()) {
            String[] words = desc.split(" ");
            String currentLine = "";
            for (String word : words) {
                String testLine;
                String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
                if (this.font.width(testLine) > 140) {
                    if (!currentLine.isEmpty()) {
                        maxWidth = Math.max(maxWidth, this.font.width(currentLine) + 8);
                    }
                    currentLine = word;
                    continue;
                }
                currentLine = testLine;
            }
            if (!currentLine.isEmpty()) {
                maxWidth = Math.max(maxWidth, this.font.width(currentLine) + 8);
            }
        }
        for (WidgetUnlockSystem.ItemRequirement req : this.widgetType.getRequirements()) {
            ItemStack itemStack = req.getItemStack();
            String itemName = itemStack.getHoverName().getString();
            String itemText = req.getCount() + "x " + itemName + " (0/" + req.getCount() + ")";
            maxWidth = Math.max(maxWidth, this.font.width(itemText) + 8);
        }
        String buyText = Component.translatable((String)"nomadsshell.ui.unlock").getString() + "!";
        String needText = Component.translatable((String)"nomadsshell.ui.need_items").getString();
        int buyButtonWidth = Math.max(this.font.width(buyText), this.font.width(needText)) + 12;
        maxWidth = Math.max(maxWidth, buyButtonWidth);
        return Math.max(36, Math.min(maxWidth, 200));
    }

    protected void renderPurchaseInterface(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        String desc;
        int x = this.getX();
        int y = this.getY();
        int expandedAreaX = x;
        int expandedAreaY = y + 36;
        int expandedWidth = this.calculateDynamicWidth();
        int dynamicHeight = this.calculateDynamicHeight();
        int expandedHeight = dynamicHeight - 36;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
        guiGraphics.fill(expandedAreaX - 5, expandedAreaY - 5, expandedAreaX + expandedWidth + 5, expandedAreaY + expandedHeight + 5, Integer.MIN_VALUE);
        guiGraphics.fill(expandedAreaX, expandedAreaY, expandedAreaX + expandedWidth, expandedAreaY + expandedHeight, -14013910);
        guiGraphics.fill(expandedAreaX - 1, expandedAreaY - 1, expandedAreaX + expandedWidth + 1, expandedAreaY + expandedHeight + 1, -5614251);
        guiGraphics.fill(expandedAreaX, expandedAreaY, expandedAreaX + expandedWidth, expandedAreaY + expandedHeight, -14013910);
        guiGraphics.fill(expandedAreaX + 1, expandedAreaY + 1, expandedAreaX + expandedWidth - 1, expandedAreaY + expandedHeight - 1, -12961222);
        int textX = expandedAreaX + 4;
        int textY = expandedAreaY + 4;
        String name = this.widgetType.getDisplayName();
        guiGraphics.drawString(this.font, name, textX, textY, 0xFFFFFF);
        textY += 10;
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN) {
            String trashWarning = Component.translatable((String)"nomadsshell.lockable.trash_warning").getString();
            guiGraphics.drawString(this.font, trashWarning, textX, textY, -30584);
            textY += 10;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.FURNACE) {
            String furnaceInfo = Component.translatable((String)"nomadsshell.lockable.furnace_info").getString();
            guiGraphics.drawString(this.font, furnaceInfo, textX, textY, -7798904);
            textY += 10;
        }
        if ((desc = this.widgetType.getDescription()) != null && !desc.trim().isEmpty()) {
            String[] words = desc.split(" ");
            String currentLine = "";
            int maxLineWidth = expandedWidth - 12;
            for (String word : words) {
                String testLine;
                String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
                if (this.font.width(testLine) > maxLineWidth && !currentLine.isEmpty()) {
                    guiGraphics.drawString(this.font, currentLine, textX, textY, 0xFFAAAAA);
                    textY += 10;
                    currentLine = word;
                    continue;
                }
                currentLine = testLine;
            }
            if (!currentLine.isEmpty()) {
                guiGraphics.drawString(this.font, currentLine, textX, textY, 0xFFAAAAA);
                textY += 10;
            }
            textY += 2;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            boolean buttonHovered;
            boolean hasItems = WidgetUnlockSystem.hasRequiredItems(this.widgetType, (Player)mc.player);
            String reqText = hasItems ? Component.translatable((String)"nomadsshell.lockable.ready_to_buy").getString() : Component.translatable((String)"nomadsshell.lockable.need_items").getString();
            int reqColor = hasItems ? -11141291 : -43691;
            guiGraphics.drawString(this.font, reqText, textX, textY, reqColor);
            textY += 10;
            textY += 2;
            List<WidgetUnlockSystem.ItemRequirement> requirements = this.widgetType.getRequirements();
            for (WidgetUnlockSystem.ItemRequirement req : requirements) {
                ItemStack itemStack = req.getItemStack();
                String itemName = itemStack.getHoverName().getString();
                int playerHas = 0;
                if (mc.player != null) {
                    playerHas = InventoryUtils.countItemAcrossInventoryAndshell((Player)mc.player, req.getItem());
                }
                boolean hasThisItem = playerHas >= req.getCount();
                String itemText = req.getCount() + "x " + itemName;
                String countText = " (" + playerHas + "/" + req.getCount() + ")";
                int itemColor = hasThisItem ? -11141291 : -43691;
                guiGraphics.drawString(this.font, itemText, textX, textY, itemColor);
                guiGraphics.drawString(this.font, countText, textX + this.font.width(itemText), textY, -3355444);
                textY += 10;
            }
            int buttonWidth = expandedWidth - 8;
            int buttonHeight = 12;
            int buttonX = expandedAreaX + 4;
            int buttonY = textY += 4;
            int maxButtonY = expandedAreaY + expandedHeight - buttonHeight - 4;
            if (buttonY > maxButtonY) {
                buttonY = maxButtonY;
            }
            boolean bl = buttonHovered = mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight;
            int buttonColor = hasItems ? (buttonHovered ? -8913033 : -11141291) : -11184811;
            guiGraphics.fill(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, buttonColor);
            int borderColor = buttonHovered ? -1 : -16777216;
            guiGraphics.fill(buttonX - 1, buttonY - 1, buttonX + buttonWidth + 1, buttonY + buttonHeight + 1, borderColor);
            guiGraphics.fill(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, buttonColor);
            if (buttonHovered && hasItems) {
                int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
                guiGraphics.fill(buttonX - 2, buttonY - 2, buttonX + buttonWidth + 2, buttonY + buttonHeight + 2, hoverOverlay);
            }
            Object buttonText = hasItems ? Component.translatable((String)"nomadsshell.ui.unlock").getString() + "!" : Component.translatable((String)"nomadsshell.ui.need_items").getString();
            int buttonTextColor = hasItems ? -16777216 : -7829368;
            int textCenterX = buttonX + (buttonWidth - this.font.width((String)buttonText)) / 2;
            int textCenterY = buttonY + 2;
            guiGraphics.drawString(this.font, (String)buttonText, textCenterX, textCenterY, buttonTextColor);
        }
        guiGraphics.pose().popPose();
    }

    protected void renderLockedControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int x = this.getX();
        int y = this.getY();
        int expandX = x + currentWidth - 8 - 2;
        int expandY = y + currentHeight - 8 - 2;
        boolean expandHovered = mouseX >= expandX && mouseX <= expandX + 8 && mouseY >= expandY && mouseY <= expandY + 8;
        guiGraphics.fill(expandX, expandY, expandX + 8, expandY + 8, expandHovered ? -11908534 : -12961222);
        if (this.showPurchaseInterface) {
            guiGraphics.fill(expandX + 5, expandY + 3, expandX + 6, expandY + 5, -1);
            guiGraphics.fill(expandX + 4, expandY + 4, expandX + 5, expandY + 4, -1);
            guiGraphics.fill(expandX + 3, expandY + 3, expandX + 4, expandY + 5, -1);
        } else {
            guiGraphics.fill(expandX + 3, expandY + 3, expandX + 4, expandY + 5, -1);
            guiGraphics.fill(expandX + 4, expandY + 4, expandX + 5, expandY + 4, -1);
            guiGraphics.fill(expandX + 5, expandY + 3, expandX + 6, expandY + 5, -1);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            return false;
        }
        ItemStack shellStack = this.getshellStack();
        if (!WidgetUnlockSystem.isUnlocked(this.widgetType, shellStack)) {
            return this.handleLockedClick(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean handleLockedClick(double mouseX, double mouseY, int button) {
        int currentWidth;
        if (this.showUnlockDialog) {
            return this.handleUnlockDialogClick(mouseX, mouseY, button);
        }
        int x = this.getX();
        int y = this.getY();
        int currentHeight = this.showPurchaseInterface ? this.calculateDynamicHeight() : 36;
        int n = currentWidth = this.showPurchaseInterface ? this.calculateDynamicWidth() : 36;
        if (mouseX >= (double)x && mouseX <= (double)(x + 36) && mouseY >= (double)y && mouseY <= (double)(y + 36)) {
            int lockX = x + 10;
            int lockY = y + 10;
            if (mouseX >= (double)lockX && mouseX <= (double)(lockX + 16) && mouseY >= (double)lockY && mouseY <= (double)(lockY + 16)) {
                this.showUnlockDialog = true;
                this.showPurchaseInterface = false;
                return true;
            }
            return true;
        }
        if (this.showPurchaseInterface && button == 0) {
            int expandedAreaX = x;
            int expandedAreaY = y + 36;
            int expandedWidth = this.calculateDynamicWidth();
            int expandedHeight = currentHeight - 36;
            if (mouseX >= (double)expandedAreaX && mouseX <= (double)(expandedAreaX + expandedWidth) && mouseY >= (double)expandedAreaY && mouseY <= (double)(expandedAreaY + expandedHeight)) {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player != null) {
                    String desc;
                    int buttonWidth = expandedWidth - 8;
                    int buttonHeight = 12;
                    int buttonX = expandedAreaX + 4;
                    int textY = expandedAreaY + 4;
                    textY += 10;
                    if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN) {
                        textY += 10;
                    }
                    if (this.widgetType == WidgetUnlockSystem.WidgetType.FURNACE) {
                        textY += 10;
                    }
                    if ((desc = this.widgetType.getDescription()) != null && !desc.trim().isEmpty()) {
                        String[] words = desc.split(" ");
                        String currentLine = "";
                        int maxLineWidth = expandedWidth - 12;
                        for (String word : words) {
                            String testLine;
                            String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
                            if (this.font.width(testLine) > maxLineWidth && !currentLine.isEmpty()) {
                                textY += 10;
                                currentLine = word;
                                continue;
                            }
                            currentLine = testLine;
                        }
                        if (!currentLine.isEmpty()) {
                            textY += 10;
                        }
                        textY += 2;
                    }
                    textY += 10;
                    textY += 2;
                    textY += this.widgetType.getRequirements().size() * 10;
                    int buttonY = textY += 4;
                    if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight)) {
                        if (WidgetUnlockSystem.hasRequiredItems(this.widgetType, (Player)mc.player)) {
                            this.attemptPurchase();
                            this.showPurchaseInterface = false;
                            return true;
                        }
                        return true;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void togglePurchaseInterface() {
        this.showPurchaseInterface = !this.showPurchaseInterface;
    }

    protected void attemptPurchase() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && WidgetUnlockSystem.hasRequiredItems(this.widgetType, (Player)mc.player)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseWidgetPacket(this.widgetType, WidgetUnlockSystem.WidgetTier.TIER_I), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isUnlocked() {
        ItemStack shellStack = this.getshellStack();
        return WidgetUnlockSystem.isUnlocked(this.widgetType, shellStack);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.showUnlockDialog) {
            if (keyCode == 256) {
                this.showUnlockDialog = false;
                return true;
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderUnlockDialog(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        boolean unlockHovered;
        String desc;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            this.showUnlockDialog = false;
            return;
        }
        int dialogWidth = this.calculateUnlockDialogWidth();
        int dialogHeight = this.calculateUnlockDialogHeight();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int dialogX = (screenWidth - dialogWidth) / 2;
        int dialogY = (screenHeight - dialogHeight) / 2;
        guiGraphics.fill(0, 0, screenWidth, screenHeight, Theme.overlayDim());
        guiGraphics.fill(dialogX, dialogY, dialogX + dialogWidth, dialogY + dialogHeight, Theme.panelBg());
        guiGraphics.fill(dialogX - 1, dialogY - 1, dialogX + dialogWidth + 1, dialogY + dialogHeight + 1, Theme.panelBorder());
        guiGraphics.fill(dialogX, dialogY, dialogX + dialogWidth, dialogY + dialogHeight, Theme.panelBg());
        String title = Component.translatable((String)"nomadsshell.ui.unlock_widget", (Object[])new Object[]{this.widgetType.getDisplayName()}).getString();
        int titleY = dialogY + 8;
        guiGraphics.drawString(this.font, title, dialogX + 8, titleY, -1);
        int currentY = titleY + 14;
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN) {
            String trashWarning = "Things that put here gone forever!";
            guiGraphics.drawString(this.font, trashWarning, dialogX + 8, currentY, -30584);
            currentY += 12;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.FURNACE) {
            String furnaceInfo = "Put smeltable items on top, fuel on bottom!";
            guiGraphics.drawString(this.font, furnaceInfo, dialogX + 8, currentY, -7820545);
            currentY += 12;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TELEPORTER) {
            String teleportInfo = "Tier I: Bed/Spawn | Tier II: Nether/Overworld | Tier III: End | Tier IV: Pocket Dimension";
            guiGraphics.drawString(this.font, teleportInfo, dialogX + 8, currentY, -7798904);
            currentY += 12;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.CRAFTING_TABLE) {
            String craftInfo = "Starts as 2x2 crafting, upgrades to full 3x3!";
            guiGraphics.drawString(this.font, craftInfo, dialogX + 8, currentY, -7820545);
            currentY += 12;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
            String fluidInfo = "Store any fluid with input/output ports!";
            guiGraphics.drawString(this.font, fluidInfo, dialogX + 8, currentY, -7820545);
            currentY += 12;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM) {
            String dripInfo = "Feed fluid buckets on top, collect at bottom!";
            guiGraphics.drawString(this.font, dripInfo, dialogX + 8, currentY, -7820545);
            currentY += 12;
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
            String guardianInfo = "Protection features: armor presets, snow walk, piglin neutrality!";
            guiGraphics.drawString(this.font, guardianInfo, dialogX + 8, currentY, -7820545);
            currentY += 12;
        }
        if ((desc = this.widgetType.getDescription()) != null && !desc.trim().isEmpty()) {
            String[] words = desc.split(" ");
            String currentLine = "";
            int maxLineWidth = dialogWidth - 16;
            for (String word : words) {
                String testLine;
                String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
                if (this.font.width(testLine) > maxLineWidth && !currentLine.isEmpty()) {
                    guiGraphics.drawString(this.font, currentLine, dialogX + 8, currentY, 0xFFAAAAA);
                    currentY += 10;
                    currentLine = word;
                    continue;
                }
                currentLine = testLine;
            }
            if (!currentLine.isEmpty()) {
                guiGraphics.drawString(this.font, currentLine, dialogX + 8, currentY, 0xFFAAAAA);
                currentY += 10;
            }
            currentY += 4;
        }
        boolean hasAllItems = WidgetUnlockSystem.hasRequiredItems(this.widgetType, (Player)mc.player);
        guiGraphics.drawString(this.font, Component.translatable((String)"nomadsshell.ui.requirements").getString(), dialogX + 8, currentY, -1);
        currentY += 12;
        List<WidgetUnlockSystem.ItemRequirement> requirements = this.widgetType.getRequirements();
        for (WidgetUnlockSystem.ItemRequirement req : requirements) {
            int playerHas = InventoryUtils.countItemAcrossInventoryAndshell((Player)mc.player, req.getItem());
            boolean hasThisItem = playerHas >= req.getCount();
            String itemName = req.getItem().getName(req.getItemStack()).getString();
            String itemText = req.getCount() + "x " + itemName;
            String countText = " (" + playerHas + "/" + req.getCount() + ")";
            int itemColor = hasThisItem ? -11141291 : -43691;
            guiGraphics.drawString(this.font, itemText, dialogX + 16, currentY, itemColor);
            guiGraphics.drawString(this.font, countText, dialogX + 16 + this.font.width(itemText), currentY, -3355444);
            currentY += 10;
        }
        int buttonY = currentY += 8;
        int buttonHeight = 12;
        int buttonSpacing = 4;
        int totalButtonWidth = (dialogWidth - 24) / 2;
        int unlockButtonX = dialogX + 8;
        boolean bl = unlockHovered = mouseX >= unlockButtonX && mouseX <= unlockButtonX + totalButtonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight;
        int unlockButtonColor = hasAllItems ? (unlockHovered ? -8913033 : -11141291) : -11184811;
        guiGraphics.fill(unlockButtonX, buttonY, unlockButtonX + totalButtonWidth, buttonY + buttonHeight, unlockButtonColor);
        Object unlockText = hasAllItems ? Component.translatable((String)"nomadsshell.ui.unlock").getString() + "!" : Component.translatable((String)"nomadsshell.ui.need_items").getString();
        int unlockTextColor = hasAllItems ? -16777216 : -7829368;
        int unlockTextX = unlockButtonX + (totalButtonWidth - this.font.width((String)unlockText)) / 2;
        int unlockTextY = buttonY + 2;
        guiGraphics.drawString(this.font, (String)unlockText, unlockTextX, unlockTextY, unlockTextColor);
        int cancelButtonX = unlockButtonX + totalButtonWidth + buttonSpacing;
        boolean cancelHovered = mouseX >= cancelButtonX && mouseX <= cancelButtonX + totalButtonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight;
        int cancelButtonColor = cancelHovered ? -8947849 : -11184811;
        guiGraphics.fill(cancelButtonX, buttonY, cancelButtonX + totalButtonWidth, buttonY + buttonHeight, cancelButtonColor);
        String cancelText = "Cancel";
        int cancelTextX = cancelButtonX + (totalButtonWidth - this.font.width(cancelText)) / 2;
        int cancelTextY = buttonY + 2;
        guiGraphics.drawString(this.font, cancelText, cancelTextX, cancelTextY, -1);
    }

    private int calculateUnlockDialogWidth() {
        int maxWidth = 220;
        String title = Component.translatable((String)"nomadsshell.ui.unlock_widget", (Object[])new Object[]{this.widgetType.getDisplayName()}).getString();
        maxWidth = Math.max(maxWidth, this.font.width(title) + 16);
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN) {
            String trashWarning = "Things that put here gone forever!";
            maxWidth = Math.max(maxWidth, this.font.width(trashWarning) + 16);
        }
        if (this.widgetType == WidgetUnlockSystem.WidgetType.FURNACE) {
            String furnaceInfo = "Put smeltable items on top, fuel on bottom!";
            maxWidth = Math.max(maxWidth, this.font.width(furnaceInfo) + 16);
        }
        List<WidgetUnlockSystem.ItemRequirement> requirements = this.widgetType.getRequirements();
        for (WidgetUnlockSystem.ItemRequirement req : requirements) {
            String itemName = req.getItem().getName(req.getItemStack()).getString();
            String itemText = req.getCount() + "x " + itemName + " (999/999)";
            maxWidth = Math.max(maxWidth, this.font.width(itemText) + 32);
        }
        String desc = this.widgetType.getDescription();
        if (desc != null && !desc.trim().isEmpty()) {
            String[] words;
            for (String word : words = desc.split(" ")) {
                maxWidth = Math.max(maxWidth, this.font.width(word) + 16);
            }
        }
        return Math.min(maxWidth, 320);
    }

    private int calculateUnlockDialogHeight() {
        String desc;
        int height = 16;
        height += 14;
        if (this.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN || this.widgetType == WidgetUnlockSystem.WidgetType.FURNACE) {
            height += 12;
        }
        if ((desc = this.widgetType.getDescription()) != null && !desc.trim().isEmpty()) {
            String[] words = desc.split(" ");
            String currentLine = "";
            int maxLineWidth = this.calculateUnlockDialogWidth() - 16;
            for (String word : words) {
                String testLine;
                String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
                if (this.font.width(testLine) > maxLineWidth && !currentLine.isEmpty()) {
                    height += 10;
                    currentLine = word;
                    continue;
                }
                currentLine = testLine;
            }
            if (!currentLine.isEmpty()) {
                height += 10;
            }
            height += 4;
        }
        height += 12;
        height += this.widgetType.getRequirements().size() * 10;
        return height += 20;
    }

    protected boolean handleUnlockDialogClick(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int dialogWidth = this.calculateUnlockDialogWidth();
        int dialogHeight = this.calculateUnlockDialogHeight();
        int dialogX = (screenWidth - dialogWidth) / 2;
        int dialogY = (screenHeight - dialogHeight) / 2;
        if (mouseX < (double)dialogX || mouseX > (double)(dialogX + dialogWidth) || mouseY < (double)dialogY || mouseY > (double)(dialogY + dialogHeight)) {
            this.showUnlockDialog = false;
            return true;
        }
        if (mc.player == null) {
            this.showUnlockDialog = false;
            return true;
        }
        boolean hasAllItems = WidgetUnlockSystem.hasRequiredItems(this.widgetType, (Player)mc.player);
        int buttonY = dialogY + this.calculateUnlockDialogHeight() - 20;
        int buttonHeight = 12;
        int buttonSpacing = 4;
        int totalButtonWidth = (dialogWidth - 24) / 2;
        int unlockButtonX = dialogX + 8;
        if (mouseX >= (double)unlockButtonX && mouseX <= (double)(unlockButtonX + totalButtonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight) && hasAllItems) {
            this.performUnlock();
            this.showUnlockDialog = false;
            return true;
        }
        int cancelButtonX = unlockButtonX + totalButtonWidth + buttonSpacing;
        if (mouseX >= (double)cancelButtonX && mouseX <= (double)(cancelButtonX + totalButtonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight)) {
            this.showUnlockDialog = false;
            return true;
        }
        return true;
    }

    protected void performUnlock() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && WidgetUnlockSystem.hasRequiredItems(this.widgetType, (Player)mc.player)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseWidgetPacket(this.widgetType, WidgetUnlockSystem.WidgetTier.TIER_I), (CustomPacketPayload[])new CustomPacketPayload[0]);
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)1.2f, (float)1.0f));
        }
    }
}

