/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.TeleportRequestPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class TeleportWidget
extends LockableWidget {
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_GAP = 2;
    private static final int SIDE_PAD = 4;
    private static final int ICON_SIZE = 16;
    private static final int ICON_LEFT_PAD = 2;
    private static final int TEXT_LEFT_PAD = 24;
    private boolean logoMode = false;

    private static int loadPositionX(int defaultX) {
        int cx = (Integer)OverlayConfig.TELEPORTER_X.get();
        return cx != 0 ? cx : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int cy = (Integer)OverlayConfig.TELEPORTER_Y.get();
        return cy != 0 ? cy : defaultY;
    }

    public TeleportWidget(int x, int y, Font font, IShellMenu menu) {
        super(TeleportWidget.loadPositionX(x), TeleportWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.teleporter"), font, WidgetUnlockSystem.WidgetType.TELEPORTER, menu);
        this.isPinned = (Boolean)OverlayConfig.TELEPORTER_PINNED.get();
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.TELEPORTER_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.TELEPORTER_USE_IMAGE_MODE.get();
        OverlayConfig.TELEPORTER_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    private void savePinStateToConfig() {
        try {
            OverlayConfig.TELEPORTER_PINNED.set((Object)this.isPinned);
            OverlayConfig.TELEPORTER_X.set((Object)this.getX());
            OverlayConfig.TELEPORTER_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getNetherOverworldButtonText() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return Component.translatable((String)"nomadsshell.teleport.nether_overworld_btn").getString();
        }
        if (mc.level.dimension() == Level.NETHER) {
            return Component.translatable((String)"nomadsshell.teleport.nether_overworld_btn.overworld").getString();
        }
        return Component.translatable((String)"nomadsshell.teleport.nether_overworld_btn.nether").getString();
    }

    private String getEndButtonText() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return Component.translatable((String)"nomadsshell.teleport.end_spawn").getString();
        }
        if (mc.level.dimension() == Level.END) {
            return Component.translatable((String)"nomadsshell.teleport.end_spawn.return").getString();
        }
        return Component.translatable((String)"nomadsshell.teleport.end_spawn").getString();
    }

    private String getPocketDimensionButtonText() {
        boolean inPocket;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return Component.translatable((String)"nomadsshell.teleport.pocket_dimension").getString();
        }
        ResourceLocation dimensionKey = mc.level.dimension().location();
        boolean bl = inPocket = dimensionKey.getNamespace().equals("nomadsshell") && (dimensionKey.getPath().equals("pocket") || dimensionKey.getPath().equals("overworld_pocket"));
        if (inPocket) {
            return Component.translatable((String)"nomadsshell.teleport.pocket_dimension.return").getString();
        }
        return Component.translatable((String)"nomadsshell.teleport.pocket_dimension").getString();
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean titleBarHovered;
        boolean hoveredWidget;
        int x = this.getX();
        int y = this.getY();
        int w = 140;
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, this.getshellStack());
        int buttonCount = 1;
        if (tier.getLevel() >= 2) {
            ++buttonCount;
        }
        if (tier.getLevel() >= 3) {
            ++buttonCount;
        }
        if (tier.getLevel() >= 4) {
            ++buttonCount;
        }
        if (tier.getLevel() >= 5) {
            ++buttonCount;
        }
        int contentHeight = 14 + buttonCount * 20 + Math.max(0, buttonCount - 1) * 2 + 2;
        this.width = w;
        int h = this.height = Math.max(36, contentHeight);
        boolean imageEnabled = (Boolean)OverlayConfig.TELEPORTER_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TELEPORTER);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(guiGraphics, x, y + 12, w, h - 12);
            return;
        }
        guiGraphics.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        guiGraphics.fill(x, y + 12 - 1, x + w, y + 12, Theme.titleBarBorder());
        boolean bl2 = titleBarHovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging()) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + w, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        guiGraphics.fill(x, contentY, x + w, y + h, Theme.panelBg());
        int btnY = y + 12 + 2;
        int btnHeight = 20;
        int btnWidth = w - 8;
        this.drawTeleportButton(guiGraphics, x + 4, btnY, btnWidth, btnHeight, Component.translatable((String)"nomadsshell.teleport.bed_spawn").getString(), Items.RED_BED.getDefaultInstance(), true, mouseX, mouseY);
        if (tier.getLevel() >= 2) {
            this.drawTeleportButton(guiGraphics, x + 4, btnY += btnHeight + 2, btnWidth, btnHeight, this.getNetherOverworldButtonText(), Items.OBSIDIAN.getDefaultInstance(), true, mouseX, mouseY);
        }
        boolean inPocket = false;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            ResourceLocation key = mc.level.dimension().location();
            boolean bl3 = inPocket = key.getNamespace().equals("nomadsshell") && ("pocket".equals(key.getPath()) || "overworld_pocket".equals(key.getPath()));
        }
        if (tier.getLevel() >= 3) {
            this.drawTeleportButton(guiGraphics, x + 4, btnY += btnHeight + 2, btnWidth, btnHeight, Component.translatable((String)"nomadsshell.teleport.random_local").getString(), Items.CHORUS_FRUIT.getDefaultInstance(), !inPocket, mouseX, mouseY);
        }
        if (tier.getLevel() >= 4) {
            this.drawTeleportButton(guiGraphics, x + 4, btnY += btnHeight + 2, btnWidth, btnHeight, this.getPocketDimensionButtonText(), Items.ENDER_PEARL.getDefaultInstance(), true, mouseX, mouseY);
        }
        if (tier.getLevel() >= 5) {
            this.drawTeleportButton(guiGraphics, x + 4, btnY += btnHeight + 2, btnWidth, btnHeight, this.getEndButtonText(), Items.END_PORTAL_FRAME.getDefaultInstance(), true, mouseX, mouseY);
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int contentY, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = contentY + (currentHeight - iconSize) / 2;
        try {
            guiGraphics.blit(Theme.icon("portal"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        catch (Throwable t) {
            this.drawPortalIcon(guiGraphics, iconX, iconY, iconSize, iconSize);
        }
    }

    private void drawPortalIcon(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int portalColor = -7722014;
        guiGraphics.fill(x + 2, y + 2, x + width - 2, y + height - 2, portalColor);
        guiGraphics.fill(x + 4, y + 4, x + width - 4, y + height - 4, -16777216);
        guiGraphics.fill(x + 6, y + 6, x + width - 6, y + 7, portalColor);
        guiGraphics.fill(x + 6, y + height - 7, x + width - 6, y + height - 6, portalColor);
        guiGraphics.fill(x + 6, y + 8, x + 7, y + height - 8, portalColor);
        guiGraphics.fill(x + width - 7, y + 8, x + width - 6, y + height - 8, portalColor);
    }

    private void drawTeleportButton(GuiGraphics g, int x, int y, int w, int h, String text, ItemStack icon, boolean enabled, int mouseX, int mouseY) {
        boolean hovered;
        boolean bl = hovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        int bgColor = enabled ? (hovered ? -11908534 : -12961222) : -14013910;
        g.fill(x, y, x + w, y + h, bgColor);
        int borderColor = enabled ? (hovered ? -9803158 : -10855846) : -12961222;
        g.fill(x, y, x + w, y + 1, borderColor);
        g.fill(x, y, x + 1, y + h, borderColor);
        g.fill(x + w - 1, y, x + w, y + h, borderColor);
        g.fill(x, y + h - 1, x + w, y + h, borderColor);
        g.renderItem(icon, x + 2, y + (h - 16) / 2);
        int textColor = enabled ? -2039584 : -8355712;
        g.drawString(this.font, text, x + 24, y + (h - 8) / 2, textColor);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TELEPORTER);
        this.logoMode = false;
        if (!this.isUnlocked()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int btnHeight = 20;
        int btnWidth = 132;
        int btnY = y + 12 + 2;
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, this.getshellStack());
        if (this.inside(mouseX, mouseY, x + 4, btnY, btnWidth, btnHeight)) {
            this.sendTeleport(TeleportRequestPacket.Action.BED_OR_SPAWN);
            return true;
        }
        if (tier.getLevel() >= 2 && this.inside(mouseX, mouseY, x + 4, btnY += btnHeight + 2, btnWidth, btnHeight)) {
            this.sendTeleport(TeleportRequestPacket.Action.TOGGLE_NETHER_OVERWORLD);
            return true;
        }
        if (tier.getLevel() >= 3) {
            btnY += btnHeight + 2;
            boolean inPocket = false;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                ResourceLocation key = mc.level.dimension().location();
                boolean bl2 = inPocket = key.getNamespace().equals("nomadsshell") && ("pocket".equals(key.getPath()) || "overworld_pocket".equals(key.getPath()));
            }
            if (!inPocket && this.inside(mouseX, mouseY, x + 4, btnY, btnWidth, btnHeight)) {
                this.sendTeleport(TeleportRequestPacket.Action.RANDOM_LOCAL);
                return true;
            }
        }
        if (tier.getLevel() >= 4 && this.inside(mouseX, mouseY, x + 4, btnY += btnHeight + 2, btnWidth, btnHeight)) {
            this.sendTeleport(TeleportRequestPacket.Action.POCKET_DIMENSION);
            return true;
        }
        if (tier.getLevel() >= 5 && this.inside(mouseX, mouseY, x + 4, btnY += btnHeight + 2, btnWidth, btnHeight)) {
            this.sendTeleport(TeleportRequestPacket.Action.END_SPAWN);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean inside;
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    private boolean inside(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx <= (double)(x + w) && my >= (double)y && my <= (double)(y + h);
    }

    private void sendTeleport(TeleportRequestPacket.Action action) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new TeleportRequestPacket(action), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

