/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.ClearTrashPacket;
import com.etka.nomadsshell.network.MoveItemToShellPacket;
import com.etka.nomadsshell.network.RetrieveFromTrashPacket;
import com.etka.nomadsshell.network.TrashItemPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.Base64;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class TrashBinWidget
extends LockableWidget {
    private ItemStack heldItem = ItemStack.EMPTY;
    private boolean isHovering = false;
    private int deleteTimer = 0;
    private float animationTime = 0.0f;
    private boolean isDeleting = false;
    private boolean waitingForServerSync = false;
    private ItemStack expectedServerItem = ItemStack.EMPTY;
    private boolean logoMode = false;
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int CONTENT_MARGIN = 4;
    private static final int SLOT_SIZE = 16;

    private int getDeleteDelay() {
        return (Integer)OverlayConfig.TRASH_DELETE_DELAY.get();
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.TRASH_BIN_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.TRASH_BIN_USE_IMAGE_MODE.get();
        OverlayConfig.TRASH_BIN_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        OverlayConfig.SPEC.save();
    }

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.TRASH_BIN_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.TRASH_BIN_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    private ItemStack loadHeldItemFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            return WidgetDataHelper.getTrashBinItem((Player)mc.player);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack loadHeldItemFromConfig() {
        try {
            String nbtString = (String)OverlayConfig.TRASH_BIN_ITEM_NBT.get();
            int count = (Integer)OverlayConfig.TRASH_BIN_ITEM_COUNT.get();
            if (nbtString.isEmpty() || count <= 0) {
                return ItemStack.EMPTY;
            }
            byte[] nbtBytes = Base64.getDecoder().decode(nbtString);
            String nbtJson = new String(nbtBytes);
            CompoundTag nbt = TagParser.parseTag((String)nbtJson);
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)nbt);
            stack.setCount(count);
            return stack;
        }
        catch (Exception e) {
            OverlayConfig.TRASH_BIN_ITEM_NBT.set((Object)"");
            OverlayConfig.TRASH_BIN_ITEM_COUNT.set((Object)0);
            return ItemStack.EMPTY;
        }
    }

    private void saveHeldItemToConfig() {
    }

    private void savePositionToConfig() {
        OverlayConfig.TRASH_BIN_X.set((Object)this.getX());
        OverlayConfig.TRASH_BIN_Y.set((Object)this.getY());
        OverlayConfig.SPEC.save();
    }

    private void savePinStateToConfig() {
        OverlayConfig.TRASH_BIN_PINNED.set((Object)this.isPinned);
        OverlayConfig.SPEC.save();
    }

    public TrashBinWidget(int x, int y, Font font, IShellMenu menu) {
        super(TrashBinWidget.loadPositionX(x), TrashBinWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.trash_bin"), font, WidgetUnlockSystem.WidgetType.TRASH_BIN, menu);
        this.heldItem = this.loadHeldItemFromshell();
        this.isPinned = (Boolean)OverlayConfig.TRASH_BIN_PINNED.get();
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean titleBarHovered;
        boolean imageEnabled = (Boolean)OverlayConfig.TRASH_BIN_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TRASH_BIN);
        int x = this.getX();
        int y = this.getY();
        this.animationTime += partialTick;
        int currentWidth = 36;
        guiGraphics.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + 12, Theme.panelBorder());
        guiGraphics.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        boolean bl = titleBarHovered = mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + currentWidth, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        int contentHeight = 24;
        guiGraphics.fill(x, contentY, x + 36, contentY + contentHeight, Theme.panelBg());
        guiGraphics.fill(x - 1, contentY - 1, x + 36 + 1, contentY + contentHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, contentY, x + 36, contentY + contentHeight, Theme.panelBg());
        boolean hoveredWidget = mouseX >= x && mouseX <= x + 36 && mouseY >= y && mouseY <= y + 36;
        boolean showLogo = this.logoMode && !hoveredWidget;
        int iconX = x + 10;
        int iconY = contentY + (contentHeight - 16) / 2;
        if (showLogo) {
            this.renderLogoIcon(guiGraphics, iconX, iconY);
        } else {
            this.drawTrashBinIcon(guiGraphics, iconX, iconY, 16, 16);
        }
        this.drawDeleteProgressBackground(guiGraphics, x, contentY, 36, contentHeight);
        if (!this.logoMode && !this.heldItem.isEmpty()) {
            int itemX = x + 10;
            int itemY = contentY + (contentHeight - 16) / 2;
            guiGraphics.renderItem(this.heldItem, itemX, itemY);
            if (this.heldItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.heldItem, itemX, itemY);
            }
        }
        if (!this.logoMode && this.isDeleting) {
            float glowAlpha = (float)(Math.sin(this.animationTime * 0.3f) * 0.5 + 0.5) * 0.3f;
            guiGraphics.fill(x + 2, contentY + 2, x + 36 - 2, contentY + contentHeight - 2, (int)(glowAlpha * 255.0f) << 24 | 0xFF5555);
        }
        if (this.showContextMenu) {
            this.renderContextMenu(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int iconX, int iconY) {
        ResourceLocation tex = Theme.icon("trash");
        try {
            guiGraphics.blit(tex, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Throwable t) {
            this.drawTrashBinIcon(guiGraphics, iconX, iconY, 16, 16);
        }
    }

    @Override
    protected boolean hasSideEars() {
        return true;
    }

    private void drawTrashBinIcon(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int binColor = this.isHovering ? -43691 : -5592406;
        guiGraphics.fill(x + 2, y + 2, x + width - 2, y + 4, binColor);
        guiGraphics.fill(x + 4, y + 1, x + width - 4, y + 2, binColor);
        guiGraphics.fill(x + 3, y + 4, x + width - 3, y + height - 1, binColor);
        guiGraphics.fill(x + 6, y, x + width - 6, y + 1, binColor);
        if (width >= 12) {
            int lineColor = Theme.textSecondary();
            guiGraphics.fill(x + 5, y + 6, x + 6, y + height - 3, lineColor);
            guiGraphics.fill(x + 8, y + 6, x + 9, y + height - 3, lineColor);
            guiGraphics.fill(x + 11, y + 6, x + 12, y + height - 3, lineColor);
        }
    }

    private void drawDeleteProgressBackground(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        float progressPercent = 0.0f;
        if (this.isHovering && this.deleteTimer > 0) {
            progressPercent = (float)this.deleteTimer / (float)this.getDeleteDelay();
        }
        if (progressPercent > 0.0f) {
            int fillWidth = (int)((float)width * progressPercent);
            int redColor = -52429;
            guiGraphics.fill(x, y, x + fillWidth, y + height, redColor);
        }
    }

    public void tick() {
        if (!this.isUnlocked() || !((Boolean)OverlayConfig.TRASH_BIN_ENABLED.get()).booleanValue()) {
            return;
        }
        this.syncWithshellData();
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TRASH_BIN)) {
            this.isHovering = false;
            this.deleteTimer = 0;
            this.isDeleting = false;
            return;
        }
        if (this.isHovering && !this.heldItem.isEmpty()) {
            ++this.deleteTimer;
            if (this.deleteTimer >= this.getDeleteDelay()) {
                this.deleteItem();
            }
        } else {
            this.deleteTimer = 0;
            this.isDeleting = false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.mouseHandler != null) {
            boolean currentlyHoveringContent;
            double mouseX = mc.mouseHandler.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth();
            double mouseY = mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
            boolean wasHovering = this.isHovering;
            this.isHovering = currentlyHoveringContent = this.isMouseOverContent(mouseX, mouseY);
            if (wasHovering != this.isHovering) {
                this.onHoverStateChanged(this.isHovering);
            }
        }
    }

    private void syncWithshellData() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            ItemStack shellTrashItem = WidgetDataHelper.getTrashBinItem((Player)mc.player);
            if (this.waitingForServerSync) {
                if (ItemStack.matches((ItemStack)shellTrashItem, (ItemStack)this.expectedServerItem)) {
                    this.heldItem = shellTrashItem.copy();
                    this.waitingForServerSync = false;
                    this.expectedServerItem = ItemStack.EMPTY;
                }
                return;
            }
            if (!ItemStack.matches((ItemStack)this.heldItem, (ItemStack)shellTrashItem)) {
                this.heldItem = shellTrashItem.copy();
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = this.getX();
        int y = this.getY();
        int currentWidth = 36;
        int currentHeight = 36;
        if (button == 1) {
            boolean inTitle;
            boolean bl = inTitle = mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + 12);
            if (inTitle) {
                this.showContextMenu = true;
                this.contextMenuX = (int)mouseX;
                this.contextMenuY = (int)mouseY;
                return true;
            }
        }
        if (button == 0 && this.showContextMenu) {
            if (this.handleContextMenuClick(mouseX, mouseY)) {
                return true;
            }
            this.showContextMenu = false;
        }
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TRASH_BIN) && mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight)) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
        }
        if (!this.isUnlocked()) {
            boolean handled = super.mouseClicked(mouseX, mouseY, button);
            if (handled) {
                return true;
            }
            int lx = this.getX();
            int ly = this.getY();
            int lwidth = 36;
            int lheight = 36;
            return mouseX >= (double)lx && mouseX <= (double)(lx + lwidth) && mouseY >= (double)ly && mouseY <= (double)(ly + lheight);
        }
        x = this.getX();
        y = this.getY();
        currentWidth = 36;
        currentHeight = 36;
        if (mouseX < (double)x || mouseX > (double)(x + currentWidth) || mouseY < (double)y || mouseY > (double)(y + currentHeight)) {
            return false;
        }
        int trashX = x + currentWidth - 16 - 4;
        int trashY = y + 2;
        if (mouseX >= (double)trashX && mouseX <= (double)(trashX + 8) && mouseY >= (double)trashY && mouseY <= (double)(trashY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.TRASH_BIN_ENABLED.get();
            OverlayConfig.TRASH_BIN_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception lwidth) {
                // empty catch block
            }
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
            return true;
        }
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        if (mouseX >= (double)pinX && mouseX <= (double)(pinX + 8) && mouseY >= (double)pinY && mouseY <= (double)(pinY + 8)) {
            this.togglePin();
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
            return true;
        }
        int titleBarEndX = x + currentWidth - 16 - 6;
        if (mouseX >= (double)x && mouseX <= (double)titleBarEndX && mouseY >= (double)y && mouseY <= (double)(y + 12) && button == 0) {
            this.startDragging((int)mouseX, (int)mouseY);
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
            return true;
        }
        int contentY = y + 12;
        int contentHeight = 24;
        if (mouseX >= (double)x && mouseX <= (double)(x + 36) && mouseY >= (double)contentY && mouseY <= (double)(contentY + contentHeight)) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.gameMode != null) {
                if (button == 0) {
                    if (Screen.hasShiftDown() && !this.heldItem.isEmpty()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.TRASH_BIN, MoveItemToShellPacket.SlotType.HELD_ITEM), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
                        return true;
                    }
                    ItemStack carried = mc.player.containerMenu.getCarried();
                    if (!carried.isEmpty()) {
                        this.handleLeftClick(carried);
                        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
                        return true;
                    }
                    if (!this.heldItem.isEmpty()) {
                        this.handleLeftClickRetrieve();
                        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
                        return true;
                    }
                } else if (button == 1 && !this.heldItem.isEmpty()) {
                    this.handleRightClick();
                    OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
                    return true;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TRASH_BIN) && !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (!this.isUnlocked()) {
            boolean handled = super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
            if (handled) {
                return true;
            }
            int x = this.getX();
            int y = this.getY();
            int currentWidth = 36;
            int currentHeight = 36;
            return mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
        }
        if (this.isDragging && button == 0) {
            this.setPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int currentWidth = 36;
        int currentHeight = 36;
        return mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TRASH_BIN) && !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (!this.isUnlocked()) {
            boolean handled = super.mouseReleased(mouseX, mouseY, button);
            if (handled) {
                return true;
            }
            int x = this.getX();
            int y = this.getY();
            int currentWidth = 36;
            int currentHeight = 36;
            return mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
        }
        if (this.isDragging && button == 0) {
            this.stopDragging();
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int currentWidth = 36;
        int currentHeight = 36;
        return mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TRASH_BIN) && !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (!this.isUnlocked()) {
            boolean handled = super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
            if (handled) {
                return true;
            }
            int x = this.getX();
            int y = this.getY();
            int currentWidth = 36;
            int currentHeight = 36;
            return mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
        }
        int x = this.getX();
        int y = this.getY();
        int currentWidth = 36;
        int currentHeight = 36;
        return mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isUnlocked()) {
            if (this.isHovered() && keyCode == 81) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.isHovered() && keyCode == 81) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void handleLeftClick(ItemStack carried) {
        if (this.heldItem.isEmpty()) {
            this.setHeldItem(carried.copy());
            PacketDistributor.sendToServer((CustomPacketPayload)new TrashItemPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.waitingForServerSync = true;
            this.expectedServerItem = carried.copy();
        } else if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)this.heldItem)) {
            int carriedCount;
            int maxStackSize = this.heldItem.getMaxStackSize();
            int currentCount = this.heldItem.getCount();
            int totalCount = currentCount + (carriedCount = carried.getCount());
            if (totalCount <= maxStackSize) {
                this.heldItem.setCount(totalCount);
                PacketDistributor.sendToServer((CustomPacketPayload)new TrashItemPacket(this.heldItem.copy(), maxStackSize), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.waitingForServerSync = true;
                this.expectedServerItem = this.heldItem.copy();
            } else {
                this.heldItem.setCount(maxStackSize);
                PacketDistributor.sendToServer((CustomPacketPayload)new TrashItemPacket(this.heldItem.copy(), maxStackSize), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.waitingForServerSync = true;
                this.expectedServerItem = this.heldItem.copy();
            }
        } else {
            this.setHeldItem(carried.copy());
            PacketDistributor.sendToServer((CustomPacketPayload)new TrashItemPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.waitingForServerSync = true;
            this.expectedServerItem = carried.copy();
        }
        this.deleteTimer = 0;
        this.isDeleting = false;
    }

    private void handleLeftClickRetrieve() {
        PacketDistributor.sendToServer((CustomPacketPayload)new RetrieveFromTrashPacket(this.heldItem.copy(), this.heldItem.getCount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.clearHeldItem();
        this.waitingForServerSync = true;
        this.expectedServerItem = ItemStack.EMPTY;
    }

    private void handleRightClick() {
        Minecraft mc = Minecraft.getInstance();
        ItemStack currentCarried = mc.player.containerMenu.getCarried();
        if (currentCarried.isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RetrieveFromTrashPacket(this.heldItem.copy(), this.heldItem.getCount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.clearHeldItem();
            this.waitingForServerSync = true;
            this.expectedServerItem = ItemStack.EMPTY;
        } else if (ItemStack.isSameItemSameComponents((ItemStack)currentCarried, (ItemStack)this.heldItem)) {
            int trashCount;
            int maxStackSize = currentCarried.getMaxStackSize();
            int currentCount = currentCarried.getCount();
            int totalCount = currentCount + (trashCount = this.heldItem.getCount());
            if (totalCount <= maxStackSize) {
                PacketDistributor.sendToServer((CustomPacketPayload)new RetrieveFromTrashPacket(this.heldItem.copy(), trashCount), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.clearHeldItem();
                this.waitingForServerSync = true;
                this.expectedServerItem = ItemStack.EMPTY;
            } else {
                int amountToTake = maxStackSize - currentCount;
                PacketDistributor.sendToServer((CustomPacketPayload)new RetrieveFromTrashPacket(this.heldItem.copy(), amountToTake), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.heldItem.setCount(trashCount - amountToTake);
                this.waitingForServerSync = true;
                this.expectedServerItem = this.heldItem.copy();
            }
        }
    }

    @Override
    public void onHoverStateChanged(boolean hovered) {
        int x = this.getX();
        int y = this.getY();
        int contentY = y + 12;
        int contentHeight = 24;
        Minecraft mc = Minecraft.getInstance();
        if (mc.mouseHandler != null) {
            double mouseX = mc.mouseHandler.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth();
            double mouseY = mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
            boolean hoveringContent = mouseX >= (double)x && mouseX <= (double)(x + 36) && mouseY >= (double)contentY && mouseY <= (double)(contentY + contentHeight);
            this.isHovering = hovered && hoveringContent;
        } else {
            this.isHovering = false;
        }
        if (!this.isHovering) {
            this.deleteTimer = 0;
            this.isDeleting = false;
        }
    }

    public void setHeldItem(ItemStack item) {
        this.heldItem = item.copy();
        this.deleteTimer = 0;
        this.isDeleting = false;
    }

    @Override
    protected void stopDragging() {
        super.stopDragging();
        this.savePositionToConfig();
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRASH_BIN);
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    private void deleteItem() {
        if (!this.heldItem.isEmpty()) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.LAVA_EXTINGUISH, (float)1.0f, (float)1.5f));
            PacketDistributor.sendToServer((CustomPacketPayload)new ClearTrashPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.heldItem = ItemStack.EMPTY;
            this.deleteTimer = 0;
            this.isDeleting = false;
            this.waitingForServerSync = true;
            this.expectedServerItem = ItemStack.EMPTY;
        }
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public boolean hasHeldItem() {
        return !this.heldItem.isEmpty();
    }

    public void clearHeldItem() {
        this.heldItem = ItemStack.EMPTY;
        this.deleteTimer = 0;
        this.isDeleting = false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int x = this.getX();
        int y = this.getY();
        int currentWidth = 36;
        int currentHeight = 36;
        return mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight);
    }

    public boolean isMouseOverContent(double mouseX, double mouseY) {
        int x = this.getX();
        int y = this.getY();
        int contentY = y + 12;
        int contentHeight = 24;
        return mouseX >= (double)x && mouseX <= (double)(x + 36) && mouseY >= (double)contentY && mouseY <= (double)(contentY + contentHeight);
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int trashX = x + currentWidth - 16 - 4;
        int trashY = y + 2;
        boolean trashHovered = mouseX >= trashX && mouseX <= trashX + 8 && mouseY >= trashY && mouseY <= trashY + 8;
        boolean trashEnabled = (Boolean)OverlayConfig.TRASH_BIN_ENABLED.get();
        int n = buttonColor = trashEnabled ? -11751600 : -769226;
        if (trashHovered) {
            buttonColor = trashEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(trashX, trashY, trashX + 8, trashY + 8, buttonColor);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, pinColor);
        } else {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, pinColor);
        }
        guiGraphics.pose().popPose();
    }

    @Override
    protected void drawWidgetBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
        super.drawWidgetBackground(guiGraphics, currentWidth, currentHeight);
    }
}

