/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.TravelersGardenActionPacket;
import com.etka.nomadsshell.util.ItemStackData;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class TravelersGardenWidget
extends LockableWidget {
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int COLLAPSED_WIDTH = 140;
    private static final int COLLAPSED_HEIGHT = 60;
    private static final int EXPANDED_WIDTH = 200;
    private static final int EXPANDED_HEIGHT = 130;
    private static final int SLOT_SIZE = 18;
    private static final int GRID_COLS = 5;
    private static final int LABEL_TOP_PADDING = 6;
    private static final int SLOTS_TOP_PADDING = 2;
    private boolean consumeNextRelease = false;
    private boolean logoMode = false;
    private static final int DRAIN_BUTTON_SIZE = 12;
    private int[] cropClickCounters = new int[20];
    private long[] lastClickTimes = new long[20];
    private static final long CLICK_RESET_TIME = 2000L;
    private static final int REQUIRED_CLICKS = 3;

    private static int loadPositionX(int defaultX) {
        int cx = (Integer)OverlayConfig.TRAVELERS_GARDEN_X.get();
        return cx != 0 ? cx : defaultX;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean inside;
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.consumeNextRelease) {
            this.consumeNextRelease = false;
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    private static int loadPositionY(int defaultY) {
        int cy = (Integer)OverlayConfig.TRAVELERS_GARDEN_Y.get();
        return cy != 0 ? cy : defaultY;
    }

    private void handleCropRightClick(int slotIndex, boolean hasCrop) {
        if (!hasCrop) {
            this.cropClickCounters[slotIndex] = 0;
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastClickTimes[slotIndex] > 2000L) {
            this.cropClickCounters[slotIndex] = 0;
        }
        int n = slotIndex;
        this.cropClickCounters[n] = this.cropClickCounters[n] + 1;
        this.lastClickTimes[slotIndex] = currentTime;
        if (this.cropClickCounters[slotIndex] >= 3) {
            this.cropClickCounters[slotIndex] = 0;
            TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.REMOVE_PLANT, slotIndex);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void renderClickProgress(GuiGraphics g, int slotX, int slotY, int slotIndex, boolean hasCrop) {
        if (this.cropClickCounters[slotIndex] > 0 && hasCrop) {
            int progressBarY = slotY + 18 + 1;
            int progressBarHeight = 2;
            int progressBarWidth = 18;
            g.pose().pushPose();
            g.pose().translate(0.0f, 0.0f, 20.0f);
            g.fill(slotX, progressBarY, slotX + progressBarWidth, progressBarY + progressBarHeight, Theme.panelBorder());
            float progress = (float)this.cropClickCounters[slotIndex] / 3.0f;
            int fillWidth = (int)((float)progressBarWidth * progress);
            if (fillWidth > 0) {
                g.fill(slotX, progressBarY, slotX + fillWidth, progressBarY + progressBarHeight, -38037);
            }
            g.pose().popPose();
        }
    }

    public TravelersGardenWidget(int x, int y, Font font, IShellMenu menu) {
        super(TravelersGardenWidget.loadPositionX(x), TravelersGardenWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.travelers_garden"), font, WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, menu);
        this.canExpand = true;
        this.isPinned = (Boolean)OverlayConfig.TRAVELERS_GARDEN_PINNED.get();
        this.isExpanded = (Boolean)OverlayConfig.TRAVELERS_GARDEN_EXPANDED.get();
        this.updateDimensions();
    }

    private void updateDimensions() {
        if (this.isExpanded) {
            this.width = 200;
            this.height = 130;
        } else {
            this.width = 140;
            this.height = 60;
        }
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int gardenX = x + currentWidth - 24 - 6;
        int gardenY = y + 2;
        boolean gardenHovered = mouseX >= gardenX && mouseX <= gardenX + 8 && mouseY >= gardenY && mouseY <= gardenY + 8;
        boolean gardenEnabled = (Boolean)OverlayConfig.TRAVELERS_GARDEN_ENABLED.get();
        int n = buttonColor = gardenEnabled ? -11751600 : -769226;
        if (gardenHovered) {
            buttonColor = gardenEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(gardenX, gardenY, gardenX + 8, gardenY + 8, buttonColor);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            c = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, c);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, c);
        } else {
            c = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, c);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, c);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, c);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, c);
        }
        int expandX = x + currentWidth - 8 - 2 - 8 - 2;
        int expandY = y + 2;
        boolean expandHovered = mouseX >= expandX && mouseX <= expandX + 8 && mouseY >= expandY && mouseY <= expandY + 8;
        guiGraphics.fill(expandX, expandY, expandX + 8, expandY + 8, Theme.buttonBg(expandHovered));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)expandX, (float)expandY, 0.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        try {
            ResourceLocation icon = Theme.icon(this.isExpanded ? "collapse" : "expand");
            guiGraphics.blit(icon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Throwable t) {
            guiGraphics.pose().popPose();
            if (this.isExpanded) {
                guiGraphics.fill(expandX + 2, expandY + 2, expandX + 6, expandY + 2, -1);
                guiGraphics.fill(expandX + 3, expandY + 1, expandX + 5, expandY + 1, -1);
                guiGraphics.fill(expandX + 4, expandY, expandX + 4, expandY, -1);
            } else {
                guiGraphics.fill(expandX + 2, expandY + 5, expandX + 6, expandY + 5, -1);
                guiGraphics.fill(expandX + 3, expandY + 6, expandX + 5, expandY + 6, -1);
                guiGraphics.fill(expandX + 4, expandY + 7, expandX + 4, expandY + 7, -1);
            }
            return;
        }
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.TRAVELERS_GARDEN_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.TRAVELERS_GARDEN_USE_IMAGE_MODE.get();
        OverlayConfig.TRAVELERS_GARDEN_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    @Override
    protected void toggleExpansion() {
        super.toggleExpansion();
        this.updateDimensions();
        this.saveExpansionStateToConfig();
    }

    private void savePinStateToConfig() {
        try {
            OverlayConfig.TRAVELERS_GARDEN_PINNED.set((Object)this.isPinned);
            OverlayConfig.TRAVELERS_GARDEN_X.set((Object)this.getX());
            OverlayConfig.TRAVELERS_GARDEN_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveExpansionStateToConfig() {
        try {
            OverlayConfig.TRAVELERS_GARDEN_EXPANDED.set((Object)this.isExpanded);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void renderExpandedContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        boolean hoveredWidget;
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x, y + 12 - 1, x + w, y + 12, Theme.titleBarBorder());
        this.renderControlButtons(g, mouseX, mouseY, w, h);
        int contentX = x + 4;
        int contentY = y + 12 + 1;
        int contentH = h - 12 - 2;
        g.fill(x, contentY, x + w, contentY + contentH, Theme.panelBg());
        boolean imageEnabled = (Boolean)OverlayConfig.TRAVELERS_GARDEN_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, contentY, w, contentH);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            g.drawString(this.font, Component.translatable((String)"nomadsshell.garden.wear_shell").getString(), contentX + 4, contentY + 6, Theme.textOnPanel());
            return;
        }
        if (this.isExpanded) {
            this.renderExpandedView(g, mouseX, mouseY, partialTick, shell, contentX, contentY, w, h);
        } else {
            this.renderCollapsedView(g, mouseX, mouseY, partialTick, shell, contentX, contentY, w, h);
        }
    }

    private void renderCollapsedView(GuiGraphics g, int mouseX, int mouseY, float partialTick, ItemStack shell, int contentX, int contentY, int w, int h) {
        int harvestSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
        List bufferData = (List)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList());
        int cols = 3;
        int rows = 2;
        int maxSlots = cols * rows;
        int gridWidth = cols * 18 + (cols - 1) * 4;
        int gridHeight = rows * 18 + (rows - 1) * 4;
        int collectBtnW = 48;
        int spacing = 8;
        int gridX = contentX + 4;
        int gridY = contentY + 4;
        for (int i = 0; i < Math.min(harvestSlots, maxSlots); ++i) {
            ItemStack st;
            int col = i % cols;
            int row = i / cols;
            int sx = gridX + col * 22;
            int sy = gridY + row * 22;
            this.drawSlot(g, sx, sy, mouseX, mouseY);
            if (i >= bufferData.size() || (st = ((ItemStackData)bufferData.get(i)).toItemStack()).isEmpty()) continue;
            g.renderItem(st, sx + 1, sy + 1);
            g.renderItemDecorations(this.font, st, sx + 1, sy + 1);
        }
        int btnH = 12;
        int collectBtnX = gridX + gridWidth + spacing;
        int collectBtnY = gridY + (gridHeight - btnH) / 2;
        g.fill(collectBtnX, collectBtnY, collectBtnX + collectBtnW, collectBtnY + btnH, Theme.buttonBg(mouseX >= collectBtnX && mouseX <= collectBtnX + collectBtnW && mouseY >= collectBtnY && mouseY <= collectBtnY + btnH));
        g.drawString(this.font, Component.translatable((String)"nomadsshell.garden.collect").getString(), collectBtnX + 4, collectBtnY + 2, Theme.textOnPanel());
    }

    private void renderExpandedView(GuiGraphics g, int mouseX, int mouseY, float partialTick, ItemStack shell, int contentX, int contentY, int w, int h) {
        int sy;
        int sx;
        int row;
        int col;
        int i;
        int x = this.getX();
        int y = this.getY();
        int maxPlants = (Integer)shell.getOrDefault(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
        int harvestSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
        List plants = (List)shell.getOrDefault(ModDataComponents.TG_PLANTS.get(), new ArrayList());
        List bufferData = (List)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList());
        Objects.requireNonNull(this.font);
        int gridTop = contentY + 6 + 9 + 2;
        int gridLeft = contentX + 6;
        int gridCols = 5;
        int gridRows = 4;
        int sidebarPadding = 16;
        int physicalRightmostSlotLeftX = x + w - sidebarPadding - 18;
        int cols = harvestSlots >= 5 ? 2 : 1;
        int baseHarvestX = cols == 1 ? physicalRightmostSlotLeftX - 9 - 2 : physicalRightmostSlotLeftX - 22;
        int sidebarTop = gridTop;
        g.drawString(this.font, Component.translatable((String)"nomadsshell.garden.crops").getString(), gridLeft, contentY + 6, Theme.textOnPanel());
        for (i = 0; i < maxPlants; ++i) {
            CompoundTag tag;
            col = i % gridCols;
            row = i / gridCols;
            sx = gridLeft + col * 22;
            sy = gridTop + row * 24;
            this.drawSlot(g, sx, sy, mouseX, mouseY);
            boolean hasCrop = i < plants.size() && ((CompoundTag)plants.get(i)).contains("cropId");
            this.renderClickProgress(g, sx, sy, i, hasCrop);
            CompoundTag compoundTag = tag = i < plants.size() ? (CompoundTag)plants.get(i) : null;
            if (tag != null && tag.contains("cropId")) {
                Item item;
                String cropId = tag.getString("cropId");
                ResourceLocation rl = ResourceLocation.tryParse((String)cropId);
                if (rl != null && (item = (Item)BuiltInRegistries.ITEM.get(rl)) != null && item != Items.AIR) {
                    g.renderItem(new ItemStack((ItemLike)item), sx + 1, sy + 1);
                }
                int progress = tag.getInt("progress");
                int target = 14880;
                try {
                    Class<?> configClass = Class.forName("com.etka.travelersgarden.Config");
                    Method calculateGrowthTimeMethod = configClass.getMethod("calculateGrowthTime", String.class);
                    target = (Integer)calculateGrowthTimeMethod.invoke(null, cropId);
                }
                catch (Exception configClass) {
                    // empty catch block
                }
                int speedBonus = (Integer)shell.getOrDefault(ModDataComponents.TG_SPEED_BONUS.get(), (Object)0);
                double multiplier = Math.max(0.1, 1.0 - (double)speedBonus / 100.0);
                int effectiveTarget = Math.max(20, (int)Math.round((double)target * multiplier));
                float progressPercent = Math.min(1.0f, (float)progress / (float)effectiveTarget);
                int barWidth = (int)(18.0f * progressPercent);
                int by = sy + 18;
                g.pose().pushPose();
                g.pose().translate(0.0f, 0.0f, 10.0f);
                g.fill(sx, by, sx + 18, by + 2, Theme.panelBorder());
                if (barWidth > 0) {
                    g.fill(sx, by, sx + barWidth, by + 2, -9715879);
                } else if (progress > 0) {
                    g.fill(sx, by, sx + 1, by + 2, -9715879);
                }
                g.pose().popPose();
                continue;
            }
            if (!TravelersGardenWidget.inside(sx, sy, 18, 18, mouseX, mouseY)) continue;
            this.drawTooltip(g, "Place a valid seed here", mouseX, mouseY);
        }
        for (i = 0; i < harvestSlots; ++i) {
            ItemStack st;
            col = cols == 2 ? i % 2 : 0;
            row = cols == 2 ? i / 2 : i;
            sx = baseHarvestX + col * 22;
            sy = sidebarTop + row * 22;
            this.drawSlot(g, sx, sy, mouseX, mouseY);
            if (i >= bufferData.size() || (st = ((ItemStackData)bufferData.get(i)).toItemStack()).isEmpty()) continue;
            g.renderItem(st, sx + 1, sy + 1);
            g.renderItemDecorations(this.font, st, sx + 1, sy + 1);
        }
        int harvestAreaBottomY = sidebarTop + ((int)Math.ceil((double)harvestSlots / (double)cols) - 1) * 22 + 18;
        g.drawString(this.font, Component.translatable((String)"nomadsshell.garden.harvests").getString(), baseHarvestX, contentY + 6, Theme.textOnPanel());
        int harvestAreaWidth = cols == 2 ? 40 : 18;
        int harvestAreaMidX = baseHarvestX + harvestAreaWidth / 2;
        int takeAllBtnW = 48;
        int btnH = 12;
        int autoPushBtnW = 12;
        int autoPushBtnH = 12;
        int takeAllBtnX = harvestAreaMidX - (takeAllBtnW + 4 + autoPushBtnW) / 2;
        int takeAllBtnY = harvestAreaBottomY + 6;
        g.fill(takeAllBtnX, takeAllBtnY, takeAllBtnX + takeAllBtnW, takeAllBtnY + btnH, Theme.buttonBg(mouseX >= takeAllBtnX && mouseX <= takeAllBtnX + takeAllBtnW && mouseY >= takeAllBtnY && mouseY <= takeAllBtnY + btnH));
        g.drawString(this.font, Component.translatable((String)"nomadsshell.garden.take_all").getString(), takeAllBtnX + 4, takeAllBtnY + 2, Theme.textOnPanel());
        int currentTierLevel = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, shell).getLevel();
        if (currentTierLevel >= 3) {
            int autoPushBtnX = takeAllBtnX + takeAllBtnW + 4;
            int autoPushBtnY = takeAllBtnY;
            g.fill(autoPushBtnX, autoPushBtnY, autoPushBtnX + autoPushBtnW, autoPushBtnY + autoPushBtnH, Theme.buttonBg(mouseX >= autoPushBtnX && mouseX <= autoPushBtnX + autoPushBtnW && mouseY >= autoPushBtnY && mouseY <= autoPushBtnY + autoPushBtnH));
            int iconX = autoPushBtnX + 2;
            int iconY = autoPushBtnY + 2;
            int iconW = autoPushBtnW - 4;
            int iconH = autoPushBtnH - 4;
            g.fill(iconX, iconY + iconH / 2 - 1, iconX + 3, iconY + iconH / 2 + 1, Theme.textOnPanel());
            g.fill(iconX + 3, iconY + iconH / 2 - 1, iconX + 5, iconY + iconH / 2 + 1, Theme.textOnPanel());
            g.fill(iconX + 5, iconY, iconX + iconW, iconY + iconH, Theme.panelBorder());
            g.fill(iconX + 6, iconY + 1, iconX + iconW - 1, iconY + iconH - 1, Theme.panelBg());
            if (mouseX >= autoPushBtnX && mouseX <= autoPushBtnX + autoPushBtnW && mouseY >= autoPushBtnY && mouseY <= autoPushBtnY + autoPushBtnH) {
                boolean autoPushEnabled = (Boolean)shell.getOrDefault(ModDataComponents.TG_AUTO_PUSH_ENABLED.get(), (Object)false);
                String tooltipText = autoPushEnabled ? "Auto Push: ON" : "Auto Push: OFF";
                this.drawTooltip(g, tooltipText, mouseX, mouseY);
            }
        } else if (mouseX >= takeAllBtnX + takeAllBtnW + 4 && mouseX <= takeAllBtnX + takeAllBtnW + 4 + 12 && mouseY >= takeAllBtnY && mouseY <= takeAllBtnY + 12) {
            this.drawTooltip(g, "Auto Push unlocked at Tier 3", mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        int gardenX = x + w - 24 - 6;
        int gardenY = y + 2;
        if (mouseX >= (double)gardenX && mouseX <= (double)(gardenX + 8) && mouseY >= (double)gardenY && mouseY <= (double)(gardenY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.TRAVELERS_GARDEN_ENABLED.get();
            OverlayConfig.TRAVELERS_GARDEN_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (button == 1) {
            ItemStack shellStack;
            if (!inside) {
                return false;
            }
            if (this.isExpanded && !(shellStack = this.getshellStack()).isEmpty()) {
                int maxPlants = (Integer)shellStack.getOrDefault(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
                int contentX = x + 4;
                int contentY = y + 12 + 1;
                int gridLeft = contentX + 6;
                Objects.requireNonNull(this.font);
                int gridTop = contentY + 6 + 9 + 2;
                int gridCols = 5;
                int gridRows = 4;
                int gridWidth = gridCols * 18 + (gridCols - 1) * 4;
                int gridHeight = gridRows * 18 + (gridRows - 1) * 6;
                if (mouseX >= (double)gridLeft && mouseX <= (double)(gridLeft + gridWidth) && mouseY >= (double)gridTop && mouseY <= (double)(gridTop + gridHeight)) {
                    int relX = (int)(mouseX - (double)gridLeft);
                    int relY = (int)(mouseY - (double)gridTop);
                    int col = Math.min(gridCols - 1, Math.max(0, relX / 22));
                    int row = Math.min(gridRows - 1, Math.max(0, relY / 22));
                    int slot = row * gridCols + col;
                    if (slot >= 0 && slot < maxPlants) {
                        List plants = (List)shellStack.getOrDefault(ModDataComponents.TG_PLANTS.get(), new ArrayList());
                        boolean hasCrop = slot < plants.size() && ((CompoundTag)plants.get(slot)).contains("cropId");
                        this.handleCropRightClick(slot, hasCrop);
                        return true;
                    }
                }
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN);
        this.logoMode = false;
        ItemStack shellStack = this.getshellStack();
        if (shellStack.isEmpty()) {
            return true;
        }
        if (!this.isExpanded) {
            return this.handleCollapsedViewClicks(mouseX, mouseY, button, shellStack);
        }
        return this.handleExpandedViewClicks(mouseX, mouseY, button, shellStack);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private boolean handleCollapsedViewClicks(double mouseX, double mouseY, int button, ItemStack shell) {
        if (button != 0) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12)) {
            int expandX = x + w - 8 - 2 - 8 - 2;
            int expandY = y + 2;
            if (mouseX >= (double)expandX && mouseX <= (double)(expandX + 8) && mouseY >= (double)expandY && mouseY <= (double)(expandY + 8)) {
                this.toggleExpansion();
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int contentX = x + 4;
        int contentY = y + 12 + 1;
        int harvestSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
        List bufferData = (List)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList());
        int cols = 3;
        int rows = 2;
        int maxSlots = cols * rows;
        int gridWidth = cols * 18 + (cols - 1) * 4;
        int gridHeight = rows * 18 + (rows - 1) * 4;
        int collectBtnW = 48;
        int spacing = 8;
        int gridX = contentX + 4;
        int gridY = contentY + 4;
        int btnH = 12;
        int collectBtnX = gridX + gridWidth + spacing;
        int collectBtnY = gridY + (gridHeight - btnH) / 2;
        if (mouseX >= (double)collectBtnX && mouseX <= (double)(collectBtnX + collectBtnW) && mouseY >= (double)collectBtnY && mouseY <= (double)(collectBtnY + btnH)) {
            TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.TAKE_ALL_BUFFER, -1);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        int slotsToShow = Math.min(harvestSlots, maxSlots);
        for (int i = 0; i < slotsToShow; ++i) {
            int col = i % cols;
            int row = i / cols;
            int slotX = gridX + col * 22;
            int slotY = gridY + row * 22;
            if (!(mouseX >= (double)slotX) || !(mouseX <= (double)(slotX + 18)) || !(mouseY >= (double)slotY) || !(mouseY <= (double)(slotY + 18))) continue;
            if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340)) {
                TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.MOVE_BUFFER_TO_BACKPACK, i);
                PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.TAKE_BUFFER_SLOT, i);
                PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return false;
    }

    private boolean handleExpandedViewClicks(double mouseX, double mouseY, int button, ItemStack shell) {
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12)) {
            int expandX = x + w - 8 - 2 - 8 - 2;
            int expandY = y + 2;
            if (mouseX >= (double)expandX && mouseX <= (double)(expandX + 8) && mouseY >= (double)expandY && mouseY <= (double)(expandY + 8)) {
                this.toggleExpansion();
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (button == 0) {
            int maxPlants = (Integer)shell.getOrDefault(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
            int harvestSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
            int contentX = x + 4;
            int contentY = y + 12 + 1;
            int gridLeft = contentX + 6;
            Objects.requireNonNull(this.font);
            int gridTop = contentY + 6 + 9 + 2;
            int gridCols = 5;
            int gridRows = 4;
            int gridWidth = gridCols * 18 + (gridCols - 1) * 4;
            int gridHeight = gridRows * 18 + (gridRows - 1) * 6;
            if (mouseX >= (double)gridLeft && mouseX <= (double)(gridLeft + gridWidth) && mouseY >= (double)gridTop && mouseY <= (double)(gridTop + gridHeight)) {
                int relX = (int)(mouseX - (double)gridLeft);
                int relY = (int)(mouseY - (double)gridTop);
                int col = Math.min(gridCols - 1, Math.max(0, relX / 22));
                int row = Math.min(gridRows - 1, Math.max(0, relY / 22));
                int slot = row * gridCols + col;
                if (slot >= 0 && slot < maxPlants) {
                    if (button == 0) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.PLANT_SLOT, slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        this.consumeNextRelease = true;
                    } else if (button == 1) {
                        List plants = (List)shell.getOrDefault(ModDataComponents.TG_PLANTS.get(), new ArrayList());
                        boolean hasCrop = slot < plants.size() && ((CompoundTag)plants.get(slot)).contains("cropId");
                        this.handleCropRightClick(slot, hasCrop);
                    }
                    return true;
                }
            }
            int sidebarPadding = 16;
            Objects.requireNonNull(this.font);
            int sidebarTop = contentY + 6 + 9 + 2;
            int cols = harvestSlots >= 5 ? 2 : 1;
            int baseHarvestX = cols == 1 ? x + w - sidebarPadding - 18 - 2 : x + w - sidebarPadding - 36 - 4;
            for (int i = 0; i < harvestSlots; ++i) {
                int col = cols == 2 ? i % 2 : 0;
                int row = cols == 2 ? i / 2 : i;
                int sx = baseHarvestX + col * 22;
                int sy = sidebarTop + row * 22;
                if (!(mouseX >= (double)sx) || !(mouseX <= (double)(sx + 18)) || !(mouseY >= (double)sy) || !(mouseY <= (double)(sy + 18))) continue;
                if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340)) {
                    TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.MOVE_BUFFER_TO_BACKPACK, i);
                    PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.TAKE_BUFFER_SLOT, i);
                    PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return true;
            }
            int takeAllBtnW = 48;
            int btnH = 12;
            int harvestAreaWidth = cols == 2 ? 40 : 18;
            int harvestAreaMidX = baseHarvestX + harvestAreaWidth / 2;
            int takeAllBtnX = harvestAreaMidX - (takeAllBtnW + 4 + 12) / 2;
            int harvestAreaBottomY = sidebarTop + ((int)Math.ceil((double)harvestSlots / (double)cols) - 1) * 22 + 18;
            int takeAllBtnY = harvestAreaBottomY + 4;
            if (mouseX >= (double)takeAllBtnX && mouseX <= (double)(takeAllBtnX + takeAllBtnW) && mouseY >= (double)takeAllBtnY && mouseY <= (double)(takeAllBtnY + btnH)) {
                TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.TAKE_ALL_BUFFER, -1);
                PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            int autoPushBtnW = 12;
            int autoPushBtnH = 12;
            int autoPushBtnX = takeAllBtnX + takeAllBtnW + 4;
            int autoPushBtnY = takeAllBtnY;
            if (mouseX >= (double)autoPushBtnX && mouseX <= (double)(autoPushBtnX + autoPushBtnW) && mouseY >= (double)autoPushBtnY && mouseY <= (double)(autoPushBtnY + autoPushBtnH)) {
                TravelersGardenActionPacket packet = new TravelersGardenActionPacket(TravelersGardenActionPacket.Action.TOGGLE_AUTO_PUSH, -1);
                PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return false;
    }

    private void drawSlot(GuiGraphics g, int x, int y, int mx, int my) {
        g.fill(x, y, x + 18, y + 18, Theme.slotFill());
        g.renderOutline(x, y, 18, 18, Theme.slotBorder());
        if (TravelersGardenWidget.inside(x, y, 18, 18, mx, my)) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            g.fill(x, y, x + 18, y + 18, hoverOverlay);
        }
    }

    private static boolean inside(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private String getItemDisplayName(String itemId) {
        try {
            Item item;
            ResourceLocation rl = ResourceLocation.tryParse((String)itemId);
            if (rl != null && (item = (Item)BuiltInRegistries.ITEM.get(rl)) != null && item != Items.AIR) {
                return item.getDescription().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemId;
    }

    private int estimateTargetTicks(String cropId, ItemStack shell) {
        int target = 14880;
        try {
            Class<?> configClass = Class.forName("com.etka.travelersgarden.Config");
            Method calculateGrowthTimeMethod = configClass.getMethod("calculateGrowthTime", String.class);
            target = (Integer)calculateGrowthTimeMethod.invoke(null, cropId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return target;
    }

    private void drawTooltip(GuiGraphics g, String text, int x, int y) {
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 100.0f);
        int w = this.font.width(text) + 6;
        int bx = x + 8;
        int by = y - 12;
        g.fill(bx, by, bx + w, by + 12, Theme.overlayDim());
        g.renderOutline(bx, by, w, 12, Theme.slotBorder());
        g.drawString(this.font, text, bx + 3, by + 2, -1, false);
        pose.popPose();
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int contentY, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = contentY + (currentHeight - iconSize) / 2;
        guiGraphics.blit(Theme.icon("tgarden"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }
}

