/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;

public class UpgradeDefinitions {
    private static final Map<String, UpgradeNode> NODES = new HashMap<String, UpgradeNode>();

    private static void initializeAllNodes() {
        UpgradeDefinitions.register(new UpgradeNode("start", "nomadsshell.upgrade.start.title", "nomadsshell.upgrade.start.desc", 0, 0, Arrays.asList("furnace_unlock", "collector_unlock", "dripstone_1", "crafting_2x2", "fluid_unlock", "teleporter_unlock", "guardian_leather", "travelers_garden_1"), Collections.emptyList(), new ItemStack((ItemLike)Items.ENDER_CHEST), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_unlock", "nomadsshell.upgrade.furnace.title", "nomadsshell.upgrade.furnace.desc", 6, 0, Arrays.asList("furnace_tier2"), Arrays.asList(new ItemStack((ItemLike)Items.FURNACE, 1)), "minecraft:stone_tool_materials", 8, new ItemStack((ItemLike)Items.FURNACE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_tier2", "nomadsshell.upgrade.furnace_tier2.title", "nomadsshell.upgrade.furnace_tier2.desc", 9, 0, Arrays.asList("furnace_smelt_speed_1", "furnace_template_1"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.BLAST_FURNACE, 1), new ItemStack((ItemLike)Items.COAL, 16)), new ItemStack((ItemLike)Items.BLAST_FURNACE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_smelt_speed_1", "nomadsshell.upgrade.furnace_smelt_speed_1.title", "nomadsshell.upgrade.furnace_smelt_speed_1.desc", 12, -1, Arrays.asList("furnace_fuel_eff_1"), Arrays.asList(new ItemStack((ItemLike)Items.GOLD_INGOT, 4), new ItemStack((ItemLike)Items.IRON_INGOT, 2), new ItemStack((ItemLike)Items.REDSTONE, 4)), new ItemStack((ItemLike)Items.COAL), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_fuel_eff_1", "nomadsshell.upgrade.furnace_fuel_eff_1.title", "nomadsshell.upgrade.furnace_fuel_eff_1.desc", 15, -1, Arrays.asList("furnace_smelt_speed_2"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.COAL_BLOCK, 2)), new ItemStack((ItemLike)Items.LAVA_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_smelt_speed_2", "nomadsshell.upgrade.furnace_smelt_speed_2.title", "nomadsshell.upgrade.furnace_smelt_speed_2.desc", 18, -1, Arrays.asList("furnace_fuel_eff_2"), Arrays.asList(new ItemStack((ItemLike)Items.GOLD_INGOT, 4), new ItemStack((ItemLike)Items.IRON_INGOT, 2), new ItemStack((ItemLike)Items.REDSTONE, 8)), new ItemStack((ItemLike)Items.COAL_BLOCK), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_fuel_eff_2", "nomadsshell.upgrade.furnace_fuel_eff_2.title", "nomadsshell.upgrade.furnace_fuel_eff_2.desc", 21, -1, Arrays.asList("furnace_smelt_speed_3"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.LAVA_BUCKET, 1)), new ItemStack((ItemLike)Items.BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_smelt_speed_3", "nomadsshell.upgrade.furnace_smelt_speed_3.title", "nomadsshell.upgrade.furnace_smelt_speed_3.desc", 24, -1, Arrays.asList("furnace_fuel_eff_3"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.COAL_BLOCK, 2), new ItemStack((ItemLike)Items.GOLD_INGOT, 4)), new ItemStack((ItemLike)Items.BLAZE_POWDER), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_fuel_eff_3", "nomadsshell.upgrade.furnace_fuel_eff_3.title", "nomadsshell.upgrade.furnace_fuel_eff_3.desc", 27, -1, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.COAL_BLOCK, 4), new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.BLAZE_POWDER, 4)), new ItemStack((ItemLike)Items.MAGMA_BLOCK), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_template_1", "nomadsshell.upgrade.furnace_template_1.title", "nomadsshell.upgrade.furnace_template_1.desc", 12, 1, Arrays.asList("furnace_template_2"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 4), new ItemStack((ItemLike)Items.PAPER, 8)), new ItemStack((ItemLike)Items.PAPER), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_template_2", "nomadsshell.upgrade.furnace_template_2.title", "nomadsshell.upgrade.furnace_template_2.desc", 15, 1, Arrays.asList("furnace_template_3"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 6), new ItemStack((ItemLike)Items.PAPER, 12)), new ItemStack((ItemLike)Items.PAPER), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_template_3", "nomadsshell.upgrade.furnace_template_3.title", "nomadsshell.upgrade.furnace_template_3.desc", 18, 1, Arrays.asList("furnace_template_4"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.PAPER, 16), new ItemStack((ItemLike)Items.GOLD_INGOT, 2)), new ItemStack((ItemLike)Items.PAPER), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_template_4", "nomadsshell.upgrade.furnace_template_4.title", "nomadsshell.upgrade.furnace_template_4.desc", 21, 1, Arrays.asList("furnace_tag_puller"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 10), new ItemStack((ItemLike)Items.PAPER, 24), new ItemStack((ItemLike)Items.GOLD_INGOT, 4)), new ItemStack((ItemLike)Items.PAPER), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("furnace_tag_puller", "nomadsshell.upgrade.furnace_tag_puller.title", "nomadsshell.upgrade.furnace_tag_puller.desc", 24, 1, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.NAME_TAG, 4), new ItemStack((ItemLike)Items.GOLD_INGOT, 8), new ItemStack((ItemLike)Items.REDSTONE, 8)), new ItemStack((ItemLike)Items.NAME_TAG), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("collector_unlock", "nomadsshell.upgrade.collector.title", "nomadsshell.upgrade.collector.desc", 0, 6, Arrays.asList("magnet_unlock"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.CHEST, 4), new ItemStack((ItemLike)Items.HOPPER, 2)), new ItemStack((ItemLike)Items.CHEST), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("magnet_unlock", "nomadsshell.upgrade.magnet.title", "nomadsshell.upgrade.magnet.desc", 0, 8, Arrays.asList("collector_tier2"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.ENDER_PEARL, 4), new ItemStack((ItemLike)Items.REDSTONE, 8)), new ItemStack((ItemLike)Items.LODESTONE), WidgetUnlockSystem.WidgetType.MAGNET, WidgetUnlockSystem.WidgetTier.TIER_I, true, true));
        UpgradeDefinitions.register(new UpgradeNode("collector_tier2", "nomadsshell.upgrade.collector_tier2.title", "nomadsshell.upgrade.collector_tier2.desc", 0, 10, Arrays.asList("feeder_unlock"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.GOLD_INGOT, 8), new ItemStack((ItemLike)Items.HOPPER, 4)), new ItemStack((ItemLike)Items.BARREL), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("feeder_unlock", "nomadsshell.upgrade.feeder.title", "nomadsshell.upgrade.feeder.desc", 0, 12, Arrays.asList("compass_unlock"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.GOLDEN_APPLE, 1), new ItemStack((ItemLike)Items.GOLDEN_CARROT, 4)), new ItemStack((ItemLike)Items.GOLDEN_APPLE), WidgetUnlockSystem.WidgetType.AUTO_FEEDER, WidgetUnlockSystem.WidgetTier.TIER_I, true, true));
        UpgradeDefinitions.register(new UpgradeNode("compass_unlock", "nomadsshell.upgrade.compass.title", "nomadsshell.upgrade.compass.desc", 0, 14, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.COMPASS, 1), new ItemStack((ItemLike)Items.REDSTONE, 4)), new ItemStack((ItemLike)Items.COMPASS), WidgetUnlockSystem.WidgetType.COMPASS, WidgetUnlockSystem.WidgetTier.TIER_I, true, true));
        UpgradeDefinitions.register(new UpgradeNode("dripstone_1", "nomadsshell.upgrade.dripstone_1.title", "nomadsshell.upgrade.dripstone_1.desc", -3, 6, Arrays.asList("dripstone_2"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.CAULDRON, 2), new ItemStack((ItemLike)Items.POINTED_DRIPSTONE, 1), new ItemStack((ItemLike)Items.DRIPSTONE_BLOCK, 1)), new ItemStack((ItemLike)Items.CAULDRON), WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, WidgetUnlockSystem.WidgetTier.TIER_I, true, true));
        UpgradeDefinitions.register(new UpgradeNode("dripstone_2", "nomadsshell.upgrade.dripstone_2.title", "nomadsshell.upgrade.dripstone_2.desc", -3, 8, Arrays.asList("dripstone_3"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 10), new ItemStack((ItemLike)Items.CAULDRON, 3), new ItemStack((ItemLike)Items.POINTED_DRIPSTONE, 3), new ItemStack((ItemLike)Items.DRIPSTONE_BLOCK, 3)), new ItemStack((ItemLike)Items.CAULDRON), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("dripstone_3", "nomadsshell.upgrade.dripstone_3.title", "nomadsshell.upgrade.dripstone_3.desc", -3, 10, Arrays.asList("dripstone_auto_transfer"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.CAULDRON, 4), new ItemStack((ItemLike)Items.POINTED_DRIPSTONE, 4), new ItemStack((ItemLike)Items.DRIPSTONE_BLOCK, 4)), new ItemStack((ItemLike)Items.CAULDRON), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("dripstone_auto_transfer", "nomadsshell.upgrade.dripstone_auto_transfer.title", "nomadsshell.upgrade.dripstone_auto_transfer.desc", -3, 12, Arrays.asList("dripstone_4"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.HOPPER, 4), new ItemStack((ItemLike)Items.REDSTONE, 8)), new ItemStack((ItemLike)Items.HOPPER), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("dripstone_4", "nomadsshell.upgrade.dripstone_4.title", "nomadsshell.upgrade.dripstone_4.desc", -3, 14, Arrays.asList("dripstone_5"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 18), new ItemStack((ItemLike)Items.CAULDRON, 6), new ItemStack((ItemLike)Items.POINTED_DRIPSTONE, 5), new ItemStack((ItemLike)Items.DRIPSTONE_BLOCK, 5), new ItemStack((ItemLike)Items.GOLD_INGOT, 4)), new ItemStack((ItemLike)Items.CAULDRON), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("dripstone_5", "nomadsshell.upgrade.dripstone_5.title", "nomadsshell.upgrade.dripstone_5.desc", -3, 16, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 24), new ItemStack((ItemLike)Items.CAULDRON, 8), new ItemStack((ItemLike)Items.POINTED_DRIPSTONE, 8), new ItemStack((ItemLike)Items.DRIPSTONE_BLOCK, 8), new ItemStack((ItemLike)Items.GOLD_INGOT, 8)), new ItemStack((ItemLike)Items.CAULDRON), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("crafting_2x2", "nomadsshell.upgrade.crafting_2x2.title", "nomadsshell.upgrade.crafting_2x2.desc", -6, 0, Arrays.asList("crafting_3x3"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 6), new ItemStack((ItemLike)Items.CRAFTING_TABLE, 1)), new ItemStack((ItemLike)Items.CRAFTING_TABLE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("crafting_3x3", "nomadsshell.upgrade.crafting_3x3.title", "nomadsshell.upgrade.crafting_3x3.desc", -9, 0, Arrays.asList("trash_unlock"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.CRAFTING_TABLE, 2), new ItemStack((ItemLike)Items.GOLD_INGOT, 4)), new ItemStack((ItemLike)Items.CRAFTING_TABLE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("trash_unlock", "nomadsshell.upgrade.trash.title", "nomadsshell.upgrade.trash.desc", -12, 0, Arrays.asList("auto_crafter_unlock"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.LAVA_BUCKET, 4)), new ItemStack((ItemLike)Items.LAVA_BUCKET), WidgetUnlockSystem.WidgetType.TRASH_BIN, WidgetUnlockSystem.WidgetTier.TIER_I, true, true));
        UpgradeDefinitions.register(new UpgradeNode("auto_crafter_unlock", "nomadsshell.upgrade.auto_crafter.title", "nomadsshell.upgrade.auto_crafter.desc", -15, 0, Arrays.asList("anvil_unlock"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.REDSTONE, 12), new ItemStack((ItemLike)Items.CRAFTING_TABLE, 1), new ItemStack((ItemLike)Items.CRAFTER, 1)), new ItemStack((ItemLike)Items.REDSTONE_TORCH), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("anvil_unlock", "nomadsshell.upgrade.anvil.title", "nomadsshell.upgrade.anvil.desc", -18, 0, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 20), new ItemStack((ItemLike)Items.ANVIL, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 4)), new ItemStack((ItemLike)Items.ANVIL), WidgetUnlockSystem.WidgetType.ANVIL, WidgetUnlockSystem.WidgetTier.TIER_I, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_unlock", "nomadsshell.upgrade.fluid.title", "nomadsshell.upgrade.fluid.desc", -3, -6, Arrays.asList("fluid_tier2"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 6), new ItemStack((ItemLike)Items.BUCKET, 2), new ItemStack((ItemLike)Items.GLASS, 4)), new ItemStack((ItemLike)Items.BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_tier2", "nomadsshell.upgrade.fluid_tier2.title", "nomadsshell.upgrade.fluid_tier2.desc", -3, -8, Arrays.asList("fluid_tier3"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.BUCKET, 4), new ItemStack((ItemLike)Items.GLASS, 6)), new ItemStack((ItemLike)Items.WATER_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_tier3", "nomadsshell.upgrade.fluid_tier3.title", "nomadsshell.upgrade.fluid_tier3.desc", -3, -10, Arrays.asList("fluid_tier4"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 10), new ItemStack((ItemLike)Items.BUCKET, 6), new ItemStack((ItemLike)Items.GLASS, 8)), new ItemStack((ItemLike)Items.WATER_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_tier4", "nomadsshell.upgrade.fluid_tier4.title", "nomadsshell.upgrade.fluid_tier4.desc", -3, -12, Arrays.asList("fluid_tier5"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.BUCKET, 8), new ItemStack((ItemLike)Items.GLASS, 12), new ItemStack((ItemLike)Items.GOLD_INGOT, 2)), new ItemStack((ItemLike)Items.WATER_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_tier5", "nomadsshell.upgrade.fluid_tier5.title", "nomadsshell.upgrade.fluid_tier5.desc", -3, -14, Arrays.asList("fluid_tier6"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.BUCKET, 12), new ItemStack((ItemLike)Items.GLASS, 16), new ItemStack((ItemLike)Items.GOLD_INGOT, 4)), new ItemStack((ItemLike)Items.WATER_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_tier6", "nomadsshell.upgrade.fluid_tier6.title", "nomadsshell.upgrade.fluid_tier6.desc", -3, -16, Arrays.asList("fluid_tier7"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 20), new ItemStack((ItemLike)Items.BUCKET, 16), new ItemStack((ItemLike)Items.GLASS, 24), new ItemStack((ItemLike)Items.GOLD_INGOT, 6)), new ItemStack((ItemLike)Items.WATER_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_tier7", "nomadsshell.upgrade.fluid_tier7.title", "nomadsshell.upgrade.fluid_tier7.desc", -3, -18, Arrays.asList("fluid_tier8"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 24), new ItemStack((ItemLike)Items.BUCKET, 24), new ItemStack((ItemLike)Items.GLASS_PANE, 32), new ItemStack((ItemLike)Items.GOLD_INGOT, 8), new ItemStack((ItemLike)Items.DIAMOND, 1)), new ItemStack((ItemLike)Items.WATER_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("fluid_tier8", "nomadsshell.upgrade.fluid_tier8.title", "nomadsshell.upgrade.fluid_tier8.desc", -3, -20, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 32), new ItemStack((ItemLike)Items.GOLD_INGOT, 12), new ItemStack((ItemLike)Items.GLASS_PANE, 32), new ItemStack((ItemLike)Items.DIAMOND, 4)), new ItemStack((ItemLike)Items.WATER_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("teleporter_unlock", "nomadsshell.upgrade.teleporter.title", "nomadsshell.upgrade.teleporter.desc", 0, -6, Arrays.asList("teleporter_nether"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.ENDER_PEARL, 16)), "minecraft:beds", 1, new ItemStack((ItemLike)Items.ENDER_PEARL), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("teleporter_nether", "nomadsshell.upgrade.teleporter_nether.title", "nomadsshell.upgrade.teleporter_nether.desc", 0, -8, Arrays.asList("teleporter_near"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.ENDER_PEARL, 8), new ItemStack((ItemLike)Items.OBSIDIAN, 16)), new ItemStack((ItemLike)Items.OBSIDIAN), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("teleporter_near", "nomadsshell.upgrade.teleporter_near.title", "nomadsshell.upgrade.teleporter_near.desc", 0, -10, Arrays.asList("teleporter_pocket"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 24), new ItemStack((ItemLike)Items.ENDER_PEARL, 12), new ItemStack((ItemLike)Items.DIAMOND, 4)), new ItemStack((ItemLike)Items.CHORUS_FRUIT), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("teleporter_pocket", "nomadsshell.upgrade.teleporter_pocket.title", "nomadsshell.upgrade.teleporter_pocket.desc", 0, -12, Arrays.asList("teleporter_end"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 24), new ItemStack((ItemLike)Items.ENDER_EYE, 4), new ItemStack((ItemLike)Items.GHAST_TEAR, 1)), new ItemStack((ItemLike)Items.ENDER_CHEST), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("teleporter_end", "nomadsshell.upgrade.teleporter_end.title", "nomadsshell.upgrade.teleporter_end.desc", 0, -14, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.ENDER_PEARL, 12), new ItemStack((ItemLike)Items.ENDER_EYE, 12), new ItemStack((ItemLike)Items.CHORUS_FRUIT, 12), new ItemStack((ItemLike)Items.END_STONE, 16)), new ItemStack((ItemLike)Items.END_CRYSTAL), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_leather", "nomadsshell.upgrade.guardian_leather.title", "nomadsshell.upgrade.guardian_leather.desc", 3, -6, Arrays.asList("guardian_gold"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 6), new ItemStack((ItemLike)Items.LEATHER, 8)), new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_gold", "nomadsshell.upgrade.guardian_gold.title", "nomadsshell.upgrade.guardian_gold.desc", 3, -8, Arrays.asList("guardian_iron"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.GOLD_INGOT, 12)), new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_iron", "nomadsshell.upgrade.guardian_iron.title", "nomadsshell.upgrade.guardian_iron.desc", 3, -10, Arrays.asList("guardian_diamond"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.GOLD_INGOT, 4)), new ItemStack((ItemLike)Items.IRON_CHESTPLATE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_diamond", "nomadsshell.upgrade.guardian_diamond.title", "nomadsshell.upgrade.guardian_diamond.desc", 3, -12, Arrays.asList("guardian_netherite"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.DIAMOND, 12), new ItemStack((ItemLike)Items.GOLD_INGOT, 6)), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_netherite", "nomadsshell.upgrade.guardian_netherite.title", "nomadsshell.upgrade.guardian_netherite.desc", 3, -14, Arrays.asList("guardian_light"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 20), new ItemStack((ItemLike)Items.NETHERITE_INGOT, 1), new ItemStack((ItemLike)Items.GOLD_INGOT, 8)), new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_light", "nomadsshell.upgrade.guardian_light.title", "nomadsshell.upgrade.guardian_light.desc", 3, -16, Arrays.asList("guardian_powder_snow"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.GLOWSTONE, 16), new ItemStack((ItemLike)Items.TORCH, 32)), new ItemStack((ItemLike)Items.TORCH), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_powder_snow", "nomadsshell.upgrade.guardian_powder_snow.title", "nomadsshell.upgrade.guardian_powder_snow.desc", 3, -18, Arrays.asList("guardian_piglin"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET, 4), new ItemStack((ItemLike)Items.LEATHER, 8)), new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_piglin", "nomadsshell.upgrade.guardian_piglin.title", "nomadsshell.upgrade.guardian_piglin.desc", 3, -20, Arrays.asList("guardian_slowfall"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 20), new ItemStack((ItemLike)Items.GOLD_INGOT, 24)), new ItemStack((ItemLike)Items.GOLD_INGOT), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_slowfall", "nomadsshell.upgrade.guardian_slowfall.title", "nomadsshell.upgrade.guardian_slowfall.desc", 3, -22, Arrays.asList("guardian_invisibility"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 24), new ItemStack((ItemLike)Items.FEATHER, 16), new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE, 4), new ItemStack((ItemLike)Items.DIAMOND, 4)), new ItemStack((ItemLike)Items.FEATHER), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        UpgradeDefinitions.register(new UpgradeNode("guardian_invisibility", "nomadsshell.upgrade.guardian_invisibility.title", "nomadsshell.upgrade.guardian_invisibility.desc", 3, -24, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.NETHER_STAR, 1), new ItemStack((ItemLike)Items.GLASS, 32), new ItemStack((ItemLike)Items.ENDER_PEARL, 16), new ItemStack((ItemLike)Items.FERMENTED_SPIDER_EYE, 4)), new ItemStack((ItemLike)Items.GLASS), null, WidgetUnlockSystem.WidgetTier.TIER_0, true, true));
        if (UpgradeDefinitions.isModLoaded("travelersgarden")) {
            UpgradeDefinitions.register(new UpgradeNode("travelers_garden_1", "nomadsshell.upgrade.travelers_garden_1.title", "nomadsshell.upgrade.travelers_garden_1.desc", 5, -5, Arrays.asList("travelers_garden_2"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 12), new ItemStack((ItemLike)Items.BONE_MEAL, 16)), new ItemStack((ItemLike)Items.OAK_SAPLING), WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, WidgetUnlockSystem.WidgetTier.TIER_I, true, true));
            UpgradeDefinitions.register(new UpgradeNode("travelers_garden_2", "nomadsshell.upgrade.travelers_garden_2.title", "nomadsshell.upgrade.travelers_garden_2.desc", 7, -7, Arrays.asList("travelers_garden_3"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 16), new ItemStack((ItemLike)Items.BONE_MEAL, 24)), new ItemStack((ItemLike)Items.OAK_SAPLING), WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, WidgetUnlockSystem.WidgetTier.TIER_II, true, true));
            UpgradeDefinitions.register(new UpgradeNode("travelers_garden_3", "nomadsshell.upgrade.travelers_garden_3.title", "nomadsshell.upgrade.travelers_garden_3.desc", 9, -9, Arrays.asList("travelers_garden_4"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 20), new ItemStack((ItemLike)Items.BONE_MEAL, 32), new ItemStack((ItemLike)Items.MUD, 8)), new ItemStack((ItemLike)Items.OAK_SAPLING), WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, WidgetUnlockSystem.WidgetTier.TIER_III, true, true));
            UpgradeDefinitions.register(new UpgradeNode("travelers_garden_4", "nomadsshell.upgrade.travelers_garden_4.title", "nomadsshell.upgrade.travelers_garden_4.desc", 11, -11, Arrays.asList("travelers_garden_5"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 28), new ItemStack((ItemLike)Items.BONE_MEAL, 48), new ItemStack((ItemLike)Items.DIAMOND, 1)), new ItemStack((ItemLike)Items.OAK_SAPLING), WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, WidgetUnlockSystem.WidgetTier.TIER_IV, true, true));
            UpgradeDefinitions.register(new UpgradeNode("travelers_garden_5", "nomadsshell.upgrade.travelers_garden_5.title", "nomadsshell.upgrade.travelers_garden_5.desc", 13, -13, Arrays.asList("travelers_garden_6"), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 32), new ItemStack((ItemLike)Items.BONE_MEAL, 64), new ItemStack((ItemLike)Items.DIAMOND, 2), new ItemStack((ItemLike)Items.MUD, 16)), new ItemStack((ItemLike)Items.OAK_SAPLING), WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, WidgetUnlockSystem.WidgetTier.TIER_V, true, true));
            UpgradeDefinitions.register(new UpgradeNode("travelers_garden_6", "nomadsshell.upgrade.travelers_garden_6.title", "nomadsshell.upgrade.travelers_garden_6.desc", 15, -15, Collections.emptyList(), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 40), new ItemStack((ItemLike)Items.BONE_BLOCK, 16), new ItemStack((ItemLike)Items.DIAMOND, 4), new ItemStack((ItemLike)Items.MUD, 24)), new ItemStack((ItemLike)Items.OAK_SAPLING), WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, WidgetUnlockSystem.WidgetTier.TIER_VI, true, true));
        }
    }

    private static void register(UpgradeNode node) {
        NODES.put(node.id, node);
    }

    public static UpgradeNode getNode(String id) {
        return NODES.get(id);
    }

    public static Collection<UpgradeNode> getAllNodes() {
        return NODES.values();
    }

    public static List<ItemStack> getRequirements(WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier tier) {
        for (UpgradeNode node : NODES.values()) {
            if (node.widgetType != widgetType || node.tier != tier) continue;
            return node.requirements;
        }
        return Collections.singletonList(new ItemStack((ItemLike)Items.IRON_INGOT, 1));
    }

    private static boolean isModLoaded(String modId) {
        try {
            return ModList.get().isLoaded(modId);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        UpgradeDefinitions.initializeAllNodes();
    }

    public static class UpgradeNode {
        public final String id;
        public final String titleKey;
        public final String descriptionKey;
        public final int gridX;
        public final int gridY;
        public final List<String> connections;
        public final List<ItemStack> requirements;
        public final String tagRequirement;
        public final int tagCount;
        public final ItemStack icon;
        public final WidgetUnlockSystem.WidgetType widgetType;
        public final WidgetUnlockSystem.WidgetTier tier;
        public final boolean alwaysVisible;
        public final boolean alwaysClickable;

        public UpgradeNode(String id, String titleKey, String descriptionKey, int gridX, int gridY, List<String> connections, List<ItemStack> requirements, ItemStack icon, WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier tier, boolean alwaysVisible, boolean alwaysClickable) {
            this(id, titleKey, descriptionKey, gridX, gridY, connections, requirements, null, 0, icon, widgetType, tier, alwaysVisible, alwaysClickable);
        }

        public UpgradeNode(String id, String titleKey, String descriptionKey, int gridX, int gridY, List<String> connections, List<ItemStack> requirements, String tagRequirement, int tagCount, ItemStack icon, WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier tier, boolean alwaysVisible, boolean alwaysClickable) {
            this.id = id;
            this.titleKey = titleKey;
            this.descriptionKey = descriptionKey;
            this.gridX = gridX;
            this.gridY = gridY;
            this.connections = connections;
            this.requirements = requirements;
            this.tagRequirement = tagRequirement;
            this.tagCount = tagCount;
            this.icon = icon;
            this.widgetType = widgetType;
            this.tier = tier;
            this.alwaysVisible = alwaysVisible;
            this.alwaysClickable = alwaysClickable;
        }
    }
}

