/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.UpgradeNodeConfig;
import java.util.List;

public class UpgradeLayoutEngine {
    public static void calculatePositions(List<UpgradeNodeConfig> nodes, String layoutType) {
        if (nodes.isEmpty()) {
            return;
        }
        switch (layoutType.toLowerCase()) {
            case "vertical": {
                UpgradeLayoutEngine.calculateVerticalLayout(nodes);
                break;
            }
            case "diagonal": {
                UpgradeLayoutEngine.calculateDiagonalLayout(nodes);
                break;
            }
            case "horizontal": {
                UpgradeLayoutEngine.calculateHorizontalLayout(nodes);
                break;
            }
            case "radial": {
                UpgradeLayoutEngine.calculateRadialLayout(nodes);
                break;
            }
            default: {
                UpgradeLayoutEngine.calculateVerticalLayout(nodes);
            }
        }
    }

    private static void calculateVerticalLayout(List<UpgradeNodeConfig> nodes) {
        int baseX = nodes.get((int)0).x;
        int baseY = nodes.get((int)0).y;
        int spacing = 32;
        for (int i = 0; i < nodes.size(); ++i) {
            UpgradeNodeConfig node = nodes.get(i);
            node.x = baseX;
            node.y = baseY + i * spacing;
        }
    }

    private static void calculateHorizontalLayout(List<UpgradeNodeConfig> nodes) {
        int baseX = nodes.get((int)0).x;
        int baseY = nodes.get((int)0).y;
        int spacing = 32;
        for (int i = 0; i < nodes.size(); ++i) {
            UpgradeNodeConfig node = nodes.get(i);
            node.x = baseX + i * spacing;
            node.y = baseY;
        }
    }

    private static void calculateDiagonalLayout(List<UpgradeNodeConfig> nodes) {
        int baseX = nodes.get((int)0).x;
        int baseY = nodes.get((int)0).y;
        int spacing = 26;
        for (int i = 0; i < nodes.size(); ++i) {
            UpgradeNodeConfig node = nodes.get(i);
            node.x = baseX - i * spacing;
            node.y = baseY - i * spacing;
        }
    }

    private static void calculateRadialLayout(List<UpgradeNodeConfig> nodes) {
        int centerX = nodes.get((int)0).x;
        int centerY = nodes.get((int)0).y;
        int radius = 64;
        double angleStep = Math.PI * 2 / (double)nodes.size();
        for (int i = 0; i < nodes.size(); ++i) {
            UpgradeNodeConfig node = nodes.get(i);
            double angle = (double)i * angleStep;
            node.x = (int)((double)centerX + (double)radius * Math.cos(angle));
            node.y = (int)((double)centerY + (double)radius * Math.sin(angle));
        }
    }

    public static void insertNodeBetween(List<UpgradeNodeConfig> nodes, int insertIndex, UpgradeNodeConfig newNode, String layoutType) {
        if (insertIndex < 0 || insertIndex > nodes.size()) {
            throw new IllegalArgumentException("Insert index out of bounds");
        }
        nodes.add(insertIndex, newNode);
        UpgradeLayoutEngine.calculatePositions(nodes, layoutType);
    }

    public static void removeNode(List<UpgradeNodeConfig> nodes, int removeIndex, String layoutType) {
        if (removeIndex < 0 || removeIndex >= nodes.size()) {
            throw new IllegalArgumentException("Remove index out of bounds");
        }
        nodes.remove(removeIndex);
        UpgradeLayoutEngine.calculatePositions(nodes, layoutType);
    }

    public static int getSpacingForLayout(String layoutType) {
        switch (layoutType.toLowerCase()) {
            case "vertical": 
            case "horizontal": {
                return 32;
            }
            case "diagonal": {
                return 26;
            }
            case "radial": {
                return 64;
            }
        }
        return 32;
    }
}

