/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.UpgradeDefinitions;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.util.InventoryUtils;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WidgetUnlockSystem {
    private static final Map<WidgetType, Boolean> unlockedWidgets = new HashMap<WidgetType, Boolean>();

    public static WidgetTier getWidgetTier(WidgetType type, ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return WidgetTier.TIER_0;
        }
        Map tierMap = (Map)shellStack.getOrDefault(ModDataComponents.WIDGET_TIERS.get(), new EnumMap(WidgetType.class));
        if (!WidgetUnlockSystem.isUnlocked(type, shellStack)) {
            return WidgetTier.TIER_0;
        }
        return tierMap.getOrDefault((Object)type, WidgetTier.TIER_I);
    }

    public static void setWidgetTier(WidgetType type, WidgetTier tier, ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return;
        }
        Map tierMap = (Map)shellStack.getOrDefault(ModDataComponents.WIDGET_TIERS.get(), new EnumMap(WidgetType.class));
        EnumMap<WidgetType, WidgetTier> newTierMap = new EnumMap<WidgetType, WidgetTier>(WidgetType.class);
        newTierMap.putAll(tierMap);
        newTierMap.put(type, tier);
        shellStack.set(ModDataComponents.WIDGET_TIERS.get(), newTierMap);
    }

    public static boolean canUpgrade(WidgetType type, ItemStack shellStack) {
        int cauldronCount;
        if (shellStack.isEmpty() || !WidgetUnlockSystem.isUnlocked(type, shellStack)) {
            return false;
        }
        WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(type, shellStack);
        if (type == WidgetType.DRIPSTONE_FARM && currentTier == WidgetTier.TIER_I && (cauldronCount = ((Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0)).intValue()) < 3) {
            return false;
        }
        return switch (currentTier.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> true;
            case 2 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.DRIPSTONE_FARM || type == WidgetType.GUARDIAN || type == WidgetType.TELEPORTER || type == WidgetType.TRAVELERS_GARDEN) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.DRIPSTONE_FARM || type == WidgetType.GUARDIAN || type == WidgetType.TELEPORTER || type == WidgetType.TRAVELERS_GARDEN) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.GUARDIAN || type == WidgetType.TELEPORTER || type == WidgetType.TRAVELERS_GARDEN) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.GUARDIAN || type == WidgetType.TRAVELERS_GARDEN) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.GUARDIAN) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.GUARDIAN) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.GUARDIAN) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                if (type == WidgetType.FLUID_TANK || type == WidgetType.GUARDIAN) {
                    yield true;
                }
                yield false;
            }
            case 10 -> false;
        };
    }

    public static List<ItemRequirement> getUpgradeRequirements(WidgetType type, ItemStack shellStack) {
        WidgetTier nextTier;
        if (!WidgetUnlockSystem.canUpgrade(type, shellStack)) {
            return List.of();
        }
        WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(type, shellStack);
        switch (currentTier.ordinal()) {
            case 1: {
                WidgetTier widgetTier = WidgetTier.TIER_II;
                break;
            }
            case 2: {
                WidgetTier widgetTier;
                if (type == WidgetType.FLUID_TANK) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                if (type == WidgetType.DRIPSTONE_FARM) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                if (type == WidgetType.TELEPORTER) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                if (type == WidgetType.TRAVELERS_GARDEN) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                if (type == WidgetType.COLLECTOR) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                if (type == WidgetType.MAGNET) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                if (type == WidgetType.AUTO_FEEDER) {
                    widgetTier = WidgetTier.TIER_III;
                    break;
                }
                widgetTier = null;
                break;
            }
            case 3: {
                WidgetTier widgetTier;
                if (type == WidgetType.FLUID_TANK) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                if (type == WidgetType.DRIPSTONE_FARM) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                if (type == WidgetType.TELEPORTER) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                if (type == WidgetType.TRAVELERS_GARDEN) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                if (type == WidgetType.COLLECTOR) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                if (type == WidgetType.MAGNET) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                if (type == WidgetType.AUTO_FEEDER) {
                    widgetTier = WidgetTier.TIER_IV;
                    break;
                }
                widgetTier = null;
                break;
            }
            case 4: {
                WidgetTier widgetTier;
                if (type == WidgetType.FLUID_TANK) {
                    widgetTier = WidgetTier.TIER_V;
                    break;
                }
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_V;
                    break;
                }
                if (type == WidgetType.TELEPORTER) {
                    widgetTier = WidgetTier.TIER_V;
                    break;
                }
                if (type == WidgetType.TRAVELERS_GARDEN) {
                    widgetTier = WidgetTier.TIER_V;
                    break;
                }
                if (type == WidgetType.COLLECTOR) {
                    widgetTier = WidgetTier.TIER_V;
                    break;
                }
                if (type == WidgetType.MAGNET) {
                    widgetTier = WidgetTier.TIER_V;
                    break;
                }
                if (type == WidgetType.AUTO_FEEDER) {
                    widgetTier = WidgetTier.TIER_V;
                    break;
                }
                widgetTier = null;
                break;
            }
            case 5: {
                WidgetTier widgetTier;
                if (type == WidgetType.FLUID_TANK) {
                    widgetTier = WidgetTier.TIER_VI;
                    break;
                }
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_VI;
                    break;
                }
                if (type == WidgetType.TRAVELERS_GARDEN) {
                    widgetTier = WidgetTier.TIER_VI;
                    break;
                }
                if (type == WidgetType.COLLECTOR) {
                    widgetTier = WidgetTier.TIER_VI;
                    break;
                }
                if (type == WidgetType.MAGNET) {
                    widgetTier = WidgetTier.TIER_VI;
                    break;
                }
                if (type == WidgetType.AUTO_FEEDER) {
                    widgetTier = WidgetTier.TIER_VI;
                    break;
                }
                widgetTier = null;
                break;
            }
            case 6: {
                WidgetTier widgetTier;
                if (type == WidgetType.FLUID_TANK) {
                    widgetTier = WidgetTier.TIER_VII;
                    break;
                }
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_VII;
                    break;
                }
                if (type == WidgetType.COLLECTOR) {
                    widgetTier = WidgetTier.TIER_VII;
                    break;
                }
                if (type == WidgetType.MAGNET) {
                    widgetTier = WidgetTier.TIER_VII;
                    break;
                }
                if (type == WidgetType.AUTO_FEEDER) {
                    widgetTier = WidgetTier.TIER_VII;
                    break;
                }
                widgetTier = null;
                break;
            }
            case 7: {
                WidgetTier widgetTier;
                if (type == WidgetType.FLUID_TANK) {
                    widgetTier = WidgetTier.TIER_VIII;
                    break;
                }
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_VIII;
                    break;
                }
                if (type == WidgetType.COLLECTOR) {
                    widgetTier = WidgetTier.TIER_VIII;
                    break;
                }
                if (type == WidgetType.MAGNET) {
                    widgetTier = WidgetTier.TIER_VIII;
                    break;
                }
                if (type == WidgetType.AUTO_FEEDER) {
                    widgetTier = WidgetTier.TIER_VIII;
                    break;
                }
                widgetTier = null;
                break;
            }
            case 8: {
                WidgetTier widgetTier;
                if (type == WidgetType.FLUID_TANK) {
                    widgetTier = WidgetTier.TIER_IX;
                    break;
                }
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_IX;
                    break;
                }
                if (type == WidgetType.COLLECTOR) {
                    widgetTier = WidgetTier.TIER_IX;
                    break;
                }
                if (type == WidgetType.MAGNET) {
                    widgetTier = WidgetTier.TIER_IX;
                    break;
                }
                if (type == WidgetType.AUTO_FEEDER) {
                    widgetTier = WidgetTier.TIER_IX;
                    break;
                }
                widgetTier = null;
                break;
            }
            case 9: {
                WidgetTier widgetTier;
                if (type == WidgetType.GUARDIAN) {
                    widgetTier = WidgetTier.TIER_X;
                    break;
                }
                widgetTier = null;
                break;
            }
            default: {
                WidgetTier widgetTier = nextTier = null;
            }
        }
        if (nextTier != null) {
            return type.getUpgradeRequirements(currentTier, nextTier);
        }
        return List.of();
    }

    public static boolean hasUpgradeItems(WidgetType type, ItemStack shellStack, Player player) {
        List<ItemRequirement> requirements = WidgetUnlockSystem.getUpgradeRequirements(type, shellStack);
        for (ItemRequirement req : requirements) {
            int playerHas = InventoryUtils.countItemAcrossInventoryAndshell(player, req.getItem());
            if (playerHas >= req.getCount()) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnlocked(WidgetType type, ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return false;
        }
        Set unlockedWidgets = (Set)shellStack.getOrDefault(ModDataComponents.UNLOCKED_WIDGETS.get(), EnumSet.noneOf(WidgetType.class));
        return unlockedWidgets.contains((Object)type);
    }

    public static void unlock(WidgetType type, ItemStack shellStack) {
        List unlockOrder;
        if (shellStack.isEmpty()) {
            return;
        }
        Set unlockedWidgets = (Set)shellStack.getOrDefault(ModDataComponents.UNLOCKED_WIDGETS.get(), EnumSet.noneOf(WidgetType.class));
        EnumSet<WidgetType> newUnlockedWidgets = EnumSet.copyOf(unlockedWidgets);
        newUnlockedWidgets.add(type);
        shellStack.set(ModDataComponents.UNLOCKED_WIDGETS.get(), newUnlockedWidgets);
        if (!unlockedWidgets.contains((Object)type)) {
            WidgetUnlockSystem.setWidgetTier(type, WidgetTier.TIER_I, shellStack);
        }
        if (!(unlockOrder = (List)shellStack.getOrDefault(ModDataComponents.WIDGET_UNLOCK_ORDER.get(), new ArrayList())).contains((Object)type)) {
            ArrayList<WidgetType> newOrder = new ArrayList<WidgetType>(unlockOrder);
            newOrder.add(type);
            shellStack.set(ModDataComponents.WIDGET_UNLOCK_ORDER.get(), newOrder);
        }
    }

    public static void lock(WidgetType type, ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return;
        }
        Set unlockedWidgets = (Set)shellStack.getOrDefault(ModDataComponents.UNLOCKED_WIDGETS.get(), EnumSet.noneOf(WidgetType.class));
        EnumSet newUnlockedWidgets = EnumSet.copyOf(unlockedWidgets);
        newUnlockedWidgets.remove((Object)type);
        shellStack.set(ModDataComponents.UNLOCKED_WIDGETS.get(), newUnlockedWidgets);
    }

    public static List<WidgetType> getUnlockOrder(ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return List.of();
        }
        return (List)shellStack.getOrDefault(ModDataComponents.WIDGET_UNLOCK_ORDER.get(), List.of());
    }

    public static boolean isUnlocked(WidgetType type) {
        return unlockedWidgets.getOrDefault((Object)type, false);
    }

    public static void unlock(WidgetType type) {
        unlockedWidgets.put(type, true);
    }

    public static void lock(WidgetType type) {
        unlockedWidgets.put(type, false);
    }

    public static List<ItemRequirement> getRequirements(WidgetType type) {
        return type.getRequirements();
    }

    public static boolean hasRequiredItems(WidgetType type, Player player) {
        Map<Item, Integer> availableItems = InventoryUtils.getAllItemCountsAcrossInventoryAndshell(player);
        for (ItemRequirement requirement : type.getRequirements()) {
            int available = availableItems.getOrDefault(requirement.getItem(), 0);
            if (available >= requirement.getCount()) continue;
            return false;
        }
        return true;
    }

    public static void resetAll() {
        unlockedWidgets.clear();
    }

    public static enum WidgetTier implements StringRepresentable
    {
        TIER_0(0, "Locked"),
        TIER_I(1, "Basic"),
        TIER_II(2, "Improved"),
        TIER_III(3, "Enhanced"),
        TIER_IV(4, "Advanced"),
        TIER_V(5, "Expert"),
        TIER_VI(6, "Master"),
        TIER_VII(7, "Legendary"),
        TIER_VIII(8, "Ultimate"),
        TIER_IX(9, "Mythical"),
        TIER_X(10, "Transcendent");

        public static final Codec<WidgetTier> CODEC;
        private final int level;
        private final String displayName;

        private WidgetTier(int level, String displayName) {
            this.level = level;
            this.displayName = displayName;
        }

        public int getLevel() {
            return this.level;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public static WidgetTier fromLevel(int level) {
            for (WidgetTier tier : WidgetTier.values()) {
                if (tier.level != level) continue;
                return tier;
            }
            return TIER_0;
        }

        static {
            CODEC = StringRepresentable.fromEnum(WidgetTier::values);
        }
    }

    public static enum WidgetType implements StringRepresentable
    {
        CRAFTING_TABLE("crafting_table", "Portable Crafting Table", "Craft items anywhere! Starts 2x2, upgrades to 3x3!", List.of()),
        TRAVELERS_GARDEN("travelers_garden", "Traveler's Garden", "Grow and harvest crops from Traveler's Garden inside your shell.", List.of()),
        TRASH_BIN("trash_bin", "Trash Bin", "When you put something here it is gone!", List.of()),
        FURNACE("furnace", "Portable Furnace", "A compact furnace for smelting on the go!", List.of()),
        FLUID_TANK("fluid_tank", "Fluid Tanks", "Store and transfer any fluid. Two ports: one input, one output.", List.of()),
        DRIPSTONE_FARM("dripstone_farm", "Dripstone Farm", "Simulate pointed dripstone over a cauldron: feed a fluid bucket on top, collect at the bottom later.", List.of()),
        GUARDIAN("guardian", "Guardian", "Protective backpack features: armor presets + snow walk + piglin neutrality + slow fall & still invis.", List.of()),
        TELEPORTER("teleporter", "Teleporter", "Travel utilities: bed/spawn, nether/overworld toggle, end spawn, and personal pocket.", List.of()),
        ANVIL("anvil", "Portable Anvil", "Repair, rename, and combine items using the real anvil system!", List.of()),
        ENCHANTMENT_TABLE("enchantment_table", "Enchantment Table", "Enchant items with bookshelves for power and lapis for cost!", List.of()),
        COLLECTOR("collector", "Collector", "Automatically collects items from nearby chests and containers.", List.of()),
        MAGNET("magnet", "Magnet", "Pulls items from far away into your shell automatically.", List.of()),
        AUTO_FEEDER("auto_feeder", "Auto Feeder", "Automatically feeds the player selected food from the shell when needed.", List.of()),
        COMPASS("compass", "Compass", "Shows your current direction (N/S/E/W) at a glance.", List.of());

        public static final Codec<WidgetType> CODEC;
        private final String name;
        private final String displayName;
        private final String description;
        private final List<ItemRequirement> requirements;

        private WidgetType(String name, String displayName, String description, List<ItemRequirement> requirements) {
            this.name = name;
            this.displayName = displayName;
            this.description = description;
            this.requirements = requirements;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public List<ItemRequirement> getRequirements() {
            List<ItemStack> stacks = UpgradeDefinitions.getRequirements(this, WidgetTier.TIER_I);
            return stacks.stream().map(stack -> new ItemRequirement(stack.getItem(), stack.getCount())).toList();
        }

        public List<ItemRequirement> getUpgradeRequirements(WidgetTier fromTier, WidgetTier toTier) {
            List<ItemStack> stacks = UpgradeDefinitions.getRequirements(this, toTier);
            return stacks.stream().map(stack -> new ItemRequirement(stack.getItem(), stack.getCount())).toList();
        }

        static {
            CODEC = StringRepresentable.fromEnum(WidgetType::values);
        }
    }

    public static class ItemRequirement {
        private final Item item;
        private final int count;

        public ItemRequirement(Item item, int count) {
            this.item = item;
            this.count = count;
        }

        public Item getItem() {
            return this.item;
        }

        public int getCount() {
            return this.count;
        }

        public ItemStack getItemStack() {
            return new ItemStack((ItemLike)this.item, this.count);
        }
    }
}

