/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay.autofeeder;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.UpdateAutoFeederFoodPacket;
import com.etka.nomadsshell.network.UpdateAutoFeederSettingsPacket;
import com.etka.nomadsshell.network.UpdateAutoFeederTagFilterPacket;
import com.etka.nomadsshell.network.UpdateAutoFeederTagRecorderGhostPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class AutoFeederWidget
extends LockableWidget {
    private final IShellMenu menu;
    private boolean logoMode = false;
    private static final int TAG_BORDER_COLOR = -6596170;
    private static final int TAG_BG_COLOR = -12899525;
    private static final int MINI_BTN = 6;
    private static final int FEEDING_BTN_WIDTH = 40;
    private static final int FEEDING_BTN_HEIGHT = 12;
    private static final int FEEDING_BTN_SPACING = 2;
    private int selectedTagRemoveIdx = 0;
    private int selectedTagGhostIdx = 0;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.AUTO_FEEDER_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.AUTO_FEEDER_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    public AutoFeederWidget(int x, int y, Font font, IShellMenu menu) {
        super(AutoFeederWidget.loadPositionX(x), AutoFeederWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.auto_feeder"), font, WidgetUnlockSystem.WidgetType.AUTO_FEEDER, menu);
        this.menu = menu;
        this.isPinned = (Boolean)OverlayConfig.AUTO_FEEDER_PINNED.get();
        this.updateWidgetDimensions();
    }

    @Override
    protected void updateWidgetDimensions() {
        int requiredHeight = this.calculateRequiredHeight();
        this.width = 140;
        this.height = requiredHeight;
    }

    private int calculateRequiredHeight() {
        WidgetUnlockSystem.WidgetType widgetType;
        WidgetUnlockSystem.WidgetTier currentTier;
        int tierLevel;
        ItemStack shell;
        int height = 20;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && !(shell = ShellItem.findWornshell((Player)player)).isEmpty() && (tierLevel = (currentTier = WidgetUnlockSystem.getWidgetTier(widgetType = WidgetUnlockSystem.WidgetType.AUTO_FEEDER, shell)).getLevel()) >= 1) {
            height += 22;
            height += 16;
        }
        return Math.max(height, 36);
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float pt) {
        boolean titleBarHovered;
        boolean hoveredWidget;
        this.updateWidgetDimensions();
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean imageEnabled = (Boolean)OverlayConfig.AUTO_FEEDER_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.AUTO_FEEDER);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, y + 12, w, h - 12);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.AUTO_FEEDER;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x - 1, y - 1, x + w + 1, y + 12, Theme.panelBorder());
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        boolean bl2 = titleBarHovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            g.fill(x, y, x + w, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        int contentHeight = h - 12;
        g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
        if (tierLevel >= 1) {
            this.renderFeedingBehaviorButtons(g, x, contentY, mouseX, mouseY);
            this.renderFeedingBehaviorTooltips(g, x, contentY, mouseX, mouseY);
            int startX = x + 4;
            int startY = contentY + 4 + 12 + 4;
            for (int i = 0; i < 4; ++i) {
                int slotX = startX + i * 20;
                int slotY = startY;
                g.fill(slotX, slotY, slotX + 16, slotY + 16, Theme.slotFill());
                g.fill(slotX - 1, slotY - 1, slotX + 17, slotY, Theme.slotBorder());
                g.fill(slotX - 1, slotY + 16, slotX + 17, slotY + 17, Theme.slotBorder());
                g.fill(slotX - 1, slotY - 1, slotX, slotY + 17, Theme.slotBorder());
                g.fill(slotX + 16, slotY - 1, slotX + 17, slotY + 17, Theme.slotBorder());
                ItemStack stack = WidgetDataHelper.getAutoFeederFood((Player)player, i);
                if (stack.isEmpty()) continue;
                ItemStack ghost = stack.copy();
                ghost.setCount(1);
                g.renderItem(ghost, slotX, slotY);
            }
            int tagSlotX = startX + 80 + 4;
            int tagSlotY = startY;
            List<ResourceLocation> autoFeederTags = WidgetDataHelper.getAutoFeederTags((Player)player);
            boolean whitelist = WidgetDataHelper.isAutoFeederTagWhitelist((Player)player);
            this.drawTagSelectorSlot(g, tagSlotX, tagSlotY, autoFeederTags.size(), whitelist, true, this.selectedTagRemoveIdx);
            ItemStack tagGhost = WidgetDataHelper.getAutoFeederTagGhost((Player)player);
            if (!tagGhost.isEmpty()) {
                ItemStack ghost = tagGhost.copy();
                ghost.setCount(1);
                g.renderItem(ghost, tagSlotX, tagSlotY);
            }
        }
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.AUTO_FEEDER_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.AUTO_FEEDER_USE_IMAGE_MODE.get();
        OverlayConfig.AUTO_FEEDER_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int contentY, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = contentY + (currentHeight - iconSize) / 2;
        guiGraphics.blit(Theme.icon("food"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int startY;
        int startX;
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.AUTO_FEEDER);
        this.logoMode = false;
        int autoFeederX = x + w - 16 - 4;
        int autoFeederY = y + 2;
        if (mouseX >= (double)autoFeederX && mouseX <= (double)(autoFeederX + 8) && mouseY >= (double)autoFeederY && mouseY <= (double)(autoFeederY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.AUTO_FEEDER_ENABLED.get();
            OverlayConfig.AUTO_FEEDER_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.AUTO_FEEDER;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        if (tierLevel >= 1) {
            startX = x + 4;
            startY = y + 12 + 4 + 12 + 4;
            int slotCount = 4;
            for (int i = 0; i < slotCount; ++i) {
                int slotX = startX + i * 20;
                int slotY = startY;
                if (!(mouseX >= (double)slotX) || !(mouseX <= (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY <= (double)(slotY + 16))) continue;
                if (button == 0) {
                    ItemStack carried = mc.player.containerMenu.getCarried();
                    if (!carried.isEmpty()) {
                        if (this.isEdibleItem(carried, (Player)player)) {
                            WidgetDataHelper.setAutoFeederFood((Player)player, i, carried.copy());
                            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederFoodPacket(i, carried.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            mc.player.displayClientMessage((Component)Component.translatable((String)"nomadsshell.autofeeder.non_edible"), true);
                        }
                    }
                } else if (button == 1) {
                    WidgetDataHelper.setAutoFeederFood((Player)player, i, ItemStack.EMPTY);
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederFoodPacket(i, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return true;
            }
        }
        if (tierLevel >= 1) {
            int startXControls;
            startX = x + 4;
            startY = y + 12 + 4 + 12 + 4;
            int tagSlotX = startX + 80 + 4;
            int tagSlotY = startY;
            if (mouseX >= (double)tagSlotX && mouseX <= (double)(tagSlotX + 16) && mouseY >= (double)tagSlotY && mouseY <= (double)(tagSlotY + 16)) {
                this.handleTagSelectorClick(tagSlotX, tagSlotY, mouseX, mouseY, button);
                return true;
            }
            int cx = tagSlotX + 8;
            int cy = tagSlotY + 16 + 2;
            int spacing = 2;
            int totalW = 18 + spacing * 2;
            int minusX = startXControls = cx - totalW / 2;
            int wlX = startXControls + 6 + spacing;
            int plusX = wlX + 6 + spacing;
            if (mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) || mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) || mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6)) {
                this.handleTagSelectorClick(tagSlotX, tagSlotY, mouseX, mouseY, button);
                return true;
            }
        }
        if (tierLevel >= 1 && this.handleFeedingBehaviorButtonClick(mouseX, mouseY, button, x, y)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void handleTagSelectorClick(int slotX, int slotY, double mouseX, double mouseY, int button) {
        int startX;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        int cx = slotX + 8;
        int cy = slotY + 16 + 2;
        int spacing = 2;
        int totalW = 18 + spacing * 2;
        int minusX = startX = cx - totalW / 2;
        int wlX = startX + 6 + spacing;
        int plusX = wlX + 6 + spacing;
        if (mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>(WidgetDataHelper.getAutoFeederTags((Player)mc.player));
            if (!tags.isEmpty() && this.selectedTagRemoveIdx >= 0 && this.selectedTagRemoveIdx < tags.size()) {
                tags.remove(this.selectedTagRemoveIdx);
                boolean whitelist = WidgetDataHelper.isAutoFeederTagWhitelist((Player)mc.player);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederTagFilterPacket(tags, whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.selectedTagRemoveIdx = Math.max(0, Math.min(this.selectedTagRemoveIdx, tags.size() - 1));
            }
            return;
        }
        if (mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            List<ResourceLocation> tags = WidgetDataHelper.getAutoFeederTags((Player)mc.player);
            boolean whitelist = WidgetDataHelper.isAutoFeederTagWhitelist((Player)mc.player);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederTagFilterPacket(tags, !whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        if (mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            List<ResourceLocation> keys;
            ItemStack ghost = WidgetDataHelper.getAutoFeederTagGhost((Player)mc.player);
            if (!ghost.isEmpty() && !(keys = this.getItemTagKeys(ghost)).isEmpty()) {
                ResourceLocation sel = keys.get(Math.floorMod(this.selectedTagGhostIdx, keys.size()));
                ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>(WidgetDataHelper.getAutoFeederTags((Player)mc.player));
                if (!tags.contains(sel)) {
                    tags.add(sel);
                    boolean whitelist = WidgetDataHelper.isAutoFeederTagWhitelist((Player)mc.player);
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederTagFilterPacket(tags, whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.selectedTagRemoveIdx = tags.size() - 1;
                }
            }
            return;
        }
        if (mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16)) {
            if (button == 0) {
                ItemStack carried = mc.player.containerMenu.getCarried();
                if (!carried.isEmpty()) {
                    WidgetDataHelper.setAutoFeederTagGhost((Player)mc.player, carried.copy());
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederTagRecorderGhostPacket(carried.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    List<ResourceLocation> keys = this.getItemTagKeys(carried);
                    this.selectedTagGhostIdx = 0;
                }
            } else if (button == 1) {
                WidgetDataHelper.setAutoFeederTagGhost((Player)mc.player, ItemStack.EMPTY);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederTagRecorderGhostPacket(ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (button == 2) {
                List<ResourceLocation> tags = WidgetDataHelper.getAutoFeederTags((Player)mc.player);
                boolean whitelist = WidgetDataHelper.isAutoFeederTagWhitelist((Player)mc.player);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederTagFilterPacket(tags, !whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private boolean handleFeedingBehaviorButtonClick(double mouseX, double mouseY, int button, int x, int y) {
        if (button != 0) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        int buttonY = y + 12 + 4;
        boolean feedOnDamage = WidgetDataHelper.isAutoFeederFeedOnDamage((Player)player);
        boolean waitForFullHunger = WidgetDataHelper.isAutoFeederWaitForFullHunger((Player)player);
        boolean waitForFullDamage = WidgetDataHelper.isAutoFeederWaitForFullDamage((Player)player);
        int btn1X = x + 4;
        int btn1Y = buttonY;
        if (mouseX >= (double)btn1X && mouseX <= (double)(btn1X + 40) && mouseY >= (double)btn1Y && mouseY <= (double)(btn1Y + 12)) {
            boolean newFeedOnDamage = !feedOnDamage;
            WidgetDataHelper.setAutoFeederFeedOnDamage((Player)player, newFeedOnDamage);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederSettingsPacket(newFeedOnDamage, waitForFullHunger, waitForFullDamage), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        int btn2X = btn1X + 40 + 2;
        int btn2Y = buttonY;
        if (mouseX >= (double)btn2X && mouseX <= (double)(btn2X + 40) && mouseY >= (double)btn2Y && mouseY <= (double)(btn2Y + 12)) {
            boolean newWaitForFullHunger = !waitForFullHunger;
            WidgetDataHelper.setAutoFeederWaitForFullHunger((Player)player, newWaitForFullHunger);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederSettingsPacket(feedOnDamage, newWaitForFullHunger, waitForFullDamage), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (feedOnDamage) {
            int btn3X = btn2X + 40 + 2;
            int btn3Y = buttonY;
            if (mouseX >= (double)btn3X && mouseX <= (double)(btn3X + 40) && mouseY >= (double)btn3Y && mouseY <= (double)(btn3Y + 12)) {
                boolean newWaitForFullDamage = !waitForFullDamage;
                WidgetDataHelper.setAutoFeederWaitForFullDamage((Player)player, newWaitForFullDamage);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAutoFeederSettingsPacket(feedOnDamage, waitForFullHunger, newWaitForFullDamage), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.AUTO_FEEDER;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        if (tierLevel >= 1) {
            List<ResourceLocation> tags;
            boolean overPlus;
            int startXControls;
            int startX = x + 4;
            int startY = y + 12 + 4 + 12 + 4;
            int tagSlotX = startX + 80 + 4;
            int tagSlotY = startY;
            if (mouseX >= (double)tagSlotX && mouseX <= (double)(tagSlotX + 16) && mouseY >= (double)tagSlotY && mouseY <= (double)(tagSlotY + 16)) {
                List keys;
                ItemStack ghost = WidgetDataHelper.getAutoFeederTagGhost((Player)player);
                List<Object> list = keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
                if (!keys.isEmpty()) {
                    int dir = scrollY > 0.0 ? -1 : 1;
                    this.selectedTagGhostIdx = Math.floorMod(this.selectedTagGhostIdx + dir, keys.size());
                    OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.AUTO_FEEDER);
                    return true;
                }
            }
            int cx = tagSlotX + 8;
            int cy = tagSlotY + 16 + 2;
            int spacing = 2;
            int totalW = 18 + spacing * 2;
            int minusX = startXControls = cx - totalW / 2;
            int wlX = startXControls + 6 + spacing;
            int plusX = wlX + 6 + spacing;
            boolean overMinus = mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
            boolean bl2 = overPlus = mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
            if (overPlus) {
                List keys;
                ItemStack ghost = WidgetDataHelper.getAutoFeederTagGhost((Player)player);
                List<Object> list = keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
                if (!keys.isEmpty()) {
                    int dir = scrollY > 0.0 ? -1 : 1;
                    this.selectedTagGhostIdx = Math.floorMod(this.selectedTagGhostIdx + dir, keys.size());
                    OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.AUTO_FEEDER);
                    return true;
                }
            } else if (overMinus && !(tags = WidgetDataHelper.getAutoFeederTags((Player)player)).isEmpty()) {
                int dir = scrollY > 0.0 ? -1 : 1;
                this.selectedTagRemoveIdx = Math.floorMod(this.selectedTagRemoveIdx + dir, tags.size());
                OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.AUTO_FEEDER);
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int toggleX = x + currentWidth - 16 - 4;
        int toggleY = y + 2;
        boolean toggleHovered = mouseX >= toggleX && mouseX <= toggleX + 8 && mouseY >= toggleY && mouseY <= toggleY + 8;
        boolean autoFeederEnabled = (Boolean)OverlayConfig.AUTO_FEEDER_ENABLED.get();
        int n = buttonColor = autoFeederEnabled ? -11751600 : -769226;
        if (toggleHovered) {
            buttonColor = autoFeederEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(toggleX, toggleY, toggleX + 8, toggleY + 8, buttonColor);
        if (!autoFeederEnabled) {
            int c = -1;
            guiGraphics.fill(toggleX + 3, toggleY + 3, toggleX + 5, toggleY + 5, c);
            guiGraphics.fill(toggleX + 5, toggleY + 3, toggleX + 7, toggleY + 5, c);
            guiGraphics.fill(toggleX + 3, toggleY + 5, toggleX + 5, toggleY + 7, c);
            guiGraphics.fill(toggleX + 5, toggleY + 5, toggleX + 7, toggleY + 7, c);
        }
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, pinColor);
        } else {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, pinColor);
        }
        guiGraphics.pose().popPose();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    private void savePinStateToConfig() {
        OverlayConfig.AUTO_FEEDER_PINNED.set((Object)this.isPinned());
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    private void savePositionToConfig() {
        OverlayConfig.AUTO_FEEDER_X.set((Object)this.getX());
        OverlayConfig.AUTO_FEEDER_Y.set((Object)this.getY());
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void drawTagSelectorSlot(GuiGraphics guiGraphics, int x, int y, int tagCount, boolean whitelist, boolean controlsBelow, int selectedIndex) {
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, -6596170);
        guiGraphics.fill(x, y, x + 16, y + 16, -12899525);
        int cx = x + 8;
        int cy = controlsBelow ? y + 16 + 2 : y - 6 - 2;
        int spacing = 2;
        int totalW = 18 + spacing * 2;
        int startX = cx - totalW / 2;
        guiGraphics.fill(startX, cy, startX + 6, cy + 6, -11916470);
        guiGraphics.fill(startX + 1, cy + 3, startX + 6 - 1, cy + 3 + 1, -1);
        int midX = startX + 6 + spacing;
        int wlBg = whitelist ? -13796794 : -8770259;
        guiGraphics.fill(midX, cy, midX + 6, cy + 6, wlBg);
        int g = -1;
        if (whitelist) {
            guiGraphics.fill(midX + 1, cy + 1, midX + 2, cy + 6 - 1, g);
            guiGraphics.fill(midX + 6 - 2, cy + 1, midX + 6 - 1, cy + 6 - 1, g);
            guiGraphics.fill(midX + 2, cy + 2, midX + 6 - 2, cy + 3, g);
        } else {
            guiGraphics.fill(midX + 1, cy + 1, midX + 6 - 1, cy + 2, g);
            guiGraphics.fill(midX + 1, cy + 6 - 2, midX + 6 - 1, cy + 6 - 1, g);
            guiGraphics.fill(midX + 1, cy + 1, midX + 2, cy + 6 - 1, g);
            guiGraphics.fill(midX + 6 - 2, cy + 2, midX + 6 - 1, cy + 6 - 2, g);
        }
        int plusX = midX + 6 + spacing;
        guiGraphics.fill(plusX, cy, plusX + 6, cy + 6, -11916470);
        guiGraphics.fill(plusX + 1, cy + 3, plusX + 6 - 1, cy + 3 + 1, -1);
        guiGraphics.fill(plusX + 3, cy + 1, plusX + 3 + 1, cy + 6 - 1, -1);
        int mouseX = Minecraft.getInstance().mouseHandler.xpos() == 0.0 ? -1 : (int)(Minecraft.getInstance().mouseHandler.xpos() / Minecraft.getInstance().getWindow().getGuiScale());
        int mouseY = Minecraft.getInstance().mouseHandler.ypos() == 0.0 ? -1 : (int)(Minecraft.getInstance().mouseHandler.ypos() / Minecraft.getInstance().getWindow().getGuiScale());
        int minusX = startX;
        if (mouseX >= minusX && mouseX <= minusX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showTagTooltip(guiGraphics, mouseX, mouseY, false);
        } else if (mouseX >= midX && mouseX <= midX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showWhitelistTooltip(guiGraphics, mouseX, mouseY, whitelist);
        } else if (mouseX >= plusX && mouseX <= plusX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showTagTooltip(guiGraphics, mouseX, mouseY, true);
        }
    }

    private void showTagTooltip(GuiGraphics g, int mx, int my, boolean isPlus) {
        String title;
        List<Object> list;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        List<Object> active = List.of();
        if (isPlus) {
            ItemStack ghost = WidgetDataHelper.getAutoFeederTagGhost((Player)mc.player);
            List keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
            list = keys;
            title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString() + ": Add tag";
            active = WidgetDataHelper.getAutoFeederTags((Player)mc.player);
        } else {
            list = WidgetDataHelper.getAutoFeederTags((Player)mc.player);
            title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString() + ": Remove tag";
        }
        if (list.isEmpty()) {
            return;
        }
        int sel = isPlus ? this.selectedTagGhostIdx : this.selectedTagRemoveIdx;
        int max = Math.min(8, list.size());
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        lines.add((CallSite)((Object)title));
        colors.add(-1);
        for (int i = 0; i < max; ++i) {
            ResourceLocation rl = (ResourceLocation)list.get(i);
            String name = rl.toString();
            boolean bl = isPlus && active.contains(rl);
            String label = (i == sel ? "> " : "  ") + (String)name + (bl ? " (added)" : "");
            lines.add((CallSite)((Object)label));
            colors.add(bl ? -11141291 : -1);
        }
        int pad = 4;
        int w = 0;
        for (String string : lines) {
            w = Math.max(w, this.font.width(string));
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int h = n * (9 + 1) + pad * 2;
        int n2 = w + pad * 2;
        int tx = mx + 8;
        int ty = my + 8;
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        if (tx + n2 > screenW) {
            tx = mx - n2 - 8;
        }
        if (ty + h > screenH) {
            ty = my - h - 8;
        }
        g.fill(tx + 2, ty + 2, tx + n2 + 2, ty + h + 2, 0x77000000);
        g.fill(tx, ty, tx + n2, ty + h, -870375649);
        g.fill(tx - 1, ty - 1, tx + n2 + 1, ty, -1);
        g.fill(tx - 1, ty + h, tx + n2 + 1, ty + h + 1, -1);
        g.fill(tx - 1, ty, tx, ty + h, -1);
        g.fill(tx + n2, ty, tx + n2 + 1, ty + h, -1);
        int y = ty + pad;
        for (int i = 0; i < lines.size(); ++i) {
            String s = (String)lines.get(i);
            int col = (Integer)colors.get(Math.min(i, colors.size() - 1));
            g.drawString(this.font, s, tx + pad, y, col, false);
            Objects.requireNonNull(this.font);
            y += 9 + 1;
        }
    }

    private void showWhitelistTooltip(GuiGraphics g, int mx, int my, boolean whitelist) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        String title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString();
        String mode = whitelist ? Component.translatable((String)"nomadsshell.ui.mode_whitelist").getString() : Component.translatable((String)"nomadsshell.ui.mode_blacklist").getString();
        int pad = 4;
        int w = Math.max(this.font.width(title), this.font.width(mode));
        Objects.requireNonNull(this.font);
        int h = (9 + 1) * 2 + pad * 2;
        int tw = w + pad * 2;
        int tx = mx + 8;
        int ty = my + 8;
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        if (tx + tw > screenW) {
            tx = mx - tw - 8;
        }
        if (ty + h > screenH) {
            ty = my - h - 8;
        }
        g.fill(tx + 2, ty + 2, tx + tw + 2, ty + h + 2, 0x77000000);
        g.fill(tx, ty, tx + tw, ty + h, -870375649);
        g.fill(tx - 1, ty - 1, tx + tw + 1, ty, -1);
        g.fill(tx - 1, ty + h, tx + tw + 1, ty + h + 1, -1);
        g.fill(tx - 1, ty, tx, ty + h, -1);
        g.fill(tx + tw, ty, tx + tw + 1, ty + h, -1);
        int y = ty + pad;
        g.drawString(this.font, title, tx + pad, y, -1, false);
        Objects.requireNonNull(this.font);
        g.drawString(this.font, mode, tx + pad, y += 9 + 1, whitelist ? -11141291 : -43691, false);
    }

    private List<ResourceLocation> getItemTagKeys(ItemStack stack) {
        if (stack.isEmpty()) {
            return List.of();
        }
        return stack.getTags().map(tag -> tag.location()).toList();
    }

    private boolean isEdibleItem(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getFoodProperties((LivingEntity)player) != null;
    }

    private void renderFeedingBehaviorButtons(GuiGraphics g, int x, int contentY, int mouseX, int mouseY) {
        int btn2Color;
        int btn1Color;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        int buttonY = contentY + 4;
        boolean feedOnDamage = WidgetDataHelper.isAutoFeederFeedOnDamage((Player)player);
        boolean waitForFullHunger = WidgetDataHelper.isAutoFeederWaitForFullHunger((Player)player);
        boolean waitForFullDamage = WidgetDataHelper.isAutoFeederWaitForFullDamage((Player)player);
        int btn1X = x + 4;
        int btn1Y = buttonY;
        boolean btn1Hovered = mouseX >= btn1X && mouseX <= btn1X + 40 && mouseY >= btn1Y && mouseY <= btn1Y + 12;
        int n = btn1Color = feedOnDamage ? -11751600 : -14575885;
        if (btn1Hovered) {
            btn1Color = feedOnDamage ? -10044566 : -12409355;
        }
        g.fill(btn1X, btn1Y, btn1X + 40, btn1Y + 12, btn1Color);
        g.fill(btn1X - 1, btn1Y - 1, btn1X + 40 + 1, btn1Y, Theme.slotBorder());
        g.fill(btn1X - 1, btn1Y + 12, btn1X + 40 + 1, btn1Y + 12 + 1, Theme.slotBorder());
        g.fill(btn1X - 1, btn1Y - 1, btn1X, btn1Y + 12 + 1, Theme.slotBorder());
        g.fill(btn1X + 40, btn1Y - 1, btn1X + 40 + 1, btn1Y + 12 + 1, Theme.slotBorder());
        String btn1Text = feedOnDamage ? Component.translatable((String)"nomadsshell.ui.dmg").getString() : Component.translatable((String)"nomadsshell.ui.hung").getString();
        int textColor = Theme.textOnPanel();
        g.drawCenteredString(this.font, btn1Text, btn1X + 20, btn1Y + 2, textColor);
        int btn2X = btn1X + 40 + 2;
        int btn2Y = buttonY;
        boolean btn2Hovered = mouseX >= btn2X && mouseX <= btn2X + 40 && mouseY >= btn2Y && mouseY <= btn2Y + 12;
        int n2 = btn2Color = waitForFullHunger ? -26624 : -11751600;
        if (btn2Hovered) {
            btn2Color = waitForFullHunger ? -18611 : -10044566;
        }
        g.fill(btn2X, btn2Y, btn2X + 40, btn2Y + 12, btn2Color);
        g.fill(btn2X - 1, btn2Y - 1, btn2X + 40 + 1, btn2Y, Theme.slotBorder());
        g.fill(btn2X - 1, btn2Y + 12, btn2X + 40 + 1, btn2Y + 12 + 1, Theme.slotBorder());
        g.fill(btn2X - 1, btn2Y - 1, btn2X, btn2Y + 12 + 1, Theme.slotBorder());
        g.fill(btn2X + 40, btn2Y - 1, btn2X + 40 + 1, btn2Y + 12 + 1, Theme.slotBorder());
        String btn2Text = waitForFullHunger ? Component.translatable((String)"nomadsshell.ui.wait").getString() : Component.translatable((String)"nomadsshell.ui.now").getString();
        g.drawCenteredString(this.font, btn2Text, btn2X + 20, btn2Y + 2, textColor);
        if (feedOnDamage) {
            int btn3Color;
            int btn3X = btn2X + 40 + 2;
            int btn3Y = buttonY;
            boolean btn3Hovered = mouseX >= btn3X && mouseX <= btn3X + 40 && mouseY >= btn3Y && mouseY <= btn3Y + 12;
            int n3 = btn3Color = waitForFullDamage ? -769226 : -11751600;
            if (btn3Hovered) {
                btn3Color = waitForFullDamage ? -38037 : -10044566;
            }
            g.fill(btn3X, btn3Y, btn3X + 40, btn3Y + 12, btn3Color);
            g.fill(btn3X - 1, btn3Y - 1, btn3X + 40 + 1, btn3Y, Theme.slotBorder());
            g.fill(btn3X - 1, btn3Y + 12, btn3X + 40 + 1, btn3Y + 12 + 1, Theme.slotBorder());
            g.fill(btn3X - 1, btn3Y - 1, btn3X, btn3Y + 12 + 1, Theme.slotBorder());
            g.fill(btn3X + 40, btn3Y - 1, btn3X + 40 + 1, btn3Y + 12 + 1, Theme.slotBorder());
            String btn3Text = waitForFullDamage ? Component.translatable((String)"nomadsshell.ui.full").getString() : Component.translatable((String)"nomadsshell.ui.any").getString();
            g.drawCenteredString(this.font, btn3Text, btn3X + 20, btn3Y + 2, textColor);
        }
    }

    private void renderFeedingBehaviorTooltips(GuiGraphics g, int x, int contentY, int mouseX, int mouseY) {
        boolean btn2Hovered;
        boolean btn1Hovered;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        int buttonY = contentY + 4;
        boolean feedOnDamage = WidgetDataHelper.isAutoFeederFeedOnDamage((Player)player);
        boolean waitForFullHunger = WidgetDataHelper.isAutoFeederWaitForFullHunger((Player)player);
        boolean waitForFullDamage = WidgetDataHelper.isAutoFeederWaitForFullDamage((Player)player);
        int btn1X = x + 4;
        int btn1Y = buttonY;
        boolean bl = btn1Hovered = mouseX >= btn1X && mouseX <= btn1X + 40 && mouseY >= btn1Y && mouseY <= btn1Y + 12;
        if (btn1Hovered) {
            String tooltip = feedOnDamage ? Component.translatable((String)"nomadsshell.autofeeder.feed_on_damage").getString() : Component.translatable((String)"nomadsshell.autofeeder.hunger_only").getString();
            this.renderTooltip(g, tooltip, mouseX, mouseY);
        }
        int btn2X = btn1X + 40 + 2;
        int btn2Y = buttonY;
        boolean bl2 = btn2Hovered = mouseX >= btn2X && mouseX <= btn2X + 40 && mouseY >= btn2Y && mouseY <= btn2Y + 12;
        if (btn2Hovered) {
            String tooltip = waitForFullHunger ? Component.translatable((String)"nomadsshell.autofeeder.wait_full_hunger").getString() : Component.translatable((String)"nomadsshell.autofeeder.immediate").getString();
            this.renderTooltip(g, tooltip, mouseX, mouseY);
        }
        if (feedOnDamage) {
            boolean btn3Hovered;
            int btn3X = btn2X + 40 + 2;
            int btn3Y = buttonY;
            boolean bl3 = btn3Hovered = mouseX >= btn3X && mouseX <= btn3X + 40 && mouseY >= btn3Y && mouseY <= btn3Y + 12;
            if (btn3Hovered) {
                String tooltip = waitForFullDamage ? Component.translatable((String)"nomadsshell.autofeeder.wait_full_damage").getString() : Component.translatable((String)"nomadsshell.autofeeder.any_damage").getString();
                this.renderTooltip(g, tooltip, mouseX, mouseY);
            }
        }
    }

    private void renderTooltip(GuiGraphics g, String text, int mouseX, int mouseY) {
        g.pose().pushPose();
        g.pose().translate(0.0f, 0.0f, 1000.0f);
        int textWidth = this.font.width(text);
        int tooltipX = mouseX + 8;
        int tooltipY = mouseY - 8;
        if (tooltipX + textWidth + 4 > g.guiWidth()) {
            tooltipX = mouseX - textWidth - 8;
        }
        if (tooltipY < 0) {
            tooltipY = mouseY + 16;
        }
        g.fill(tooltipX - 2, tooltipY - 2, tooltipX + textWidth + 2, tooltipY + 10, -536870912);
        g.fill(tooltipX - 1, tooltipY - 1, tooltipX + textWidth + 1, tooltipY + 9, -12566464);
        g.drawString(this.font, text, tooltipX, tooltipY, 0xFFFFFF);
        g.pose().popPose();
    }
}

