/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.init;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.util.AutoCraftRecipe;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.ItemStackData;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModDataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"nomadsshell");
    public static final Supplier<DataComponentType<Set<WidgetUnlockSystem.WidgetType>>> UNLOCKED_WIDGETS = DATA_COMPONENTS.register("unlocked_widgets", () -> DataComponentType.builder().persistent(Codec.list(WidgetUnlockSystem.WidgetType.CODEC).xmap(list -> list.isEmpty() ? EnumSet.noneOf(WidgetUnlockSystem.WidgetType.class) : EnumSet.copyOf(list), set -> set.stream().toList())).networkSynchronized(StreamCodec.of((buf, set) -> {
        buf.writeVarInt(set.size());
        for (WidgetUnlockSystem.WidgetType type : set) {
            buf.writeEnum((Enum)type);
        }
    }, buf -> {
        int size = buf.readVarInt();
        EnumSet<WidgetUnlockSystem.WidgetType> set = EnumSet.noneOf(WidgetUnlockSystem.WidgetType.class);
        for (int i = 0; i < size; ++i) {
            set.add((WidgetUnlockSystem.WidgetType)buf.readEnum(WidgetUnlockSystem.WidgetType.class));
        }
        return set;
    })).build());
    public static final Supplier<DataComponentType<List<WidgetUnlockSystem.WidgetType>>> WIDGET_UNLOCK_ORDER = DATA_COMPONENTS.register("widget_unlock_order", () -> DataComponentType.builder().persistent(Codec.list(WidgetUnlockSystem.WidgetType.CODEC)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (WidgetUnlockSystem.WidgetType type : list) {
            buf.writeEnum((Enum)type);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<WidgetUnlockSystem.WidgetType> list = new ArrayList<WidgetUnlockSystem.WidgetType>(size);
        for (int i = 0; i < size; ++i) {
            list.add((WidgetUnlockSystem.WidgetType)buf.readEnum(WidgetUnlockSystem.WidgetType.class));
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<ItemStackData>> TRASH_BIN_ITEM = DATA_COMPONENTS.register("trash_bin_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<List<ItemStackData>>> CRAFTING_TABLE_GRID = DATA_COMPONENTS.register("crafting_table_grid", () -> DataComponentType.builder().persistent(Codec.list(ItemStackData.CODEC).xmap(list -> {
        ArrayList<ItemStackData> out = new ArrayList<ItemStackData>(9);
        for (int i = 0; i < 9; ++i) {
            out.add(i < list.size() ? (ItemStackData)list.get(i) : ItemStackData.EMPTY);
        }
        return out;
    }, list -> list)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(9);
        for (int i = 0; i < 9; ++i) {
            ItemStackData data = i < list.size() ? (ItemStackData)list.get(i) : ItemStackData.EMPTY;
            ItemStackData.STREAM_CODEC.encode(buf, (Object)data);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ItemStackData> list = new ArrayList<ItemStackData>();
        for (int i = 0; i < size; ++i) {
            list.add((ItemStackData)ItemStackData.STREAM_CODEC.decode(buf));
        }
        while (list.size() < 9) {
            list.add(ItemStackData.EMPTY);
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<ItemStackData>> CRAFTING_TABLE_RESULT = DATA_COMPONENTS.register("crafting_table_result", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Boolean>> AUTO_CRAFTER_UNLOCKED = DATA_COMPONENTS.register("auto_crafter_unlocked", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> AUTO_CRAFTER_ENABLED = DATA_COMPONENTS.register("auto_crafter_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<List<AutoCraftRecipe>>> AUTO_CRAFTER_RECIPES = DATA_COMPONENTS.register("auto_crafter_recipes", () -> DataComponentType.builder().persistent(Codec.list(AutoCraftRecipe.CODEC)).networkSynchronized(StreamCodec.of((buf, recipes) -> {
        buf.writeVarInt(recipes.size());
        for (AutoCraftRecipe recipe : recipes) {
            AutoCraftRecipe.STREAM_CODEC.encode(buf, (Object)recipe);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<AutoCraftRecipe> recipes = new ArrayList<AutoCraftRecipe>(size);
        for (int i = 0; i < size; ++i) {
            recipes.add((AutoCraftRecipe)AutoCraftRecipe.STREAM_CODEC.decode(buf));
        }
        return recipes;
    })).build());
    public static final Supplier<DataComponentType<ItemStackData>> FURNACE_INPUT_ITEM = DATA_COMPONENTS.register("furnace_input_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> FURNACE_FUEL_ITEM = DATA_COMPONENTS.register("furnace_fuel_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> FURNACE_OUTPUT_ITEM = DATA_COMPONENTS.register("furnace_output_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_SMELTING_PROGRESS = DATA_COMPONENTS.register("furnace_smelting_progress", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_FUEL_BURN_TIME = DATA_COMPONENTS.register("furnace_fuel_burn_time", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_MAX_FUEL_BURN_TIME = DATA_COMPONENTS.register("furnace_max_fuel_burn_time", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Map<WidgetUnlockSystem.WidgetType, WidgetUnlockSystem.WidgetTier>>> WIDGET_TIERS = DATA_COMPONENTS.register("widget_tiers", () -> DataComponentType.builder().persistent(Codec.unboundedMap(WidgetUnlockSystem.WidgetType.CODEC, WidgetUnlockSystem.WidgetTier.CODEC).xmap(EnumMap::new, map -> map)).networkSynchronized(StreamCodec.of((buf, map) -> {
        buf.writeVarInt(map.size());
        for (Map.Entry entry : map.entrySet()) {
            buf.writeEnum((Enum)entry.getKey());
            buf.writeEnum((Enum)entry.getValue());
        }
    }, buf -> {
        int size = buf.readVarInt();
        EnumMap<WidgetUnlockSystem.WidgetType, WidgetUnlockSystem.WidgetTier> map = new EnumMap<WidgetUnlockSystem.WidgetType, WidgetUnlockSystem.WidgetTier>(WidgetUnlockSystem.WidgetType.class);
        for (int i = 0; i < size; ++i) {
            WidgetUnlockSystem.WidgetType type = (WidgetUnlockSystem.WidgetType)buf.readEnum(WidgetUnlockSystem.WidgetType.class);
            WidgetUnlockSystem.WidgetTier tier = (WidgetUnlockSystem.WidgetTier)buf.readEnum(WidgetUnlockSystem.WidgetTier.class);
            map.put(type, tier);
        }
        return map;
    })).build());
    public static final Supplier<DataComponentType<FluidStackData>> TANK1_FLUID = DATA_COMPONENTS.register("tank1_fluid", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> TANK2_FLUID = DATA_COMPONENTS.register("tank2_fluid", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> TANK3_FLUID = DATA_COMPONENTS.register("tank3_fluid", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> TANK4_FLUID = DATA_COMPONENTS.register("tank4_fluid", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> TANK5_FLUID = DATA_COMPONENTS.register("tank5_fluid", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK1_POTION_ITEM = DATA_COMPONENTS.register("tank1_potion_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK2_POTION_ITEM = DATA_COMPONENTS.register("tank2_potion_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK3_POTION_ITEM = DATA_COMPONENTS.register("tank3_potion_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK4_POTION_ITEM = DATA_COMPONENTS.register("tank4_potion_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK5_POTION_ITEM = DATA_COMPONENTS.register("tank5_potion_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK1_POTION_CONTENTS = DATA_COMPONENTS.register("tank1_potion_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK2_POTION_CONTENTS = DATA_COMPONENTS.register("tank2_potion_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK3_POTION_CONTENTS = DATA_COMPONENTS.register("tank3_potion_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK4_POTION_CONTENTS = DATA_COMPONENTS.register("tank4_potion_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK5_POTION_CONTENTS = DATA_COMPONENTS.register("tank5_potion_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> TANK1_CAPACITY = DATA_COMPONENTS.register("tank1_capacity", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> TANK2_CAPACITY = DATA_COMPONENTS.register("tank2_capacity", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> TANK3_CAPACITY = DATA_COMPONENTS.register("tank3_capacity", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> TANK4_CAPACITY = DATA_COMPONENTS.register("tank4_capacity", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> TANK5_CAPACITY = DATA_COMPONENTS.register("tank5_capacity", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Boolean>> TANK2_UNLOCKED = DATA_COMPONENTS.register("tank2_unlocked", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> TANK3_UNLOCKED = DATA_COMPONENTS.register("tank3_unlocked", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> TANK4_UNLOCKED = DATA_COMPONENTS.register("tank4_unlocked", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> TANK5_UNLOCKED = DATA_COMPONENTS.register("tank5_unlocked", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<List<ItemStackData>>> FURNACE_INPUT_TEMPLATES = DATA_COMPONENTS.register("furnace_input_templates", () -> DataComponentType.builder().persistent(Codec.list(ItemStackData.CODEC).xmap(list -> {
        ArrayList<ItemStackData> out = new ArrayList<ItemStackData>(8);
        for (int i = 0; i < 8; ++i) {
            out.add(i < list.size() ? (ItemStackData)list.get(i) : ItemStackData.EMPTY);
        }
        return out;
    }, list -> list)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(8);
        for (int i = 0; i < 8; ++i) {
            ItemStackData data = i < list.size() ? (ItemStackData)list.get(i) : ItemStackData.EMPTY;
            ItemStackData.STREAM_CODEC.encode(buf, (Object)data);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ItemStackData> list = new ArrayList<ItemStackData>();
        for (int i = 0; i < size; ++i) {
            list.add((ItemStackData)ItemStackData.STREAM_CODEC.decode(buf));
        }
        while (list.size() < 8) {
            list.add(ItemStackData.EMPTY);
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<List<ItemStackData>>> FURNACE_FUEL_TEMPLATES = DATA_COMPONENTS.register("furnace_fuel_templates", () -> DataComponentType.builder().persistent(Codec.list(ItemStackData.CODEC).xmap(list -> {
        ArrayList<ItemStackData> out = new ArrayList<ItemStackData>(8);
        for (int i = 0; i < 8; ++i) {
            out.add(i < list.size() ? (ItemStackData)list.get(i) : ItemStackData.EMPTY);
        }
        return out;
    }, list -> list)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(8);
        for (int i = 0; i < 8; ++i) {
            ItemStackData data = i < list.size() ? (ItemStackData)list.get(i) : ItemStackData.EMPTY;
            ItemStackData.STREAM_CODEC.encode(buf, (Object)data);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ItemStackData> list = new ArrayList<ItemStackData>();
        for (int i = 0; i < size; ++i) {
            list.add((ItemStackData)ItemStackData.STREAM_CODEC.decode(buf));
        }
        while (list.size() < 8) {
            list.add(ItemStackData.EMPTY);
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_EXTRA_TEMPLATE_SLOTS = DATA_COMPONENTS.register("furnace_extra_template_slots", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeVarInt(v.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<Boolean>> FURNACE_INPUT_FROM_BOTH = DATA_COMPONENTS.register("furnace_input_from_both", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, value) -> buf.writeBoolean(value.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<ItemStackData>> FURNACE_PREVIOUS_INPUT_ITEM = DATA_COMPONENTS.register("furnace_previous_input_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_PERF_UPGRADE_LEVEL = DATA_COMPONENTS.register("furnace_perf_upgrade_level", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeVarInt(v.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<List<ResourceLocation>>> FURNACE_INPUT_TAGS = DATA_COMPONENTS.register("furnace_input_tags", () -> DataComponentType.builder().persistent(Codec.list((Codec)ResourceLocation.CODEC)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (ResourceLocation rl : list) {
            ResourceLocation.STREAM_CODEC.encode(buf, (Object)rl);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            list.add((ResourceLocation)ResourceLocation.STREAM_CODEC.decode(buf));
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<Boolean>> FURNACE_INPUT_TAG_WHITELIST = DATA_COMPONENTS.register("furnace_input_tag_whitelist", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, value) -> buf.writeBoolean(value.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<List<ResourceLocation>>> FURNACE_FUEL_TAGS = DATA_COMPONENTS.register("furnace_fuel_tags", () -> DataComponentType.builder().persistent(Codec.list((Codec)ResourceLocation.CODEC)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (ResourceLocation rl : list) {
            ResourceLocation.STREAM_CODEC.encode(buf, (Object)rl);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            list.add((ResourceLocation)ResourceLocation.STREAM_CODEC.decode(buf));
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<Boolean>> FURNACE_FUEL_TAG_WHITELIST = DATA_COMPONENTS.register("furnace_fuel_tag_whitelist", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, value) -> buf.writeBoolean(value.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> FURNACE_LIQUID_FUEL_ENABLED = DATA_COMPONENTS.register("furnace_liquid_fuel_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, value) -> buf.writeBoolean(value.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_LIQUID_FUEL_TARGET_TANK = DATA_COMPONENTS.register("furnace_liquid_fuel_target_tank", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, value) -> buf.writeVarInt(value.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_CAULDRON_COUNT = DATA_COMPONENTS.register("drip_cauldron_count", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<FluidStackData>> DRIP_SOURCE_FLUID_0 = DATA_COMPONENTS.register("drip_source_fluid_0", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> DRIP_SOURCE_FLUID_1 = DATA_COMPONENTS.register("drip_source_fluid_1", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> DRIP_SOURCE_FLUID_2 = DATA_COMPONENTS.register("drip_source_fluid_2", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> DRIP_SOURCE_FLUID_3 = DATA_COMPONENTS.register("drip_source_fluid_3", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidStackData>> DRIP_SOURCE_FLUID_4 = DATA_COMPONENTS.register("drip_source_fluid_4", () -> DataComponentType.builder().persistent(FluidStackData.CODEC).networkSynchronized(FluidStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_CAULDRON_MB_0 = DATA_COMPONENTS.register("drip_cauldron_mb_0", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_CAULDRON_MB_1 = DATA_COMPONENTS.register("drip_cauldron_mb_1", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_CAULDRON_MB_2 = DATA_COMPONENTS.register("drip_cauldron_mb_2", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_CAULDRON_MB_3 = DATA_COMPONENTS.register("drip_cauldron_mb_3", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_CAULDRON_MB_4 = DATA_COMPONENTS.register("drip_cauldron_mb_4", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_PROGRESS_0 = DATA_COMPONENTS.register("drip_progress_0", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_PROGRESS_1 = DATA_COMPONENTS.register("drip_progress_1", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_PROGRESS_2 = DATA_COMPONENTS.register("drip_progress_2", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_PROGRESS_3 = DATA_COMPONENTS.register("drip_progress_3", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_PROGRESS_4 = DATA_COMPONENTS.register("drip_progress_4", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<ItemStackData>> DRIP_BOTTOM_ITEM_0 = DATA_COMPONENTS.register("drip_bottom_item_0", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> DRIP_BOTTOM_ITEM_1 = DATA_COMPONENTS.register("drip_bottom_item_1", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> DRIP_BOTTOM_ITEM_2 = DATA_COMPONENTS.register("drip_bottom_item_2", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> DRIP_BOTTOM_ITEM_3 = DATA_COMPONENTS.register("drip_bottom_item_3", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> DRIP_BOTTOM_ITEM_4 = DATA_COMPONENTS.register("drip_bottom_item_4", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Boolean>> DRIP_AUTO_TRANSFER_ENABLED = DATA_COMPONENTS.register("drip_auto_transfer_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_TARGET_CONTAINER_0 = DATA_COMPONENTS.register("drip_target_container_0", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_TARGET_CONTAINER_1 = DATA_COMPONENTS.register("drip_target_container_1", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_TARGET_CONTAINER_2 = DATA_COMPONENTS.register("drip_target_container_2", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_TARGET_CONTAINER_3 = DATA_COMPONENTS.register("drip_target_container_3", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<Integer>> DRIP_TARGET_CONTAINER_4 = DATA_COMPONENTS.register("drip_target_container_4", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<ItemStackData>> FURNACE_INPUT_TAG_RECORDER_ITEM = DATA_COMPONENTS.register("furnace_input_tag_recorder_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_INPUT_TAG_RECORDER_INDEX = DATA_COMPONENTS.register("furnace_input_tag_recorder_index", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeVarInt(v.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<ItemStackData>> FURNACE_FUEL_TAG_RECORDER_ITEM = DATA_COMPONENTS.register("furnace_fuel_tag_recorder_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> FURNACE_FUEL_TAG_RECORDER_INDEX = DATA_COMPONENTS.register("furnace_fuel_tag_recorder_index", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeVarInt(v.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<CompoundTag>> VIRTUAL_INVENTORY = DATA_COMPONENTS.register("virtual_inventory", () -> DataComponentType.builder().persistent(CompoundTag.CODEC).networkSynchronized(StreamCodec.of((buf, tag) -> buf.writeNbt((Tag)tag), buf -> buf.readNbt())).build());
    public static final Supplier<DataComponentType<List<Integer>>> shell_DIMENSIONS = DATA_COMPONENTS.register("shell_dimensions", () -> DataComponentType.builder().persistent(Codec.list((Codec)Codec.INT).xmap(list -> list.size() == 2 ? list : Arrays.asList(9, 4), list -> list)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(((Integer)list.get(0)).intValue());
        buf.writeVarInt(((Integer)list.get(1)).intValue());
    }, buf -> Arrays.asList(buf.readVarInt(), buf.readVarInt()))).build());
    public static final Supplier<DataComponentType<ItemContainerContents>> shell_CONTENTS = DATA_COMPONENTS.register("shell_contents", () -> DataComponentType.builder().persistent(ItemContainerContents.CODEC).networkSynchronized(ItemContainerContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Map<String, ItemStackData>>> MEMORIZED_SLOTS = DATA_COMPONENTS.register("memorized_slots", () -> DataComponentType.builder().persistent(Codec.unboundedMap((Codec)Codec.STRING, ItemStackData.CODEC).xmap(map -> map == null ? new HashMap() : map, map -> map)).networkSynchronized(StreamCodec.of((buf, map) -> {
        buf.writeVarInt(map.size());
        for (Map.Entry e : map.entrySet()) {
            buf.writeUtf((String)e.getKey());
            ItemStackData.STREAM_CODEC.encode(buf, (Object)((ItemStackData)e.getValue()));
        }
    }, buf -> {
        int size = buf.readVarInt();
        HashMap<String, ItemStackData> map = new HashMap<String, ItemStackData>(size);
        for (int i = 0; i < size; ++i) {
            String key = buf.readUtf();
            ItemStackData val = (ItemStackData)ItemStackData.STREAM_CODEC.decode(buf);
            map.put(key, val);
        }
        return map;
    })).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK1_WATER_CONTENTS = DATA_COMPONENTS.register("tank1_water_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK1_WATER_ITEM = DATA_COMPONENTS.register("tank1_water_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK2_WATER_CONTENTS = DATA_COMPONENTS.register("tank2_water_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK2_WATER_ITEM = DATA_COMPONENTS.register("tank2_water_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK3_WATER_CONTENTS = DATA_COMPONENTS.register("tank3_water_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK3_WATER_ITEM = DATA_COMPONENTS.register("tank3_water_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK4_WATER_CONTENTS = DATA_COMPONENTS.register("tank4_water_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK4_WATER_ITEM = DATA_COMPONENTS.register("tank4_water_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<PotionContents>> TANK5_WATER_CONTENTS = DATA_COMPONENTS.register("tank5_water_contents", () -> DataComponentType.builder().persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> TANK5_WATER_ITEM = DATA_COMPONENTS.register("tank5_water_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Boolean>> GUARDIAN_TORCH_ENABLED = DATA_COMPONENTS.register("guardian_torch_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> GUARDIAN_SNOW_ENABLED = DATA_COMPONENTS.register("guardian_snow_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> GUARDIAN_PIGLIN_ENABLED = DATA_COMPONENTS.register("guardian_piglin_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> GUARDIAN_SLOWFALL_ENABLED = DATA_COMPONENTS.register("guardian_slowfall_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Boolean>> GUARDIAN_INVISIBILITY_ENABLED = DATA_COMPONENTS.register("guardian_invisibility_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<Integer>> TG_PLANT_SLOTS = DATA_COMPONENTS.register("tg_plant_slots", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeVarInt(v.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<Integer>> TG_HARVEST_SLOTS = DATA_COMPONENTS.register("tg_harvest_slots", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeVarInt(v.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<Integer>> TG_SPEED_BONUS = DATA_COMPONENTS.register("tg_speed_bonus", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeVarInt(v.intValue()), buf -> buf.readVarInt())).build());
    public static final Supplier<DataComponentType<List<CompoundTag>>> TG_PLANTS = DATA_COMPONENTS.register("tg_plants", () -> DataComponentType.builder().persistent(Codec.list((Codec)CompoundTag.CODEC).xmap(list -> {
        ArrayList out = new ArrayList(list);
        if (out.size() > 20) {
            out = new ArrayList(out.subList(0, 20));
        }
        return out;
    }, list -> list)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (CompoundTag tag : list) {
            buf.writeNbt((Tag)tag);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>(size);
        for (int i = 0; i < size; ++i) {
            list.add(buf.readNbt());
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<List<ItemStackData>>> TG_HARVEST_BUFFER = DATA_COMPONENTS.register("tg_harvest_buffer", () -> DataComponentType.builder().persistent(Codec.list(ItemStackData.CODEC)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (ItemStackData it : list) {
            ItemStackData.STREAM_CODEC.encode(buf, (Object)it);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ItemStackData> out = new ArrayList<ItemStackData>(size);
        for (int i = 0; i < size; ++i) {
            out.add((ItemStackData)ItemStackData.STREAM_CODEC.decode(buf));
        }
        return out;
    })).build());
    public static final Supplier<DataComponentType<Boolean>> TG_AUTO_PUSH_ENABLED = DATA_COMPONENTS.register("tg_auto_push_enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of((buf, v) -> buf.writeBoolean(v.booleanValue()), buf -> buf.readBoolean())).build());
    public static final Supplier<DataComponentType<ItemStackData>> ANVIL_INPUT_ITEM = DATA_COMPONENTS.register("anvil_input_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> ANVIL_MATERIAL_ITEM = DATA_COMPONENTS.register("anvil_material_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> ANVIL_RESULT_ITEM = DATA_COMPONENTS.register("anvil_result_item", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> ANVIL_REPAIR_COST = DATA_COMPONENTS.register("anvil_repair_cost", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<String>> ANVIL_RENAME_TEXT = DATA_COMPONENTS.register("anvil_rename_text", () -> DataComponentType.builder().persistent((Codec)Codec.STRING).networkSynchronized(StreamCodec.of((buf, text) -> buf.writeUtf(text), buf -> buf.readUtf())).build());
    public static final Supplier<DataComponentType<ItemStackData>> COLLECTOR_ITEM_0 = DATA_COMPONENTS.register("collector_item_0", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> COLLECTOR_ITEM_1 = DATA_COMPONENTS.register("collector_item_1", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> COLLECTOR_ITEM_2 = DATA_COMPONENTS.register("collector_item_2", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> COLLECTOR_ITEM_3 = DATA_COMPONENTS.register("collector_item_3", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> COLLECTOR_ITEM_4 = DATA_COMPONENTS.register("collector_item_4", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<List<ResourceLocation>>> COLLECTOR_TAGS = DATA_COMPONENTS.register("collector_tags", () -> DataComponentType.builder().persistent(Codec.list((Codec)ResourceLocation.CODEC)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (ResourceLocation tag : list) {
            buf.writeResourceLocation(tag);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.readResourceLocation());
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<Boolean>> COLLECTOR_TAG_WHITELIST = DATA_COMPONENTS.register("collector_tag_whitelist", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<ItemStackData>> COLLECTOR_TAG_GHOST = DATA_COMPONENTS.register("collector_tag_ghost", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> AUTO_FEEDER_FOOD_0 = DATA_COMPONENTS.register("auto_feeder_food_0", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> AUTO_FEEDER_FOOD_1 = DATA_COMPONENTS.register("auto_feeder_food_1", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> AUTO_FEEDER_FOOD_2 = DATA_COMPONENTS.register("auto_feeder_food_2", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> AUTO_FEEDER_FOOD_3 = DATA_COMPONENTS.register("auto_feeder_food_3", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<ItemStackData>> AUTO_FEEDER_FOOD_4 = DATA_COMPONENTS.register("auto_feeder_food_4", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<List<ResourceLocation>>> AUTO_FEEDER_TAGS = DATA_COMPONENTS.register("auto_feeder_tags", () -> DataComponentType.builder().persistent(Codec.list((Codec)ResourceLocation.CODEC)).networkSynchronized(StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (ResourceLocation tag : list) {
            buf.writeResourceLocation(tag);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.readResourceLocation());
        }
        return list;
    })).build());
    public static final Supplier<DataComponentType<Boolean>> AUTO_FEEDER_TAG_WHITELIST = DATA_COMPONENTS.register("auto_feeder_tag_whitelist", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<ItemStackData>> AUTO_FEEDER_TAG_GHOST = DATA_COMPONENTS.register("auto_feeder_tag_ghost", () -> DataComponentType.builder().persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Boolean>> AUTO_FEEDER_FEED_ON_DAMAGE = DATA_COMPONENTS.register("auto_feeder_feed_on_damage", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> AUTO_FEEDER_WAIT_FOR_FULL_HUNGER = DATA_COMPONENTS.register("auto_feeder_wait_for_full_hunger", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> AUTO_FEEDER_WAIT_FOR_FULL_DAMAGE = DATA_COMPONENTS.register("auto_feeder_wait_for_full_damage", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());

    public static void register(IEventBus eventBus) {
        DATA_COMPONENTS.register(eventBus);
    }
}

