/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VirtualInventory {
    private final List<ItemStack> items;
    private final int width;
    private final int height;
    private final int totalSlots;

    public VirtualInventory(int width, int height) {
        this.width = width;
        this.height = height;
        this.totalSlots = width * height;
        this.items = new ArrayList<ItemStack>(this.totalSlots);
        for (int i = 0; i < this.totalSlots; ++i) {
            this.items.add(ItemStack.EMPTY);
        }
    }

    public VirtualInventory(int width, int height, List<ItemStack> existingItems) {
        this.width = width;
        this.height = height;
        this.totalSlots = width * height;
        this.items = new ArrayList<ItemStack>(this.totalSlots);
        for (int i = 0; i < this.totalSlots; ++i) {
            if (i < existingItems.size()) {
                this.items.add(existingItems.get(i).copy());
                continue;
            }
            this.items.add(ItemStack.EMPTY);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTotalSlots() {
        return this.totalSlots;
    }

    public boolean isValidSlot(int slot) {
        return slot >= 0 && slot < this.totalSlots;
    }

    public ItemStack getItem(int slot) {
        if (!this.isValidSlot(slot)) {
            return ItemStack.EMPTY;
        }
        return this.items.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (!this.isValidSlot(slot)) {
            return;
        }
        this.items.set(slot, stack.copy());
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack removed;
        if (!this.isValidSlot(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack current = this.items.get(slot);
        if (current.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (current.getCount() <= count) {
            removed = current.copy();
            this.items.set(slot, ItemStack.EMPTY);
        } else {
            removed = current.copy();
            removed.setCount(count);
            current.shrink(count);
        }
        return removed;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (!this.isValidSlot(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack current = this.items.get(slot);
        this.items.set(slot, ItemStack.EMPTY);
        return current;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.totalSlots; ++i) {
            this.items.set(i, ItemStack.EMPTY);
        }
    }

    public void clear() {
        this.clearContent();
    }

    public int findFirstEmptySlot() {
        for (int i = 0; i < this.totalSlots; ++i) {
            if (!this.items.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public ItemStack addItem(ItemStack itemToAdd) {
        int i;
        if (itemToAdd.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remaining = itemToAdd.copy();
        for (i = 0; i < this.totalSlots && !remaining.isEmpty(); ++i) {
            int space;
            int toAdd;
            ItemStack current = this.items.get(i);
            if (current.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)remaining) || (toAdd = Math.min(space = current.getMaxStackSize() - current.getCount(), remaining.getCount())) <= 0) continue;
            current.grow(toAdd);
            remaining.shrink(toAdd);
        }
        for (i = 0; i < this.totalSlots && !remaining.isEmpty(); ++i) {
            if (!this.items.get(i).isEmpty()) continue;
            int maxStackSize = remaining.getMaxStackSize();
            int toAdd = Math.min(remaining.getCount(), maxStackSize);
            ItemStack newStack = remaining.copy();
            newStack.setCount(toAdd);
            this.items.set(i, newStack);
            remaining.shrink(toAdd);
        }
        return remaining.isEmpty() ? ItemStack.EMPTY : remaining;
    }

    public int countItem(Item item) {
        int count = 0;
        for (ItemStack stack : this.items) {
            if (stack.getItem() != item) continue;
            count += stack.getCount();
        }
        return count;
    }

    public CompoundTag save(HolderLookup.Provider registryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("Width", this.width);
        tag.putInt("Height", this.height);
        ListTag itemsTag = new ListTag();
        for (int i = 0; i < this.totalSlots; ++i) {
            ItemStack stack = this.items.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            Tag stackTag = stack.save(registryAccess);
            itemTag.put("Item", stackTag);
            itemsTag.add((Object)itemTag);
        }
        tag.put("Items", (Tag)itemsTag);
        return tag;
    }

    public static VirtualInventory load(CompoundTag tag, HolderLookup.Provider registryAccess) {
        int width = tag.getInt("Width");
        int height = tag.getInt("Height");
        VirtualInventory inventory = new VirtualInventory(width, height);
        if (tag.contains("Items", 9)) {
            ListTag itemsTag = tag.getList("Items", 10);
            for (Tag itemTagRaw : itemsTag) {
                CompoundTag itemTag = (CompoundTag)itemTagRaw;
                int slot = itemTag.getInt("Slot");
                if (!itemTag.contains("Item")) continue;
                Tag stackTag = itemTag.get("Item");
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)stackTag).orElse(ItemStack.EMPTY);
                if (!inventory.isValidSlot(slot)) continue;
                inventory.items.set(slot, stack);
            }
        }
        return inventory;
    }

    public List<ItemStack> getAllItems() {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            copy.add(stack.copy());
        }
        return copy;
    }

    public List<ItemStack> getRowRange(int startRow, int endRow) {
        ArrayList<ItemStack> view = new ArrayList<ItemStack>();
        int actualEndRow = Math.min(endRow, this.height);
        for (int row = startRow; row < actualEndRow; ++row) {
            for (int col = 0; col < this.width; ++col) {
                int slot = row * this.width + col;
                view.add(this.getItem(slot));
            }
        }
        return view;
    }

    public void setRowRange(int startRow, List<ItemStack> items) {
        int itemIndex = 0;
        for (int row = startRow; row < this.height && itemIndex < items.size(); ++row) {
            for (int col = 0; col < this.width && itemIndex < items.size(); ++itemIndex, ++col) {
                int slot = row * this.width + col;
                this.setItem(slot, items.get(itemIndex));
            }
        }
    }
}

