/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.item;

import com.etka.nomadsshell.config.ShellConfig;
import net.minecraft.util.StringRepresentable;

public enum ShellTier implements StringRepresentable
{
    LEATHER("leather"),
    COPPER("copper"),
    IRON("iron"),
    GOLD("gold"),
    EMERALD("emerald"),
    DIAMOND("diamond"),
    DIAMOND_BLOCK("diamond_block"),
    NETHERITE("netherite");

    private final String name;

    private ShellTier(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getRows() {
        return ShellConfig.SERVER.getHeight(this);
    }

    public int getColumns() {
        return ShellConfig.SERVER.getWidth(this);
    }

    public int getTotalSlots() {
        return ShellConfig.SERVER.getTotalSlots(this);
    }

    public String getSerializedName() {
        return this.name;
    }

    public static ShellTier fromString(String name) {
        for (ShellTier tier : ShellTier.values()) {
            if (!tier.name.equals(name)) continue;
            return tier;
        }
        return LEATHER;
    }

    public ShellTier getNextTier() {
        int currentIndex = this.ordinal();
        if (currentIndex < ShellTier.values().length - 1) {
            return ShellTier.values()[currentIndex + 1];
        }
        return this;
    }

    public boolean hasNextTier() {
        return this.ordinal() < ShellTier.values().length - 1;
    }
}

