/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.menu;

import com.etka.nomadsshell.init.ModMenuTypes;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.util.ContainerUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ShellMenu
extends AbstractContainerMenu
implements IShellMenu {
    private final ItemStack shellStack;
    private final Container shellContainer;
    private final ShellTier tier;
    private final int shellSlotCount;

    public ShellMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buffer) {
        super(ModMenuTypes.shell_MENU.get(), containerId);
        Item item;
        ItemStack wornshell = ShellItem.findWornshell(playerInventory.player);
        if (!wornshell.isEmpty() && (item = wornshell.getItem()) instanceof ShellItem) {
            ShellItem ShellItem2 = (ShellItem)item;
            this.tier = ShellItem2.getTier();
            this.shellSlotCount = ContainerUtils.getSafeContainerSize(ShellItem2.getshellSize());
        } else {
            this.tier = ShellTier.LEATHER;
            this.shellSlotCount = this.tier.getTotalSlots();
        }
        this.shellStack = wornshell;
        this.shellContainer = new SimpleContainer(this.shellSlotCount);
        this.setupSlots(playerInventory);
    }

    public ShellMenu(int containerId, Inventory playerInventory, ItemStack shellStack) {
        super(ModMenuTypes.shell_MENU.get(), containerId);
        Item item;
        this.shellStack = shellStack;
        if (!shellStack.isEmpty() && (item = shellStack.getItem()) instanceof ShellItem) {
            ShellItem ShellItem2 = (ShellItem)item;
            this.tier = ShellItem2.getTier();
            this.shellSlotCount = ContainerUtils.getSafeContainerSize(ShellItem2.getshellSize());
        } else {
            this.tier = ShellTier.LEATHER;
            this.shellSlotCount = this.tier.getTotalSlots();
        }
        this.shellContainer = new SimpleContainer(this.shellSlotCount);
        if (!shellStack.isEmpty()) {
            ItemContainerContents contents = ShellItem.getshellContents(shellStack);
            int slotsToLoad = Math.min(this.shellSlotCount, Math.min(contents.getSlots(), 256));
            for (int i = 0; i < slotsToLoad; ++i) {
                this.shellContainer.setItem(i, contents.getStackInSlot(i));
            }
        }
        this.setupSlots(playerInventory);
    }

    public ShellTier getTier() {
        return this.tier;
    }

    public int getshellSlotCount() {
        return this.shellSlotCount;
    }

    @Override
    public Container getshellContainer() {
        return this.shellContainer;
    }

    @Override
    public ItemStack getshellStack() {
        return this.shellStack;
    }

    private void setupSlots(Inventory playerInventory) {
        int rows = this.tier.getRows();
        int columns = this.tier.getColumns();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int slotIndex = col + row * columns;
                int x = 8 + col * 18;
                int y = 18 + row * 18;
                this.addSlot(new shellSlot(this.shellContainer, slotIndex, x, y, playerInventory.player));
            }
        }
        int shellWidth = columns * 18;
        int playerInvWidth = 162;
        int playerInvOffset = Math.max(0, (shellWidth - playerInvWidth) / 2);
        int playerInvStartY = 18 + rows * 18 + 14;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18 + playerInvOffset, playerInvStartY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18 + playerInvOffset, playerInvStartY + 58));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemstack = slotStack.copy();
            if (index < this.shellSlotCount) {
                if (!this.moveItemStackTo(slotStack, this.shellSlotCount, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                Map<String, ItemStack> mem = WidgetDataHelper.getMemorizedSlots(player);
                for (Map.Entry<String, ItemStack> e : mem.entrySet()) {
                    int tgt = Integer.parseInt(e.getKey());
                    ItemStack tpl = e.getValue();
                    if (tpl.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)tpl, (ItemStack)slotStack) || !this.moveItemStackTo(slotStack, tgt, tgt + 1, false) || !slotStack.isEmpty()) continue;
                    break;
                }
                if (!this.moveItemStackTo(slotStack, 0, this.shellSlotCount, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        if (this.shellStack.isEmpty()) {
            return true;
        }
        return player.getInventory().contains(this.shellStack);
    }

    public void syncshellContents() {
        if (!this.shellStack.isEmpty()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < this.shellSlotCount; ++i) {
                ItemStack stackInSlot = this.shellContainer.getItem(i);
                items.add(stackInSlot != null ? stackInSlot : ItemStack.EMPTY);
            }
            ItemContainerContents contents = ContainerUtils.createSafeContainerContents(items);
            ShellItem.setshellContents(this.shellStack, contents);
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.syncshellContents();
    }

    public static class shellSlot
    extends Slot {
        private final int shellIndex;
        private final Player owner;

        public shellSlot(Container container, int slotIndex, int x, int y, Player owner) {
            super(container, slotIndex, x, y);
            this.shellIndex = slotIndex;
            this.owner = owner;
        }

        public boolean mayPlace(ItemStack stack) {
            ItemStack tpl;
            if (stack.getItem() instanceof ShellItem) {
                return false;
            }
            if (this.owner != null && !(tpl = WidgetDataHelper.getMemorizedItemAt(this.owner, this.shellIndex)).isEmpty()) {
                return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)tpl);
            }
            return true;
        }
    }
}

