/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.network.DripstoneSyncPacket;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DripstoneFarmActionPacket(Action action, int slotIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DripstoneFarmActionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"dripstone_farm_action"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DripstoneFarmActionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, a) -> buf.writeEnum((Enum)a), b -> (Action)b.readEnum(Action.class)), DripstoneFarmActionPacket::action, (StreamCodec)ByteBufCodecs.VAR_INT, DripstoneFarmActionPacket::slotIndex, DripstoneFarmActionPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(DripstoneFarmActionPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            switch (packet.action.ordinal()) {
                case 0: {
                    IFluidHandlerItem handler;
                    int drained;
                    FluidStack fs;
                    int idx = Math.max(0, Math.min(4, packet.slotIndex));
                    ItemStack carried = sp.containerMenu.getCarried();
                    if (carried.isEmpty()) {
                        return;
                    }
                    FluidStackData existing = WidgetDataHelper.getDripSourceFluidAt((Player)sp, idx);
                    Optional opt = FluidUtil.getFluidContained((ItemStack)carried);
                    if (!opt.isPresent() || (fs = (FluidStack)opt.get()).isEmpty() || fs.getAmount() < 1000) break;
                    if (!existing.isEmpty()) {
                        if (existing.fluid() == fs.getFluid()) {
                            return;
                        }
                        return;
                    }
                    ItemStack single = carried.copy();
                    single.setCount(1);
                    Optional handlerOpt = FluidUtil.getFluidHandler((ItemStack)single);
                    if (!handlerOpt.isPresent() || (drained = (handler = (IFluidHandlerItem)handlerOpt.get()).drain(new FluidStack(fs.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE).getAmount()) != 1000) break;
                    WidgetDataHelper.setDripSourceFluidAt((Player)sp, idx, new FluidStackData(fs.getFluid(), 1000));
                    WidgetDataHelper.setDripProgressAt((Player)sp, idx, 0);
                    WidgetDataHelper.setDripCauldronMbAt((Player)sp, idx, 0);
                    int originalCount = carried.getCount();
                    ItemStack remainder = handler.getContainer();
                    if (originalCount == 1) {
                        sp.containerMenu.setCarried(remainder);
                    } else {
                        carried.shrink(1);
                        sp.containerMenu.setCarried(carried);
                        ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, remainder);
                        leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover);
                        if (!leftover.isEmpty()) {
                            sp.drop(leftover, false);
                        }
                    }
                    sp.containerMenu.broadcastChanges();
                    DripstoneSyncPacket.sendTo(sp);
                    break;
                }
                case 1: {
                    IFluidHandlerItem handler;
                    int drained;
                    FluidStack fs;
                    int idx = Math.max(0, Math.min(4, packet.slotIndex));
                    ItemStack carried = sp.containerMenu.getCarried();
                    if (carried.isEmpty()) {
                        return;
                    }
                    Optional opt = FluidUtil.getFluidContained((ItemStack)carried);
                    if (!opt.isPresent() || (fs = (FluidStack)opt.get()).isEmpty() || fs.getAmount() < 1000) break;
                    ItemStack single = carried.copy();
                    single.setCount(1);
                    Optional handlerOpt = FluidUtil.getFluidHandler((ItemStack)single);
                    if (!handlerOpt.isPresent() || (drained = (handler = (IFluidHandlerItem)handlerOpt.get()).drain(new FluidStack(fs.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE).getAmount()) != 1000) break;
                    WidgetDataHelper.setDripSourceFluidAt((Player)sp, idx, new FluidStackData(fs.getFluid(), 1000));
                    WidgetDataHelper.setDripProgressAt((Player)sp, idx, 0);
                    WidgetDataHelper.setDripCauldronMbAt((Player)sp, idx, 0);
                    int originalCount = carried.getCount();
                    ItemStack remainder = handler.getContainer();
                    if (originalCount == 1) {
                        sp.containerMenu.setCarried(remainder);
                    } else {
                        carried.shrink(1);
                        sp.containerMenu.setCarried(carried);
                        ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, remainder);
                        leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover);
                        if (!leftover.isEmpty()) {
                            sp.drop(leftover, false);
                        }
                    }
                    sp.containerMenu.broadcastChanges();
                    DripstoneSyncPacket.sendTo(sp);
                    break;
                }
                case 2: {
                    IFluidHandlerItem handler;
                    int filled;
                    Optional handlerOpt;
                    ItemStack carried;
                    int idx = Math.max(0, Math.min(4, packet.slotIndex));
                    int mb = WidgetDataHelper.getDripCauldronMbAt((Player)sp, idx);
                    FluidStackData src = WidgetDataHelper.getDripSourceFluidAt((Player)sp, idx);
                    if (mb < 1000 || src.isEmpty() || (carried = sp.containerMenu.getCarried()).isEmpty() || !carried.is(Items.BUCKET) || carried.getCount() != 1 || !(handlerOpt = FluidUtil.getFluidHandler((ItemStack)carried.copy())).isPresent() || (filled = (handler = (IFluidHandlerItem)handlerOpt.get()).fill(new FluidStack(src.fluid(), 1000), IFluidHandler.FluidAction.EXECUTE)) != 1000) break;
                    ItemStack filledOut = handler.getContainer();
                    sp.containerMenu.setCarried(filledOut);
                    WidgetDataHelper.setDripCauldronMbAt((Player)sp, idx, 0);
                    sp.containerMenu.broadcastChanges();
                    DripstoneSyncPacket.sendTo(sp);
                    break;
                }
                case 3: {
                    ItemStack existing;
                    int idx = Math.max(0, Math.min(4, packet.slotIndex));
                    ItemStack carried = sp.containerMenu.getCarried();
                    if (!carried.is(Items.BUCKET) || carried.getCount() < 1 || !(existing = WidgetDataHelper.getDripBottomItemAt((Player)sp, idx)).isEmpty()) break;
                    WidgetDataHelper.setDripBottomItemAt((Player)sp, idx, new ItemStack((ItemLike)Items.BUCKET, 1));
                    carried.shrink(1);
                    sp.containerMenu.setCarried(carried);
                    sp.containerMenu.broadcastChanges();
                    DripstoneSyncPacket.sendTo(sp);
                    break;
                }
                case 4: {
                    int idx = Math.max(0, Math.min(4, packet.slotIndex));
                    ItemStack bottom = WidgetDataHelper.getDripBottomItemAt((Player)sp, idx);
                    if (bottom.isEmpty()) break;
                    if (sp.containerMenu.getCarried().isEmpty()) {
                        sp.containerMenu.setCarried(bottom);
                    } else {
                        ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, bottom);
                        if (!(leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                            sp.drop(leftover, false);
                        }
                    }
                    WidgetDataHelper.setDripBottomItemAt((Player)sp, idx, ItemStack.EMPTY);
                    sp.containerMenu.broadcastChanges();
                    DripstoneSyncPacket.sendTo(sp);
                    break;
                }
                case 5: {
                    IFluidHandlerItem handler;
                    int filled;
                    ItemStack emptyBucket;
                    Optional handlerOpt;
                    FluidStackData src;
                    int idx = Math.max(0, Math.min(4, packet.slotIndex));
                    ItemStack carried = sp.containerMenu.getCarried();
                    if (carried.isEmpty() || !carried.is(Items.BUCKET) || (src = WidgetDataHelper.getDripSourceFluidAt((Player)sp, idx)).isEmpty() || !(handlerOpt = FluidUtil.getFluidHandler((ItemStack)(emptyBucket = new ItemStack((ItemLike)Items.BUCKET, 1)).copy())).isPresent() || (filled = (handler = (IFluidHandlerItem)handlerOpt.get()).fill(new FluidStack(src.fluid(), 1000), IFluidHandler.FluidAction.EXECUTE)) != 1000) break;
                    ItemStack filledBucket = handler.getContainer();
                    int originalCount = carried.getCount();
                    if (originalCount > 1) {
                        carried.shrink(1);
                        ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, carried);
                        leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover);
                        if (!leftover.isEmpty()) {
                            sp.drop(leftover, false);
                        }
                        sp.containerMenu.setCarried(filledBucket);
                    } else {
                        sp.containerMenu.setCarried(filledBucket);
                    }
                    WidgetDataHelper.setDripSourceFluidAt((Player)sp, idx, FluidStackData.EMPTY);
                    WidgetDataHelper.setDripProgressAt((Player)sp, idx, 0);
                    WidgetDataHelper.setDripCauldronMbAt((Player)sp, idx, 0);
                    sp.containerMenu.broadcastChanges();
                    DripstoneSyncPacket.sendTo(sp);
                    break;
                }
                case 6: {
                    int idx = Math.max(0, Math.min(4, packet.slotIndex));
                    int newTarget = WidgetDataHelper.cycleDripTargetContainerAt((Player)sp, idx);
                    if (newTarget > 0 && !WidgetDataHelper.isDripAutoTransferEnabled((Player)sp)) {
                        WidgetDataHelper.setDripAutoTransferEnabled((Player)sp, true);
                    }
                    sp.containerMenu.broadcastChanges();
                    DripstoneSyncPacket.sendTo(sp);
                }
            }
        });
    }

    public static enum Action {
        FEED_SOURCE_BUCKET,
        FEED_SOURCE_BUCKET_FORCE,
        COLLECT_OUTPUT_BUCKET,
        PLACE_BOTTOM_BUCKET,
        TAKE_BOTTOM_ITEM,
        TAKE_SOURCE_BUCKET,
        CYCLE_TARGET_CONTAINER;

    }
}

