/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.network.FluidTankSyncPacket;
import com.etka.nomadsshell.upgrade.UpgradeCommand;
import com.etka.nomadsshell.upgrade.UpgradeCommandRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ExecuteUpgradeCommandPacket(String commandId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ExecuteUpgradeCommandPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"execute_upgrade_command"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ExecuteUpgradeCommandPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, str) -> buf.writeUtf(str), buf -> buf.readUtf()), ExecuteUpgradeCommandPacket::commandId, ExecuteUpgradeCommandPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ExecuteUpgradeCommandPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ExecuteUpgradeCommandPacket.executeCommand(packet.commandId, serverPlayer);
            }
        });
    }

    private static void executeCommand(String commandId, ServerPlayer player) {
        UpgradeCommand command = UpgradeCommandRegistry.getCommand(commandId);
        if (command == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        if (!command.canExecute(shellStack, player)) {
            return;
        }
        command.execute(shellStack, player);
        if (player != null) {
            FluidTankSyncPacket.sendTo(player);
        }
    }
}

