/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FurnaceSyncPacket(ItemStack inputItem, ItemStack fuelItem, ItemStack outputItem, int smeltingProgress, int fuelBurnTime, int maxFuelBurnTime, List<ItemStack> inputTemplates, List<ItemStack> fuelTemplates, List<ResourceLocation> inputTags, boolean inputWhitelist, List<ResourceLocation> fuelTags, boolean fuelWhitelist, ItemStack inputTagGhost, int inputTagIndex, ItemStack fuelTagGhost, int fuelTagIndex, boolean inputFromBoth, boolean liquidFuelEnabled, int liquidFuelTargetTank) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FurnaceSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"furnace_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FurnaceSyncPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FurnaceSyncPacket>(){

        public FurnaceSyncPacket decode(RegistryFriendlyByteBuf buf) {
            ItemStack in = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            ItemStack fuel = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            ItemStack out = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            int smelt = buf.readVarInt();
            int burn = buf.readVarInt();
            int maxBurn = buf.readVarInt();
            int inTplCount = buf.readVarInt();
            ArrayList<ItemStack> inTpl = new ArrayList<ItemStack>(inTplCount);
            for (int i = 0; i < inTplCount; ++i) {
                inTpl.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
            }
            int fuelTplCount = buf.readVarInt();
            ArrayList<ItemStack> fuTpl = new ArrayList<ItemStack>(fuelTplCount);
            for (int i = 0; i < fuelTplCount; ++i) {
                fuTpl.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
            }
            int inTagCount = buf.readVarInt();
            ArrayList<ResourceLocation> inTags = new ArrayList<ResourceLocation>(inTagCount);
            for (int i = 0; i < inTagCount; ++i) {
                inTags.add((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf));
            }
            boolean inWhite = buf.readBoolean();
            int fuTagCount = buf.readVarInt();
            ArrayList<ResourceLocation> fuTags = new ArrayList<ResourceLocation>(fuTagCount);
            for (int i = 0; i < fuTagCount; ++i) {
                fuTags.add((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf));
            }
            boolean fuWhite = buf.readBoolean();
            ItemStack inGhost = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            int inIdx = buf.readVarInt();
            ItemStack fuGhost = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            int fuIdx = buf.readVarInt();
            boolean fromBoth = buf.readBoolean();
            boolean liqEnabled = buf.readBoolean();
            int liqTarget = buf.readVarInt();
            return new FurnaceSyncPacket(in, fuel, out, smelt, burn, maxBurn, inTpl, fuTpl, inTags, inWhite, fuTags, fuWhite, inGhost, inIdx, fuGhost, fuIdx, fromBoth, liqEnabled, liqTarget);
        }

        public void encode(RegistryFriendlyByteBuf buf, FurnaceSyncPacket pkt) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)pkt.inputItem);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)pkt.fuelItem);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)pkt.outputItem);
            buf.writeVarInt(pkt.smeltingProgress);
            buf.writeVarInt(pkt.fuelBurnTime);
            buf.writeVarInt(pkt.maxFuelBurnTime);
            buf.writeVarInt(pkt.inputTemplates.size());
            for (ItemStack s : pkt.inputTemplates) {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)s);
            }
            buf.writeVarInt(pkt.fuelTemplates.size());
            for (ItemStack s : pkt.fuelTemplates) {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)s);
            }
            buf.writeVarInt(pkt.inputTags.size());
            for (ResourceLocation rl : pkt.inputTags) {
                ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)rl);
            }
            buf.writeBoolean(pkt.inputWhitelist);
            buf.writeVarInt(pkt.fuelTags.size());
            for (ResourceLocation rl : pkt.fuelTags) {
                ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)rl);
            }
            buf.writeBoolean(pkt.fuelWhitelist);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)pkt.inputTagGhost);
            buf.writeVarInt(pkt.inputTagIndex);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)pkt.fuelTagGhost);
            buf.writeVarInt(pkt.fuelTagIndex);
            buf.writeBoolean(pkt.inputFromBoth);
            buf.writeBoolean(pkt.liquidFuelEnabled);
            buf.writeVarInt(pkt.liquidFuelTargetTank);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(FurnaceSyncPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            int i;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            WidgetDataHelper.setFurnaceInputItem((Player)mc.player, packet.inputItem);
            WidgetDataHelper.setFurnaceFuelItem((Player)mc.player, packet.fuelItem);
            WidgetDataHelper.setFurnaceOutputItem((Player)mc.player, packet.outputItem);
            WidgetDataHelper.setFurnaceSmeltingProgress((Player)mc.player, packet.smeltingProgress);
            WidgetDataHelper.setFurnaceFuelBurnTime((Player)mc.player, packet.fuelBurnTime);
            WidgetDataHelper.setFurnaceMaxFuelBurnTime((Player)mc.player, packet.maxFuelBurnTime);
            for (i = 0; i < Math.min(8, packet.inputTemplates.size()); ++i) {
                WidgetDataHelper.setFurnaceInputTemplate((Player)mc.player, i, packet.inputTemplates.get(i));
            }
            for (i = 0; i < Math.min(8, packet.fuelTemplates.size()); ++i) {
                WidgetDataHelper.setFurnaceFuelTemplate((Player)mc.player, i, packet.fuelTemplates.get(i));
            }
            WidgetDataHelper.setFurnaceInputTags((Player)mc.player, packet.inputTags);
            WidgetDataHelper.setFurnaceInputTagWhitelist((Player)mc.player, packet.inputWhitelist);
            WidgetDataHelper.setFurnaceFuelTags((Player)mc.player, packet.fuelTags);
            WidgetDataHelper.setFurnaceFuelTagWhitelist((Player)mc.player, packet.fuelWhitelist);
            WidgetDataHelper.setInputTagRecorderGhost((Player)mc.player, packet.inputTagGhost);
            WidgetDataHelper.setInputTagRecorderIndex((Player)mc.player, packet.inputTagIndex);
            WidgetDataHelper.setFuelTagRecorderGhost((Player)mc.player, packet.fuelTagGhost);
            WidgetDataHelper.setFuelTagRecorderIndex((Player)mc.player, packet.fuelTagIndex);
            WidgetDataHelper.setFurnaceInputFromBoth((Player)mc.player, packet.inputFromBoth);
            WidgetDataHelper.setFurnaceLiquidFuelEnabled((Player)mc.player, packet.liquidFuelEnabled);
            WidgetDataHelper.setFurnaceLiquidFuelTargetTank((Player)mc.player, packet.liquidFuelTargetTank);
        });
    }

    public static FurnaceSyncPacket fromServerPlayer(ServerPlayer sp) {
        ItemStack in = WidgetDataHelper.getFurnaceInputItem((Player)sp);
        ItemStack fuel = WidgetDataHelper.getFurnaceFuelItem((Player)sp);
        ItemStack out = WidgetDataHelper.getFurnaceOutputItem((Player)sp);
        int smelt = WidgetDataHelper.getFurnaceSmeltingProgress((Player)sp);
        int burn = WidgetDataHelper.getFurnaceFuelBurnTime((Player)sp);
        int maxBurn = WidgetDataHelper.getFurnaceMaxFuelBurnTime((Player)sp);
        List<Object> inTpl = new ArrayList<ItemStack>(WidgetDataHelper.getFurnaceInputTemplates((Player)sp));
        while (inTpl.size() < 8) {
            inTpl.add(ItemStack.EMPTY);
        }
        inTpl = inTpl.subList(0, Math.min(8, inTpl.size()));
        List<Object> fuTpl = new ArrayList<ItemStack>(WidgetDataHelper.getFurnaceFuelTemplates((Player)sp));
        while (fuTpl.size() < 8) {
            fuTpl.add(ItemStack.EMPTY);
        }
        fuTpl = fuTpl.subList(0, Math.min(8, fuTpl.size()));
        List<ResourceLocation> inTags = WidgetDataHelper.getFurnaceInputTags((Player)sp);
        boolean inWhite = WidgetDataHelper.isFurnaceInputTagWhitelist((Player)sp);
        List<ResourceLocation> fuTags = WidgetDataHelper.getFurnaceFuelTags((Player)sp);
        boolean fuWhite = WidgetDataHelper.isFurnaceFuelTagWhitelist((Player)sp);
        ItemStack inGhost = WidgetDataHelper.getInputTagRecorderGhost((Player)sp);
        int inIdx = WidgetDataHelper.getInputTagRecorderIndex((Player)sp);
        ItemStack fuGhost = WidgetDataHelper.getFuelTagRecorderGhost((Player)sp);
        int fuIdx = WidgetDataHelper.getFuelTagRecorderIndex((Player)sp);
        boolean fromBoth = WidgetDataHelper.getFurnaceInputFromBoth((Player)sp);
        boolean liqEnabled = WidgetDataHelper.isFurnaceLiquidFuelEnabled((Player)sp);
        int liqTarget = WidgetDataHelper.getFurnaceLiquidFuelTargetTank((Player)sp);
        return new FurnaceSyncPacket(in, fuel, out, smelt, burn, maxBurn, inTpl, fuTpl, inTags, inWhite, fuTags, fuWhite, inGhost, inIdx, fuGhost, fuIdx, fromBoth, liqEnabled, liqTarget);
    }

    public static void sendTo(ServerPlayer sp) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)FurnaceSyncPacket.fromServerPlayer(sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

