/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GuardianSyncPacket(boolean torch, boolean snow, boolean piglin, boolean slowfall, boolean invisibility) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GuardianSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GuardianSyncPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, GuardianSyncPacket>(){

        public GuardianSyncPacket decode(RegistryFriendlyByteBuf buf) {
            boolean torch = buf.readBoolean();
            boolean snow = buf.readBoolean();
            boolean piglin = buf.readBoolean();
            boolean slowfall = buf.readBoolean();
            boolean invis = buf.readBoolean();
            return new GuardianSyncPacket(torch, snow, piglin, slowfall, invis);
        }

        public void encode(RegistryFriendlyByteBuf buf, GuardianSyncPacket pkt) {
            buf.writeBoolean(pkt.torch());
            buf.writeBoolean(pkt.snow());
            buf.writeBoolean(pkt.piglin());
            buf.writeBoolean(pkt.slowfall());
            buf.writeBoolean(pkt.invisibility());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GuardianSyncPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            if (ShellItem.findWornshell((Player)mc.player).isEmpty()) {
                return;
            }
            WidgetDataHelper.setGuardianTorchEnabled((Player)mc.player, packet.torch());
            WidgetDataHelper.setGuardianSnowEnabled((Player)mc.player, packet.snow());
            WidgetDataHelper.setGuardianPiglinEnabled((Player)mc.player, packet.piglin());
            WidgetDataHelper.setGuardianSlowfallEnabled((Player)mc.player, packet.slowfall());
            WidgetDataHelper.setGuardianInvisibilityEnabled((Player)mc.player, packet.invisibility());
        });
    }

    public static GuardianSyncPacket fromServer(ServerPlayer sp) {
        return new GuardianSyncPacket(WidgetDataHelper.isGuardianTorchEnabled((Player)sp), WidgetDataHelper.isGuardianSnowEnabled((Player)sp), WidgetDataHelper.isGuardianPiglinEnabled((Player)sp), WidgetDataHelper.isGuardianSlowfallEnabled((Player)sp), WidgetDataHelper.isGuardianInvisibilityEnabled((Player)sp));
    }

    public static void sendTo(ServerPlayer sp) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)GuardianSyncPacket.fromServer(sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

