/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.network.DripstoneSyncPacket;
import com.etka.nomadsshell.util.ContainerUtils;
import com.etka.nomadsshell.util.InventoryUtils;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PurchaseDripstoneCauldronPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PurchaseDripstoneCauldronPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"purchase_dripstone_cauldron"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PurchaseDripstoneCauldronPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {}, buf -> new PurchaseDripstoneCauldronPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PurchaseDripstoneCauldronPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PurchaseDripstoneCauldronPacket.handleOnServer(player);
            }
        });
    }

    private static void handleOnServer(ServerPlayer player) {
        AbstractContainerMenu st;
        int have;
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shell)) {
            return;
        }
        int count = (Integer)shell.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
        if (count >= 5) {
            return;
        }
        boolean isCreative = player.getAbilities().instabuild;
        if (!isCreative && (have = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, Items.IRON_INGOT)) < 1) {
            return;
        }
        int remaining = isCreative ? 0 : 1;
        for (int i = 0; i < player.getInventory().getContainerSize() && remaining > 0; ++i) {
            st = player.getInventory().getItem(i);
            if (st.isEmpty() || !st.is(Items.IRON_INGOT)) continue;
            int c = Math.min(remaining, st.getCount());
            st.shrink(c);
            if (st.isEmpty()) {
                player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            remaining -= c;
        }
        if (remaining > 0) {
            st = player.containerMenu;
            if (st instanceof ShellMenu) {
                ShellMenu rm = (ShellMenu)st;
                for (int i = 0; i < rm.getshellSlotCount() && remaining > 0; ++i) {
                    ItemStack st2 = rm.getshellContainer().getItem(i);
                    if (st2.isEmpty() || !st2.is(Items.IRON_INGOT)) continue;
                    int c = Math.min(remaining, st2.getCount());
                    st2.shrink(c);
                    if (st2.isEmpty()) {
                        rm.getshellContainer().setItem(i, ItemStack.EMPTY);
                    }
                    remaining -= c;
                }
            } else {
                int i;
                ItemContainerContents contents = ShellItem.getshellContents(shell);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (i = 0; i < contents.getSlots(); ++i) {
                    items.add(contents.getStackInSlot(i).copy());
                }
                for (i = 0; i < items.size() && remaining > 0; ++i) {
                    ItemStack st3 = (ItemStack)items.get(i);
                    if (st3.isEmpty() || !st3.is(Items.IRON_INGOT)) continue;
                    int c = Math.min(remaining, st3.getCount());
                    st3.shrink(c);
                    if (st3.isEmpty()) {
                        items.set(i, ItemStack.EMPTY);
                    }
                    remaining -= c;
                }
                if (remaining == 0) {
                    ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(items);
                    ShellItem.setshellContents(shell, newContents);
                }
            }
        }
        if (!isCreative && remaining > 0) {
            return;
        }
        int newCount = Math.min(5, count + 1);
        shell.set(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)newCount);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 1.2f);
        DripstoneSyncPacket.sendTo(player);
    }
}

