/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.network.FurnaceSyncPacket;
import com.etka.nomadsshell.util.ContainerUtils;
import com.etka.nomadsshell.util.InventoryUtils;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PurchaseFurnacePerfUpgradePacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PurchaseFurnacePerfUpgradePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"purchase_furnace_perf_upgrade"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PurchaseFurnacePerfUpgradePacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {}, buf -> new PurchaseFurnacePerfUpgradePacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PurchaseFurnacePerfUpgradePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PurchaseFurnacePerfUpgradePacket.handleOnServer(player);
            }
        });
    }

    private static void handleOnServer(ServerPlayer player) {
        AbstractContainerMenu stack;
        int have;
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FURNACE, shell)) {
            return;
        }
        int level = (Integer)shell.getOrDefault(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)0);
        if (level >= 6) {
            return;
        }
        boolean isCreative = player.getAbilities().instabuild;
        if (!isCreative && (have = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, Items.IRON_INGOT)) < 1) {
            return;
        }
        int remaining = isCreative ? 0 : 1;
        for (int i = 0; i < player.getInventory().getContainerSize() && remaining > 0; ++i) {
            stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is(Items.IRON_INGOT)) continue;
            int toConsume = Math.min(remaining, stack.getCount());
            stack.shrink(toConsume);
            if (stack.isEmpty()) {
                player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            remaining -= toConsume;
        }
        if (remaining > 0) {
            stack = player.containerMenu;
            if (stack instanceof ShellMenu) {
                ShellMenu ShellMenu2 = (ShellMenu)stack;
                for (int i = 0; i < ShellMenu2.getshellSlotCount() && remaining > 0; ++i) {
                    ItemStack stack2 = ShellMenu2.getshellContainer().getItem(i);
                    if (stack2.isEmpty() || !stack2.is(Items.IRON_INGOT)) continue;
                    int toConsume = Math.min(remaining, stack2.getCount());
                    stack2.shrink(toConsume);
                    if (stack2.isEmpty()) {
                        ShellMenu2.getshellContainer().setItem(i, ItemStack.EMPTY);
                    }
                    remaining -= toConsume;
                }
            } else {
                int i;
                ItemContainerContents contents = ShellItem.getshellContents(shell);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (i = 0; i < contents.getSlots(); ++i) {
                    items.add(contents.getStackInSlot(i).copy());
                }
                for (i = 0; i < items.size() && remaining > 0; ++i) {
                    ItemStack stack3 = (ItemStack)items.get(i);
                    if (stack3.isEmpty() || !stack3.is(Items.IRON_INGOT)) continue;
                    int toConsume = Math.min(remaining, stack3.getCount());
                    stack3.shrink(toConsume);
                    if (stack3.isEmpty()) {
                        items.set(i, ItemStack.EMPTY);
                    }
                    remaining -= toConsume;
                }
                if (remaining == 0) {
                    ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(items);
                    ShellItem.setshellContents(shell, newContents);
                }
            }
        }
        if (!isCreative && remaining > 0) {
            return;
        }
        int newLevel = Math.min(6, level + 1);
        shell.set(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)newLevel);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 1.1f);
        FurnaceSyncPacket.sendTo(player);
    }
}

